/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChildNodesQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllDocsQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeTraversingQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.AbstractHitCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DescendantSelfAxisQuery
extends Query
implements JcrQuery {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.DescendantSelfAxisQuery");
    private final Query contextQuery;
    private Scorer contextScorer;
    private final Query subQuery;
    private final int minLevels;
    private Scorer subScorer;

    public DescendantSelfAxisQuery(Query context, boolean includeSelf) {
        this(context, (Query)new MatchAllDocsQuery(), includeSelf);
    }

    public DescendantSelfAxisQuery(Query context, Query sub) {
        this(context, sub, true);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, boolean includeSelf) {
        this(context, sub, includeSelf ? 0 : 1);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, int minLevels) {
        this.contextQuery = context;
        this.subQuery = sub;
        this.minLevels = minLevels;
    }

    Query getContextQuery() {
        return this.contextQuery;
    }

    boolean subQueryMatchesAll() {
        return this.subQuery instanceof MatchAllDocsQuery;
    }

    int getMinLevels() {
        return this.minLevels;
    }

    public Weight createWeight(Searcher searcher) {
        return new DescendantSelfAxisWeight(searcher);
    }

    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("DescendantSelfAxisQuery(");
        sb.append(this.contextQuery);
        sb.append(", ");
        sb.append(this.subQuery);
        sb.append(", ");
        sb.append(this.minLevels);
        sb.append(")");
        return sb.toString();
    }

    public void extractTerms(Set terms) {
        this.contextQuery.extractTerms(terms);
        this.subQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        DescendantSelfAxisQuery dsaq;
        Query cQuery = this.contextQuery.rewrite(reader);
        Query sQuery = this.subQuery.rewrite(reader);
        if (this.contextQuery instanceof DescendantSelfAxisQuery && (dsaq = (DescendantSelfAxisQuery)this.contextQuery).subQueryMatchesAll()) {
            return new DescendantSelfAxisQuery(dsaq.getContextQuery(), sQuery, dsaq.getMinLevels() + this.getMinLevels()).rewrite(reader);
        }
        if (cQuery == this.contextQuery && sQuery == this.subQuery) {
            return this;
        }
        return new DescendantSelfAxisQuery(cQuery, sQuery, this.minLevels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHits execute(JcrIndexSearcher searcher, final SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0 && this.subQueryMatchesAll()) {
            TreeMap<String, ScoreNode> startingPoints = new TreeMap<String, ScoreNode>();
            QueryHits result = searcher.evaluate(this.getContextQuery());
            try {
                for (int i = 2; i <= this.getMinLevels(); ++i) {
                    result = new ChildNodesQueryHits(result, session);
                }
                try {
                    ScoreNode sn;
                    while ((sn = result.nextScoreNode()) != null) {
                        Node node = (Node)session.getTransientNodesManager().getItemByIdentifier(sn.getNodeId(), true);
                        startingPoints.put(node.getPath(), sn);
                    }
                }
                catch (RepositoryException e) {
                    throw Util.createIOException(e);
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                result.close();
                throw throwable;
            }
            result.close();
            String previousPath = null;
            Iterator it = startingPoints.keySet().iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (previousPath != null && path.startsWith(previousPath)) {
                    it.remove();
                    continue;
                }
                previousPath = path;
            }
            final Iterator scoreNodes = startingPoints.values().iterator();
            return new AbstractQueryHits(){
                private NodeTraversingQueryHits currentTraversal;
                private SessionDataManager itemMgr;
                {
                    this.itemMgr = session.getTransientNodesManager();
                    this.fetchNextTraversal();
                }

                public void close() throws IOException {
                    if (this.currentTraversal != null) {
                        this.currentTraversal.close();
                    }
                }

                public ScoreNode nextScoreNode() throws IOException {
                    while (this.currentTraversal != null) {
                        ScoreNode sn = this.currentTraversal.nextScoreNode();
                        if (sn != null) {
                            return sn;
                        }
                        this.fetchNextTraversal();
                    }
                    return null;
                }

                private void fetchNextTraversal() throws IOException {
                    if (this.currentTraversal != null) {
                        this.currentTraversal.close();
                    }
                    if (scoreNodes.hasNext()) {
                        ScoreNode sn = (ScoreNode)scoreNodes.next();
                        try {
                            Node node = (Node)session.getTransientNodesManager().getItemByIdentifier(sn.getNodeId(), true);
                            this.currentTraversal = new NodeTraversingQueryHits(node, DescendantSelfAxisQuery.this.getMinLevels() == 0);
                        }
                        catch (RepositoryException e) {
                            throw Util.createIOException(e);
                        }
                    } else {
                        this.currentTraversal = null;
                    }
                }
            };
        }
        return null;
    }

    private class DescendantSelfAxisScorer
    extends Scorer {
        private final HierarchyResolver hResolver;
        private final BitSet contextHits;
        private boolean contextHitsCalculated;
        private int[] ancestorDocs;
        private int[] pDocs;
        private final int[] singleDoc;

        protected DescendantSelfAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.contextHitsCalculated = false;
            this.ancestorDocs = new int[2];
            this.pDocs = new int[1];
            this.singleDoc = new int[1];
            this.hResolver = hResolver;
            this.contextHits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.collectContextHits();
            if (!DescendantSelfAxisQuery.this.subScorer.next() || this.contextHits.isEmpty()) {
                return false;
            }
            int nextDoc = DescendantSelfAxisQuery.this.subScorer.doc();
            while (nextDoc > -1) {
                if (this.isValid(nextDoc)) {
                    return true;
                }
                nextDoc = DescendantSelfAxisQuery.this.subScorer.next() ? DescendantSelfAxisQuery.this.subScorer.doc() : -1;
            }
            return false;
        }

        public int doc() {
            return DescendantSelfAxisQuery.this.subScorer.doc();
        }

        public float score() throws IOException {
            return DescendantSelfAxisQuery.this.subScorer.score();
        }

        public boolean skipTo(int target) throws IOException {
            boolean match = DescendantSelfAxisQuery.this.subScorer.skipTo(target);
            if (match) {
                this.collectContextHits();
                return this.isValid(DescendantSelfAxisQuery.this.subScorer.doc()) || this.next();
            }
            return false;
        }

        private void collectContextHits() throws IOException {
            if (!this.contextHitsCalculated) {
                long time = 0L;
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis();
                }
                DescendantSelfAxisQuery.this.contextScorer.score((Collector)new AbstractHitCollector(){

                    public void collect(int doc, float score) {
                        DescendantSelfAxisScorer.this.contextHits.set(doc);
                    }
                });
                this.contextHitsCalculated = true;
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis() - time;
                    log.debug("Collected {} context hits in {} ms for {}", new Object[]{new Integer(this.contextHits.cardinality()), new Long(time), DescendantSelfAxisQuery.this});
                }
            }
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        private boolean isValid(int doc) throws IOException {
            if (DescendantSelfAxisQuery.this.minLevels == 0 && this.contextHits.get(doc)) {
                return true;
            }
            this.pDocs = this.hResolver.getParents(doc, this.pDocs);
            if (this.pDocs.length == 0 || this.pDocs[0] < 0) {
                return false;
            }
            int ancestorCount = 0;
            this.ancestorDocs[ancestorCount++] = this.pDocs[0];
            while (this.pDocs.length != 0) {
                boolean valid = false;
                for (int i = 0; i < this.pDocs.length; ++i) {
                    int pDoci = this.pDocs[i];
                    if (pDoci < 0 || pDoci > this.contextHits.size() || ancestorCount < DescendantSelfAxisQuery.this.minLevels || !this.contextHits.get(pDoci)) continue;
                    valid = true;
                    break;
                }
                if (valid) break;
                this.pDocs = this.getParents(this.pDocs, this.singleDoc);
                if (ancestorCount == this.ancestorDocs.length) {
                    int[] copy = new int[this.ancestorDocs.length * 2];
                    System.arraycopy(this.ancestorDocs, 0, copy, 0, this.ancestorDocs.length);
                    this.ancestorDocs = copy;
                }
                if (this.pDocs.length == 0) continue;
                this.ancestorDocs[ancestorCount++] = this.pDocs[0];
            }
            if (this.pDocs.length > 0) {
                for (int i = 0; i < ancestorCount; ++i) {
                    this.contextHits.set(this.ancestorDocs[i]);
                }
                return true;
            }
            return false;
        }

        private int[] getParents(int[] docs, int[] pDocs) throws IOException {
            if (docs.length == 1) {
                return this.hResolver.getParents(docs[0], pDocs);
            }
            pDocs = new int[]{};
            for (int i = 0; i < docs.length; ++i) {
                int[] p = this.hResolver.getParents(docs[i], new int[0]);
                int[] tmp = new int[p.length + pDocs.length];
                System.arraycopy(pDocs, 0, tmp, 0, pDocs.length);
                System.arraycopy(p, 0, tmp, pDocs.length, p.length);
                pDocs = tmp;
            }
            return pDocs;
        }
    }

    private class DescendantSelfAxisWeight
    extends Weight {
        private final Searcher searcher;

        private DescendantSelfAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DescendantSelfAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DescendantSelfAxisQuery.this.contextScorer = DescendantSelfAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            DescendantSelfAxisQuery.this.subScorer = DescendantSelfAxisQuery.this.subQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            HierarchyResolver resolver = (HierarchyResolver)reader;
            return new DescendantSelfAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

