/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageType;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.TestUtil;

public class CssLexerTest
extends CajaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testLex() throws Exception {
        CharProducer cp = this.fromResource("csslexerinput1.css");
        this.runTest(cp, TestUtil.readResource(((Object)((Object)this)).getClass(), "csslexergolden1.txt"));
        this.assertMessage(true, MessageType.INVALID_CSS_COMMENT, MessageLevel.LINT, cp.getSourceBreaks(0).toFilePosition(5076, 5093));
        CssLexerTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testUnterminatedStrings() {
        this.assertFails("font-family: 'foo", "1+14 - 18: Unclosed string");
    }

    public final void testLinebreakInString() {
        this.assertFails("font-family: 'foo\nbar'", "1+18: Illegal char in string '\n'");
    }

    public final void testEofInEscape() {
        this.assertFails("font-family: 'foo\\abc", "1+14 - 22: Unclosed string");
    }

    public final void testUnterminatedComment() {
        this.assertFails("foo\nb /* bar ", "2+3 - 10: Unclosed comment");
    }

    public final void testUnterminatedFunction() {
        this.assertFails("url(bar", "1+8: Expected ) not <end-of-input>");
    }

    public final void testMalformedNumber() {
        this.assertFails("100.?", "1+1 - 5: Malformed number 100.");
    }

    public final void testDecodeCssIdentifier() {
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("foo"));
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("f\\6fo"));
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("f\\6f o"));
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("fo\\6f"));
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("f\\6f\\6f"));
        CssLexerTest.assertEquals((String)"ofo", (String)CssLexer.decodeCssIdentifier("\\6f f\\6f"));
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("\\66\\6f\\6f"));
        CssLexerTest.assertEquals((String)"foo", (String)CssLexer.decodeCssIdentifier("\\66 \\6f \\6f "));
    }

    private void assertFails(String input, String golden) {
        try {
            this.runTest(input, "expected failure: " + golden);
            CssLexerTest.fail((String)input);
        }
        catch (ParseException ex) {
            String actual = ex.getCajaMessage().format(this.mc);
            actual = actual.substring(actual.indexOf(58) + 1);
            CssLexerTest.assertEquals((String)golden, (String)actual);
        }
    }

    private void runTest(String input, String golden) throws ParseException {
        this.runTest(this.fromString(input), golden);
    }

    private void runTest(CharProducer cp, String golden) throws ParseException {
        CssLexer lexer = new CssLexer(cp, this.mq, true);
        StringBuilder sb = new StringBuilder();
        while (lexer.hasNext()) {
            Token<CssTokenType> t = lexer.next();
            sb.append(CssLexerTest.abbr(((CssTokenType)t.type).name())).append(" [").append(CssLexerTest.escape(t.text)).append("]: ").append(t.pos).append('\n');
            assert (t.text.length() == t.pos.endCharInFile() - t.pos.startCharInFile()) : t.text + ": " + t.pos;
        }
        CssLexerTest.assertEquals((String)golden.trim(), (String)sb.toString().trim());
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String abbr(String s) {
        int n = s.length();
        return n < 4 ? s + "    ".substring(0, 4 - n) : s.substring(0, 4);
    }
}

