/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.eviction.EvictionActionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentNodeEvictionActionPolicy
implements EvictionActionPolicy {
    Cache<?, ?> cache;
    private static final Log LOG = LogFactory.getLog((String)"exo.jcr.component.core.DefaultEvictionActionPolicy");

    public void setCache(Cache<?, ?> cache) {
        this.cache = cache;
    }

    public boolean evict(Fqn fqn) {
        boolean result;
        block9: {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Evicting Fqn " + fqn));
                }
                this.cache.evict(fqn);
                result = true;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unable to evict " + fqn), (Throwable)e);
                }
                result = false;
            }
            if (fqn.size() != 4) {
                return result;
            }
            Fqn parentFqn = fqn.getParent();
            try {
                NodeSPI node;
                if ((parentFqn.get(1).equals(JBossCacheWorkspaceStorageCache.CHILD_NODES) || parentFqn.get(1).equals(JBossCacheWorkspaceStorageCache.CHILD_PROPS) || parentFqn.get(1).equals(JBossCacheWorkspaceStorageCache.CHILD_NODES_BY_PATTERN_LIST) || parentFqn.get(1).equals(JBossCacheWorkspaceStorageCache.CHILD_PROPS_BY_PATTERN_LIST)) && (node = ((CacheSPI)this.cache).peek(parentFqn, false)) != null && !node.hasChildrenDirect()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Evicting Fqn " + parentFqn));
                    }
                    this.cache.evict(parentFqn);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)("Unable to evict " + parentFqn), (Throwable)e);
            }
        }
        return result;
    }
}

