/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web.fckeditor;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.frameworks.jcr.web.fckeditor.FCKeditorConfigurations;

public class FCKeditor {
    private FCKeditorConfigurations oConfig;
    private String instanceName;
    private String userAgent;
    private String value = "";
    private String basePath;
    private String toolbarSet = "Default";
    private String width = "100%";
    private String height = "200";

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String value) {
        this.instanceName = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String value) {
        this.basePath = value;
    }

    public String getToolbarSet() {
        return this.toolbarSet;
    }

    public void setToolbarSet(String value) {
        this.toolbarSet = value;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String value) {
        this.width = value;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String value) {
        this.height = value;
    }

    public FCKeditorConfigurations getConfig() {
        return this.oConfig;
    }

    public void setConfig(FCKeditorConfigurations value) {
        this.oConfig = value;
    }

    public FCKeditor(HttpServletRequest req) {
        this.userAgent = req.getHeader("user-agent");
        this.basePath = req.getContextPath() + "/FCKeditor/";
        this.oConfig = new FCKeditorConfigurations();
    }

    public FCKeditor(HttpServletRequest req, String parInstanceName) {
        this.userAgent = req.getHeader("user-agent");
        this.basePath = req.getContextPath() + "/FCKeditor/";
        this.instanceName = parInstanceName;
        this.oConfig = new FCKeditorConfigurations();
    }

    public FCKeditor(HttpServletRequest req, String parInstanceName, String parWidth, String parHeight, String parToolbarSet, String parValue) {
        this.userAgent = req.getHeader("user-agent");
        this.basePath = req.getContextPath() + "/FCKeditor/";
        this.instanceName = parInstanceName;
        this.width = parWidth;
        this.height = parHeight;
        this.toolbarSet = parToolbarSet;
        this.value = parValue;
        this.oConfig = new FCKeditorConfigurations();
    }

    private boolean isCompatible() {
        if (this.userAgent == null) {
            return false;
        }
        String userAgentString = this.userAgent.toLowerCase();
        return userAgentString.indexOf("msie") != -1 && userAgentString.indexOf("mac") == -1 && userAgentString.indexOf("opera") == -1 ? this.retrieveBrowserVersion(userAgentString) >= 5.5 : userAgentString.indexOf("gecko") != -1 && this.retrieveBrowserVersion(userAgentString) >= 2.003021E7;
    }

    private double retrieveBrowserVersion(String userAgentString) {
        if (userAgentString.indexOf("msie") > -1) {
            String str = userAgentString.substring(userAgentString.indexOf("msie") + 5);
            return Double.parseDouble(str.substring(0, str.indexOf(";")));
        }
        String str = userAgentString.substring(userAgentString.indexOf("gecko") + 6);
        return Double.parseDouble(str.substring(0, 8));
    }

    private String HTMLEncode(String txt) {
        txt = txt.replaceAll("&", "&amp;");
        txt = txt.replaceAll("<", "&lt;");
        txt = txt.replaceAll(">", "&gt;");
        txt = txt.replaceAll("\"", "&quot;");
        txt = txt.replaceAll("'", "&#146;");
        return txt;
    }

    public String create() {
        StringBuffer strEditor = new StringBuffer();
        strEditor.append("<div>");
        String encodedValue = this.HTMLEncode(this.value);
        if (this.isCompatible()) {
            strEditor.append("<input type=\"hidden\" id=\"" + this.instanceName + "\" name=\"" + this.instanceName + "\" value=\"" + encodedValue + "\">");
            strEditor.append(this.createConfigHTML());
            strEditor.append(this.createIFrameHTML());
        } else {
            strEditor.append("<TEXTAREA name=\"" + this.instanceName + "\" rows=\"4\" cols=\"40\" style=\"WIDTH: " + this.width + "; HEIGHT: " + this.height + "\" wrap=\"virtual\">" + encodedValue + "</TEXTAREA>");
        }
        strEditor.append("</div>");
        return strEditor.toString();
    }

    private String createConfigHTML() {
        String configStr = this.oConfig.getUrlParams();
        if (!configStr.equals("")) {
            configStr = configStr.substring(1);
        }
        return "<input type=\"hidden\" id=\"" + this.instanceName + "___Config\" value=\"" + configStr + "\">";
    }

    private String createIFrameHTML() {
        StringBuilder sLink = new StringBuilder(this.basePath).append("editor/fckeditor.html?InstanceName=").append(this.instanceName);
        if (!this.toolbarSet.equals("")) {
            sLink.append("&Toolbar=").append(this.toolbarSet);
        }
        return "<iframe id=\"" + this.instanceName + "___Frame\" src=\"" + sLink.toString() + "\" width=\"" + this.width + "\" height=\"" + this.height + "\" frameborder=\"no\" scrolling=\"no\"></iframe>";
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

