/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingProxyUriManager;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class SanitizingResponseRewriter
implements ResponseRewriter {
    private static final Logger LOG = Logger.getLogger(SanitizingResponseRewriter.class.getName());
    private final ContentRewriterFeature.Factory featureConfigFactory;
    private final CajaCssSanitizer cssSanitizer;
    private final ProxyUriManager proxyUriManager;

    @Inject
    public SanitizingResponseRewriter(ContentRewriterFeature.Factory featureConfigFactory, CajaCssSanitizer cssSanitizer, ProxyUriManager proxyUriManager) {
        this.featureConfigFactory = featureConfigFactory;
        this.cssSanitizer = cssSanitizer;
        this.proxyUriManager = proxyUriManager;
    }

    public void rewrite(HttpRequest request, HttpResponseBuilder resp) {
        if (request.isSanitizationRequested() && this.featureConfigFactory.get(request).shouldRewriteURL(request.getUri().toString())) {
            if (StringUtils.isEmpty((String)request.getRewriteMimeType())) {
                LOG.log(Level.WARNING, "Request to sanitize without content type for " + request.getUri());
                resp.setContent("");
            } else if (request.getRewriteMimeType().equalsIgnoreCase("text/css")) {
                this.rewriteProxiedCss(request, resp);
            } else if (request.getRewriteMimeType().toLowerCase().startsWith("image/")) {
                this.rewriteProxiedImage(request, resp);
            } else {
                LOG.log(Level.WARNING, "Request to sanitize unknown content type " + request.getRewriteMimeType() + " for " + request.getUri());
                resp.setContent("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteProxiedImage(HttpRequest request, HttpResponseBuilder resp) {
        boolean imageIsSafe = false;
        try {
            String contentType = resp.getHeader("Content-Type");
            if (contentType == null || contentType.toLowerCase().startsWith("image/")) {
                try {
                    ImageFormat imageFormat = Sanselan.guessFormat((ByteSource)new ByteSourceInputStream(resp.getContentBytes(), request.getUri().getPath()));
                    if (imageFormat == ImageFormat.IMAGE_FORMAT_UNKNOWN) {
                        LOG.log(Level.INFO, "Unable to sanitize unknown image type " + request.getUri().toString());
                        return;
                    }
                    imageIsSafe = true;
                    return;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                catch (ImageReadException ire) {
                    LOG.log(Level.INFO, "Unable to detect image type for " + request.getUri().toString() + " for sanitized content", ire);
                    return;
                }
            }
            return;
        }
        finally {
            if (!imageIsSafe) {
                resp.setContent("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteProxiedCss(HttpRequest request, HttpResponseBuilder resp) {
        String sanitized = "";
        try {
            String contentType = resp.getHeader("Content-Type");
            if (contentType == null || contentType.toLowerCase().startsWith("text/")) {
                SanitizingProxyUriManager cssImageRewriter = new SanitizingProxyUriManager(this.proxyUriManager, "image/*");
                SanitizingProxyUriManager cssImportRewriter = new SanitizingProxyUriManager(this.proxyUriManager, "text/css");
                GadgetContext gadgetContext = DomWalker.makeGadget(request).getContext();
                sanitized = this.cssSanitizer.sanitize(resp.getContent(), request.getUri(), gadgetContext, (ProxyUriManager)cssImportRewriter, (ProxyUriManager)cssImageRewriter);
            }
            return;
        }
        finally {
            resp.setContent(sanitized);
        }
    }
}

