/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.sax.OfflineContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRootExtractor {
    private final SAXParserFactory factory = SAXParserFactory.newInstance();

    public XmlRootExtractor() throws SAXException, ParserConfigurationException {
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(false);
        try {
            this.factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
    }

    public QName extractRootElement(byte[] data) {
        ExtractorHandler handler = new ExtractorHandler();
        try {
            this.factory.newSAXParser().parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)new OfflineContentHandler(handler));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.rootElement;
    }

    private static class ExtractorHandler
    extends DefaultHandler {
        private QName rootElement = null;

        private ExtractorHandler() {
        }

        public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
            this.rootElement = new QName(uri, local);
            throw new SAXException("Aborting: root element received");
        }
    }
}

