/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JsdocMessageType implements MessageTypeInt
{
    SCRIPT_FAILED_AT_RUNTIME("Exception thrown in interpreter: %s", MessageLevel.FATAL_ERROR),
    RUNTIME_MESSAGE("Jsdoc: %s", MessageLevel.ERROR),
    ANNOTATION_OUT_OF_PLACE("%s: Annotation %s cannot appear here", MessageLevel.ERROR),
    BAD_LINK("%s: Expected reference or URL, not %s", MessageLevel.ERROR),
    DID_YOU_MEAN("%s: Did you mean \"%s\" instead of \"%s\"", MessageLevel.LINT),
    DUPLICATE_DOCUMENTATION("%s: Documentation conflicts with that at %s", MessageLevel.ERROR),
    EXPECTED_DOCUMENTATION_TEXT("%s: Expected documentation, not %s", MessageLevel.ERROR),
    EXPECTED_EMAIL_OR_NAME("%s: Expected an email or name, not %s", MessageLevel.ERROR),
    EXPECTED_IDENTIFIER("%s: Expected identifier, not %s", MessageLevel.ERROR),
    EXPECTED_TYPE("%s: Expected type, not %s", MessageLevel.ERROR),
    EXPECTED_URL_OR_REFERENCE("%s: Expected URL or reference, not %s", MessageLevel.ERROR),
    UNRECOGNIZED_ANNOTATION("%s: Unrecognized annotation %s", MessageLevel.ERROR),
    UNEXPECTED_CONTENT("%s: Unexpected content for %s", MessageLevel.ERROR);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private JsdocMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }
}

