/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.quasiliteral.AbstractQuasiHole;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrailingUnderscoresHole
extends AbstractQuasiHole {
    private final String trailing;

    public TrailingUnderscoresHole(String identifier, int numberOfUnderscores) {
        super(Identifier.class, identifier);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < numberOfUnderscores; ++i) {
            b.append("_");
        }
        this.trailing = b.toString();
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        Identifier specimen;
        String value;
        if (specimens.size() > 0 && this.isCompatibleClass(specimens.get(0)) && (value = (specimen = (Identifier)specimens.get(0)).getName()) != null && value.endsWith(this.trailing)) {
            specimens.remove(0);
            Identifier shortIdentifier = new Identifier(specimen.getFilePosition(), value.substring(0, value.length() - this.trailing.length()));
            shortIdentifier.getAttributes().putAll(specimen.getAttributes());
            return TrailingUnderscoresHole.putIfDeepEquals(bindings, this.getIdentifier(), shortIdentifier);
        }
        return false;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        ParseTreeNode n = bindings.get(this.getIdentifier());
        if (n == null || !(n instanceof Identifier)) {
            return false;
        }
        Identifier withoutSuffix = (Identifier)n;
        Identifier withSuffix = new Identifier(withoutSuffix.getFilePosition(), n.getValue() + this.trailing);
        withSuffix.getAttributes().putAll(withoutSuffix.getAttributes());
        substitutes.add(withSuffix);
        return true;
    }

    @Override
    protected String getQuantifierSuffix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "(Identifier) : @${" + this.getIdentifier() + "}" + this.trailing;
    }
}

