/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.config.ConfigUtil;
import com.google.caja.config.WhiteList;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import java.util.Set;

class DefaultSchemas {
    static final CssSchema CSS;
    static final HtmlSchema HTML;

    DefaultSchemas() {
    }

    private static WhiteList load(String ... whiteListUrls) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder("{\"inherits\":[");
        boolean first = true;
        for (String url : whiteListUrls) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            Escaping.escapeJsString((CharSequence)url, false, false, sb);
            sb.append('\"');
        }
        sb.append("]}");
        String contentUrl = "content:" + UriUtil.encode(sb.toString());
        EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext());
        return DefaultSchemas.permissive(ConfigUtil.loadWhiteListFromJson(URI.create(contentUrl), ConfigUtil.RESOURCE_RESOLVER, mq));
    }

    private static WhiteList permissive(final WhiteList defs) {
        return new WhiteList(){

            @Override
            public Set<String> allowedItems() {
                return defs.typeDefinitions().keySet();
            }

            @Override
            public Map<String, WhiteList.TypeDefinition> typeDefinitions() {
                return defs.typeDefinitions();
            }
        };
    }

    static {
        try {
            String langDir = "resource:///com/google/caja/lang";
            WhiteList cssProps = DefaultSchemas.load(langDir + "/css/css-extensions-defs.json");
            WhiteList cssFunctions = DefaultSchemas.load(langDir + "/css/css-extensions-fns-defs.json");
            CSS = new CssSchema(cssProps, cssFunctions);
            WhiteList tagList = DefaultSchemas.load(langDir + "/html/html4-elements-defs.json", langDir + "/html/html4-elements-extensions-defs.json");
            WhiteList attribList = DefaultSchemas.load(langDir + "/html/html4-attributes-defs.json", langDir + "/html/html4-attributes-extensions-defs.json");
            HTML = new HtmlSchema(tagList, attribList);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
        catch (ParseException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }
}

