/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import org.gatein.common.util.ParameterValidation;

public class TextTools {
    public static boolean isAlphaNumeric(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static char toHex(int z) throws IllegalArgumentException {
        if (z >= 0 && z < 10) {
            return (char)(48 + z);
        }
        if (z >= 10 && z < 16) {
            return (char)(55 + z);
        }
        throw new IllegalArgumentException("Wrong character");
    }

    public static String replace(String string, String pattern, String replacement) {
        StringBuffer buffer = new StringBuffer(string.length());
        int previous = 0;
        int current = string.indexOf(pattern);
        while (current != -1) {
            buffer.append(string.substring(previous, current));
            buffer.append(replacement);
            previous = current + pattern.length();
            current = string.indexOf(pattern, previous);
        }
        buffer.append(string.substring(previous));
        return buffer.toString();
    }

    public static String replaceAllInstancesOfBoundedString(String initial, String prefix, String suffix, String replacement) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, replacement, true, false, false);
    }

    public static String replaceAllInstancesOfBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, generator, true, false, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        ParameterValidation.throwIllegalArgExceptionIfNull(replacement, "replacement");
        return TextTools.replaceBoundedString(initial, prefix, suffix, new ConstantStringReplacementGenerator(replacement), replaceIfBoundedStringEmpty, keepBoundaries, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries, boolean suffixIsOptional) {
        ParameterValidation.throwIllegalArgExceptionIfNull(replacement, "replacement");
        return TextTools.replaceBoundedString(initial, prefix, suffix, new ConstantStringReplacementGenerator(replacement), replaceIfBoundedStringEmpty, keepBoundaries, suffixIsOptional);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, generator, replaceIfBoundedStringEmpty, keepBoundaries, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries, boolean suffixIsOptional) {
        int suffixLength;
        if (ParameterValidation.isNullOrEmpty(initial)) {
            return initial;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(generator, "StringReplacementGenerator");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(prefix, "prefix", "TextTools.replaceBoundedString");
        StringBuilder tmp = new StringBuilder(initial);
        int prefixIndex = tmp.indexOf(prefix);
        int prefixLength = prefix.length();
        boolean suffixAbsent = suffix == null;
        int n = suffixLength = suffixAbsent ? 0 : suffix.length();
        if (!suffixIsOptional && suffix != null && tmp.indexOf(suffix) == -1) {
            return initial;
        }
        while (prefixIndex != -1) {
            if (suffixAbsent) {
                String match = tmp.substring(prefixIndex + prefixLength);
                if (keepBoundaries) {
                    tmp.insert(prefixIndex + prefixLength, generator.getReplacementFor(match, prefix, suffix, true));
                } else {
                    tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    tmp.insert(prefixIndex, generator.getReplacementFor(match, prefix, suffix, true));
                }
                prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
                continue;
            }
            int suffixIndex = tmp.indexOf(suffix, prefixIndex);
            if (suffixIndex == -1) {
                suffixAbsent = true;
                continue;
            }
            if (suffixIsOptional) {
                int nextPrefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
                if (nextPrefixIndex >= suffixIndex && nextPrefixIndex <= suffixIndex + suffixLength) {
                    nextPrefixIndex = tmp.indexOf(prefix, suffixIndex + suffixLength);
                }
                if (nextPrefixIndex != -1 && nextPrefixIndex <= suffixIndex) {
                    String match = tmp.substring(prefixIndex + prefixLength, nextPrefixIndex);
                    tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    String replacement = generator.getReplacementFor(match, prefix, suffix, true);
                    tmp.insert(prefixIndex, replacement);
                    prefixIndex = nextPrefixIndex - prefixLength + replacement.length();
                    continue;
                }
            }
            if (replaceIfBoundedStringEmpty || suffixIndex != prefixIndex + prefixLength) {
                String match = tmp.substring(prefixIndex + prefixLength, suffixIndex);
                String replacement = generator.getReplacementFor(match, prefix, suffix, false);
                int changeInLength = replacement.length() - match.length();
                int nextLookupIndex = prefixIndex + changeInLength;
                if (keepBoundaries) {
                    if (!suffixAbsent) {
                        tmp.delete(prefixIndex + prefixLength, suffixIndex);
                    }
                    tmp.insert(prefixIndex + prefixLength, replacement);
                    nextLookupIndex += prefixLength + suffixLength;
                } else {
                    if (!suffixAbsent) {
                        tmp.delete(prefixIndex, suffixIndex + suffixLength);
                    } else {
                        tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    }
                    tmp.insert(prefixIndex, replacement);
                }
                prefixIndex = nextLookupIndex;
            }
            prefixIndex = tmp.indexOf(prefix, prefixIndex + 1);
        }
        return tmp.toString();
    }

    public static class ConstantStringReplacementGenerator
    implements StringReplacementGenerator {
        private String replacement;

        public ConstantStringReplacementGenerator(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public String getReplacementFor(String match, String prefix, String suffix, boolean matchedPrefixOnly) {
            return this.replacement;
        }
    }

    public static interface StringReplacementGenerator {
        public String getReplacementFor(String var1, String var2, String var3, boolean var4);
    }
}

