/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test.bandwidth;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BandwidthAllocationTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger("exo.jcr.component.ext.BandwidthAllocationTestCase");
    private static final String ALPHABET = "qwertyuiop[]asdfghjkl;'zxcvbnm,./1234567890-=!@#$%^&*()_+|:?><";
    private static final int RANDOM_VALUE = 1124517;

    public BandwidthAllocationTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
    }

    public StringBuffer createBaseNode(String repoPath, String nodeName) {
        StringBuffer sb = new StringBuffer();
        try {
            Node baseNode = this.addNodePath(repoPath).addNode(nodeName, "nt:unstructured");
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't locked: ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer addEmptyNode(String repoPath, String nodeName, long iterations) {
        StringBuffer sb = new StringBuffer();
        try {
            int i = 0;
            while ((long)i < iterations) {
                String normalizePath = this.getNormalizePath(repoPath);
                Node baseNode = (Node)this.session.getItem(normalizePath);
                Node emptyNode = baseNode.addNode(nodeName + "_" + i, "nt:base");
                this.session.save();
                ++i;
            }
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't locked: ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer addStringPropertyOnly(String repoPath, String nodeName, Long size, long iterations) {
        StringBuffer sb = new StringBuffer();
        try {
            StringBuilder value = new StringBuilder();
            int i = 0;
            while ((long)i < size) {
                int sIndex = (int)(Math.random() * 1124517.0) % ALPHABET.length();
                value.append(ALPHABET.substring(sIndex, sIndex + 1));
                ++i;
            }
            String sValue = value.toString();
            int i2 = 0;
            while ((long)i2 < iterations) {
                String normalizePath = this.getNormalizePath(repoPath);
                Node baseNode = ((Node)this.session.getItem(normalizePath)).getNode(nodeName);
                baseNode.setProperty("d", sValue);
                this.session.save();
                ++i2;
            }
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't add the string propery: ", e);
            sb.append("fail");
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer addBinaryPropertyOnly(String repoPath, String nodeName, Long size, long iterations) {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        File tempFile = null;
        try {
            tempFile = PrivilegedFileHelper.createTempFile("tempF", "_");
            FileOutputStream fos = PrivilegedFileHelper.fileOutputStream(tempFile);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(i % 255);
            }
            for (long i = 0L; i < size / 1024L; ++i) {
                fos.write(buf);
            }
            fos.write(buf, 0, (int)(size % 1024L));
            fos.close();
            long start = System.currentTimeMillis();
            int i = 0;
            while ((long)i < iterations) {
                String normalizePath = this.getNormalizePath(repoPath);
                Node baseNode = ((Node)this.session.getItem(normalizePath)).getNode(nodeName);
                baseNode.setProperty("d", (InputStream)PrivilegedFileHelper.fileInputStream(tempFile));
                this.session.save();
                ++i;
            }
            long end = System.currentTimeMillis();
            log.info("The time of the adding of nt:file + " + iterations + "( " + PrivilegedFileHelper.length(tempFile) + " B ) : " + (double)(end - start) / 1000.0 + " sec");
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't save the binary value : ", e);
            sb.append("fail");
        }
        finally {
            PrivilegedFileHelper.delete(tempFile);
        }
        return sb;
    }
}

