/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.LinkedList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMMembershipListAccess
implements ListAccess<Membership>,
Serializable {
    private static Logger log = LoggerFactory.getLogger(IDMMembershipListAccess.class);
    private final org.picketlink.idm.api.Group group;
    private final User user;
    private int size = -1;
    private Membership lastExisting;

    public IDMMembershipListAccess(org.picketlink.idm.api.Group group) {
        this.group = group;
        this.user = null;
    }

    public IDMMembershipListAccess(User user) {
        this.group = null;
        this.user = user;
    }

    public Membership[] load(int index, int length) throws Exception, IllegalArgumentException {
        int i;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        IdentitySearchCriteria crit = new IdentitySearchCriteriaImpl().page(index, length);
        crit.sort(SortOrder.ASCENDING);
        LinkedList roles = null;
        if (this.group != null) {
            roles = new LinkedList(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.group, null, crit));
        } else if (this.user != null) {
            roles = new LinkedList(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.user, null, crit));
        }
        Membership[] memberships = new Membership[length];
        for (i = 0; i < length; ++i) {
            Role role = (Role)roles.get(i);
            Group exoGroup = ((GroupDAOImpl)this.getOrganizationService().getGroupHandler()).convertGroup(role.getGroup());
            MembershipImpl memb = new MembershipImpl();
            memb.setGroupId(exoGroup.getId());
            memb.setUserName(role.getUser().getId());
            if (role.getRoleType().getName().equals("JBOSS_IDENTITY_MEMBERSHIP")) {
                memb.setMembershipType(this.getOrganizationService().getConfiguration().getAssociationMembershipType());
            } else {
                memb.setMembershipType(role.getRoleType().getName());
            }
            this.lastExisting = memb;
            memberships[i] = memb;
        }
        if (length > roles.size()) {
            while (i < length) {
                memberships[i] = this.lastExisting;
                ++i;
            }
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", memberships);
        }
        return memberships;
    }

    public int getSize() throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        int result = 0;
        if (this.size < 0) {
            if (this.group != null && this.user == null) {
                result = this.getIDMService().getIdentitySession().getRoleManager().getRolesCount((IdentityType)this.group, null, null);
            } else if (this.group == null && this.user != null) {
                result = this.getIDMService().getIdentitySession().getRoleManager().getRolesCount((IdentityType)this.user, null, null);
            }
            this.size = result;
        } else {
            result = this.size;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }

    PicketLinkIDMService getIDMService() {
        return (PicketLinkIDMService)PortalContainer.getInstance().getComponentInstanceOfType(PicketLinkIDMService.class);
    }

    PicketLinkIDMOrganizationServiceImpl getOrganizationService() {
        return (PicketLinkIDMOrganizationServiceImpl)((Object)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class));
    }
}

