/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.servlet.UserAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletUserAgentProvider
implements Provider<UserAgent> {
    private final UserAgent.Parser uaParser;
    private final Provider<HttpServletRequest> reqProvider;

    @Inject
    public HttpServletUserAgentProvider(UserAgent.Parser uaParser, Provider<HttpServletRequest> reqProvider) {
        this.uaParser = uaParser;
        this.reqProvider = reqProvider;
    }

    public UserAgent get() {
        String userAgent;
        HttpServletRequest req = (HttpServletRequest)this.reqProvider.get();
        if (req != null && (userAgent = req.getHeader("User-Agent")) != null) {
            return this.uaParser.parse(userAgent);
        }
        return null;
    }
}

