/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jcr.util.IdGenerator;

public class SybaseMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected String SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE;
    protected String COUNT_NODES_IN_TEMPORARY_TABLE;
    protected String DELETE_TEMPORARY_TABLE_A;
    protected PreparedStatement selectLimitOffsetNodesIntoTemporaryTable;
    protected PreparedStatement deleteTemporaryTableA;

    public SybaseMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected String fixEscapeSymbols(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '[': 
                case ']': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbold());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE = "select TOP ${TOP} I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM into #tempA from JCR_MITEM I (index JCR_PK_MITEM) where I.I_CLASS=1 AND I.ID > ? order by I.ID";
        this.COUNT_NODES_IN_TEMPORARY_TABLE = "select count(*) from #tempA";
        this.FIND_NODES_AND_PROPERTIES = "select #tempA.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_MVALUE V, JCR_MITEM P, #tempA where P.PARENT_ID = #tempA.ID and P.I_CLASS=2 and V.PROPERTY_ID=P.ID order by #tempA.ID";
        this.DELETE_TEMPORARY_TABLE_A = "drop table #tempA";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        ResultSet resultSet;
        block11: {
            String tempTableAName = "tempdb..a" + IdGenerator.generate();
            boolean tempTableACreated = false;
            try {
                if (!this.dbConnection.getAutoCommit()) {
                    this.dbConnection.setAutoCommit(true);
                }
                this.selectLimitOffsetNodesIntoTemporaryTable = this.dbConnection.prepareStatement(this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE.replaceAll("#tempA", tempTableAName).replace("${TOP}", new Integer(offset + limit).toString()));
                if (this.findNodesAndProperties != null) {
                    this.findNodesAndProperties.close();
                }
                this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES.replaceAll("#tempA", tempTableAName));
                this.deleteTemporaryTableA = this.dbConnection.prepareStatement(this.DELETE_TEMPORARY_TABLE_A.replaceAll("#tempA", tempTableAName));
                this.selectLimitOffsetNodesIntoTemporaryTable.setString(1, lastNodeId);
                this.selectLimitOffsetNodesIntoTemporaryTable.execute();
                tempTableACreated = true;
                resultSet = this.findNodesAndProperties.executeQuery();
                Object var8_7 = null;
                if (!tempTableACreated) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var8_8 = null;
                    if (tempTableACreated) {
                        try {
                            this.deleteTemporaryTableA.execute();
                        }
                        catch (SQLException e) {
                            LOG.warn((Object)("Can not delete temporary table " + tempTableAName));
                        }
                    }
                    if (this.selectLimitOffsetNodesIntoTemporaryTable != null) {
                        this.selectLimitOffsetNodesIntoTemporaryTable.close();
                    }
                    if (this.deleteTemporaryTableA == null) break block12;
                    this.deleteTemporaryTableA.close();
                }
                throw throwable;
            }
            try {
                this.deleteTemporaryTableA.execute();
            }
            catch (SQLException e) {
                LOG.warn((Object)("Can not delete temporary table " + tempTableAName));
            }
        }
        if (this.selectLimitOffsetNodesIntoTemporaryTable != null) {
            this.selectLimitOffsetNodesIntoTemporaryTable.close();
        }
        if (this.deleteTemporaryTableA != null) {
            this.deleteTemporaryTableA.close();
        }
        return resultSet;
    }
}

