/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.metadata.RequestParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.metadata.RouteParamDescriptor;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.MalformedRouteException;
import org.exoplatform.web.controller.router.Param;
import org.exoplatform.web.controller.router.Path;
import org.exoplatform.web.controller.router.PathParam;
import org.exoplatform.web.controller.router.PatternBuilder;
import org.exoplatform.web.controller.router.PatternRoute;
import org.exoplatform.web.controller.router.RequestParam;
import org.exoplatform.web.controller.router.RouteParam;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.SegmentRoute;
import org.exoplatform.web.controller.router.URIWriter;
import org.gatein.common.util.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Route {
    private static final Route[] EMPTY_ROUTE_ARRAY = new Route[0];
    private final Router router;
    private Route parent;
    private boolean terminal;
    private Route[] children;
    private final Map<QualifiedName, RouteParam> routeParams;
    private final Map<String, RequestParam> requestParams;

    void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        if (this instanceof SegmentRoute) {
            writer.writeStartElement("segment");
            writer.writeAttribute("path", "/" + ((SegmentRoute)this).name);
            writer.writeAttribute("terminal", "" + this.terminal);
        } else if (this instanceof PatternRoute) {
            PatternRoute pr = (PatternRoute)this;
            StringBuilder path = new StringBuilder("/");
            for (int i = 0; i < pr.params.length; ++i) {
                path.append(pr.chunks[i]).append("{").append(pr.params[i].name.getValue()).append("}");
            }
            path.append(pr.chunks[pr.chunks.length - 1]);
            writer.writeStartElement("pattern");
            writer.writeAttribute("path", path.toString());
            writer.writeAttribute("terminal", Boolean.toString(this.terminal));
            for (PathParam param : pr.params) {
                writer.writeStartElement("path-param");
                writer.writeAttribute("qname", param.name.getValue());
                writer.writeAttribute("encodingMode", param.encodingMode.toString());
                writer.writeAttribute("pattern", param.renderingPattern.toString());
                writer.writeEndElement();
            }
        } else {
            writer.writeStartElement("route");
        }
        for (RouteParam routeParam : this.routeParams.values()) {
            writer.writeStartElement("route-param");
            writer.writeAttribute("qname", routeParam.name.getValue());
            writer.writeAttribute("value", routeParam.value);
            writer.writeEndElement();
        }
        for (RequestParam requestParam : this.requestParams.values()) {
            writer.writeStartElement("request-param");
            writer.writeAttribute("qname", requestParam.name.getValue());
            writer.writeAttribute("name", requestParam.matchName);
            if (requestParam.matchPattern != null) {
                writer.writeAttribute("value", requestParam.matchPattern.pattern());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public String toString() {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            StringWriter sw = new StringWriter();
            XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(sw);
            this.writeTo(xmlWriter);
            return sw.toString();
        }
        catch (XMLStreamException e) {
            throw new AssertionError((Object)e);
        }
    }

    Route(Router router) {
        this.router = router;
        this.parent = null;
        this.terminal = true;
        this.children = EMPTY_ROUTE_ARRAY;
        this.routeParams = new HashMap<QualifiedName, RouteParam>();
        this.requestParams = new HashMap<String, RequestParam>();
    }

    final boolean isTerminal() {
        return this.terminal;
    }

    final void render(Map<QualifiedName, String> blah, URIWriter writer) throws IOException {
        Route r = this.find(blah);
        if (r != null) {
            r.renderPath(blah, writer, false);
            r.renderQueryString(blah, writer);
        }
    }

    private boolean renderPath(Map<QualifiedName, String> blah, URIWriter writer, boolean hasChildren) throws IOException {
        boolean endWithSlash = this.parent != null ? this.parent.renderPath(blah, writer, true) : false;
        if (this instanceof SegmentRoute) {
            SegmentRoute sr = (SegmentRoute)this;
            if (!endWithSlash) {
                writer.append('/');
                endWithSlash = true;
            }
            String name = sr.encodedName;
            writer.append(name);
            if (name.length() > 0) {
                endWithSlash = false;
            }
        } else if (this instanceof PatternRoute) {
            int i;
            PatternRoute pr = (PatternRoute)this;
            if (!endWithSlash) {
                writer.append('/');
                endWithSlash = true;
            }
            int count = 0;
            for (i = 0; i < pr.params.length; ++i) {
                writer.append(pr.encodedChunks[i]);
                count += pr.chunks[i].length();
                PathParam def = pr.params[i];
                String value = blah.get(def.name);
                count += value.length();
                int len = value.length();
                for (int j = 0; j < len; ++j) {
                    char c = value.charAt(j);
                    if (c == this.router.separatorEscape) {
                        if (def.encodingMode == EncodingMode.PRESERVE_PATH) {
                            writer.append('_');
                            continue;
                        }
                        writer.append('%');
                        writer.append(this.router.separatorEscapeNible1);
                        writer.append(this.router.separatorEscapeNible2);
                        continue;
                    }
                    if (c == '/') {
                        writer.append(def.encodingMode == EncodingMode.PRESERVE_PATH ? (char)'/' : this.router.separatorEscape);
                        continue;
                    }
                    writer.appendSegment(c);
                }
            }
            writer.append(pr.encodedChunks[i]);
            if ((count += pr.chunks[i].length()) > 0) {
                endWithSlash = false;
            }
        } else if (!hasChildren) {
            writer.append('/');
            endWithSlash = true;
        }
        return endWithSlash;
    }

    private void renderQueryString(Map<QualifiedName, String> blah, URIWriter writer) throws IOException {
        if (this.parent != null) {
            this.parent.renderQueryString(blah, writer);
        }
        if (this.requestParams.size() > 0) {
            for (RequestParam requestParamDef : this.requestParams.values()) {
                String s = blah.get(requestParamDef.name);
                switch (requestParamDef.valueMapping) {
                    case CANONICAL: {
                        break;
                    }
                    case NEVER_EMPTY: {
                        if (s == null || s.length() != 0) break;
                        s = null;
                        break;
                    }
                    case NEVER_NULL: {
                        if (s != null) break;
                        s = "";
                    }
                }
                if (s == null) continue;
                writer.appendQueryParameter(requestParamDef.matchName, s);
            }
        }
    }

    final Route find(Map<QualifiedName, String> blah) {
        HashMap<QualifiedName, String> abc = new HashMap<QualifiedName, String>(blah);
        for (RouteParam param : this.routeParams.values()) {
            String value = blah.get(param.name);
            if (param.value.equals(value)) {
                abc.remove(param.name);
                continue;
            }
            return null;
        }
        if (this.requestParams.size() > 0) {
            block9: for (RequestParam requestParamDef : this.requestParams.values()) {
                String a = blah.get(requestParamDef.name);
                boolean matched = false;
                if (a != null && requestParamDef.matchValue(a)) {
                    matched = true;
                }
                if (matched) {
                    abc.remove(requestParamDef.name);
                    continue;
                }
                switch (requestParamDef.controlMode) {
                    case OPTIONAL: {
                        continue block9;
                    }
                    case REQUIRED: {
                        return null;
                    }
                }
                throw new AssertionError();
            }
        }
        if (this instanceof PatternRoute) {
            PatternRoute prt = (PatternRoute)this;
            for (int i = 0; i < prt.params.length; ++i) {
                PathParam param = prt.params[i];
                String s = blah.get(param.name);
                boolean matched = false;
                if (s != null) {
                    switch (param.encodingMode) {
                        case FORM: {
                            matched = param.renderingPattern.matcher(s).matches();
                            break;
                        }
                        case PRESERVE_PATH: {
                            matched = param.renderingPattern.matcher(s).matches();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (!matched) {
                    return null;
                }
                abc.remove(param.name);
            }
        }
        if (abc.isEmpty() && this.terminal) {
            return this;
        }
        for (Route route : this.children) {
            Route a = route.find(abc);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    final RouteMatcher route(String path, Map<String, String[]> requestParams) {
        return new RouteMatcher(this, Path.parse(path), requestParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RouteFrame route(RouteFrame root, Map<String, String[]> requestParams) {
        RouteFrame current = root;
        if (root.status == RouteFrame.Status.MATCHED) {
            if (root.parent == null) return null;
            current = root.parent;
        } else if (root.status != RouteFrame.Status.BEGIN) {
            throw new AssertionError((Object)("Unexpected status " + (Object)((Object)root.status)));
        }
        while (true) {
            if (current.status == RouteFrame.Status.BEGIN) {
                boolean matched = true;
                if (((RouteFrame)current).route.requestParams.size() > 0) {
                    for (RequestParam requestParamDef : ((RouteFrame)current).route.requestParams.values()) {
                        String value = null;
                        String[] values = requestParams.get(requestParamDef.matchName);
                        if (values != null && values.length > 0 && values[0] != null) {
                            value = values[0];
                        }
                        if (value == null) {
                            switch (requestParamDef.controlMode) {
                                case OPTIONAL: {
                                    break;
                                }
                                case REQUIRED: {
                                    matched = false;
                                }
                            }
                        } else if (!requestParamDef.matchValue(value)) {
                            matched = false;
                            break;
                        }
                        switch (requestParamDef.valueMapping) {
                            case CANONICAL: {
                                break;
                            }
                            case NEVER_EMPTY: {
                                if (value == null || value.length() != 0) break;
                                value = null;
                                break;
                            }
                            case NEVER_NULL: {
                                if (value != null) break;
                                value = "";
                            }
                        }
                        if (value == null) continue;
                        if (current.matches == null) {
                            current.matches = new HashMap();
                        }
                        current.matches.put(requestParamDef.name, value);
                    }
                }
                if (matched) {
                    current.status = RouteFrame.Status.MATCHED_PARAMS;
                    continue;
                }
                current.status = RouteFrame.Status.END;
                continue;
            }
            if (current.status == RouteFrame.Status.MATCHED_PARAMS) {
                RouteFrame.Status next = current.path.length() > 0 && current.path.charAt(0) == '/' ? (current.path.length() == 1 && ((RouteFrame)current).route.terminal ? RouteFrame.Status.MATCHED : RouteFrame.Status.PROCESS_CHILDREN) : RouteFrame.Status.END;
                current.status = next;
                continue;
            }
            if (current.status == RouteFrame.Status.PROCESS_CHILDREN) {
                if (current.childIndex < ((RouteFrame)current).route.children.length) {
                    RouteFrame next;
                    Route child = ((RouteFrame)current).route.children[current.childIndex++];
                    if (child instanceof SegmentRoute) {
                        SegmentRoute segmentRoute = (SegmentRoute)child;
                        if (segmentRoute.name.length() == 0) {
                            next = new RouteFrame(current, segmentRoute, current.path);
                        } else {
                            String segment;
                            int pos = current.path.indexOf(47, 1);
                            if (pos == -1) {
                                pos = current.path.length();
                            }
                            if (segmentRoute.name.equals(segment = current.path.getValue().substring(1, pos))) {
                                Path nextSegmentPath = pos == current.path.length() ? Path.SLASH : current.path.subPath(pos);
                                next = new RouteFrame(current, segmentRoute, nextSegmentPath);
                            } else {
                                next = null;
                            }
                        }
                    } else {
                        if (!(child instanceof PatternRoute)) throw new AssertionError();
                        PatternRoute patternRoute = (PatternRoute)child;
                        Matcher matcher = patternRoute.pattern.matcher(current.path.getValue());
                        if (matcher.find()) {
                            Path nextPath;
                            int nextPos = matcher.end();
                            if (current.path.length() == nextPos) {
                                nextPath = Path.SLASH;
                            } else {
                                if (nextPos > 0 && current.path.charAt(nextPos - 1) == '/') {
                                    --nextPos;
                                }
                                nextPath = current.path.subPath(nextPos);
                            }
                            next = new RouteFrame(current, patternRoute, nextPath);
                            int group = 1;
                            for (int i = 0; i < patternRoute.params.length; ++i) {
                                PathParam param = patternRoute.params[i];
                                int end = matcher.end(group);
                                if (end != -1) {
                                    String value;
                                    if (param.encodingMode == EncodingMode.FORM) {
                                        StringBuilder sb = new StringBuilder();
                                        for (int from = matcher.start(group); from < end; ++from) {
                                            char c = current.path.charAt(from);
                                            if (c == child.router.separatorEscape && current.path.getRawLength(from) == 1) {
                                                c = '/';
                                            }
                                            sb.append(c);
                                        }
                                        value = sb.toString();
                                    } else {
                                        value = matcher.group(group);
                                    }
                                    if (next.matches == null) {
                                        next.matches = new HashMap();
                                    }
                                    next.matches.put(param.name, value);
                                }
                                ++group;
                            }
                        } else {
                            next = null;
                        }
                    }
                    if (next == null) continue;
                    current = next;
                    continue;
                }
                current.status = RouteFrame.Status.END;
                continue;
            }
            if (current.status == RouteFrame.Status.MATCHED) return current;
            if (current.status != RouteFrame.Status.END) throw new AssertionError();
            if (current.parent == null) return current;
            current = current.parent;
        }
    }

    final <R extends Route> R add(R route) throws MalformedRouteException {
        if (route == null) {
            throw new NullPointerException("No null route accepted");
        }
        if (route.parent != null) {
            throw new IllegalArgumentException("No route with an existing parent can be accepted");
        }
        LinkedList<Param> ancestorParams = new LinkedList<Param>();
        this.findAncestorOrSelfParams(ancestorParams);
        LinkedList<Param> descendantParams = new LinkedList<Param>();
        for (Param param : ancestorParams) {
            super.findDescendantOrSelfParams(param.name, descendantParams);
            if (descendantParams.size() <= 0) continue;
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        if (!(route instanceof PatternRoute) && !(route instanceof SegmentRoute)) {
            throw new IllegalArgumentException("Only accept segment or pattern routes");
        }
        this.children = (Route[])Tools.appendTo((Object[])this.children, route);
        this.terminal = false;
        route.parent = this;
        return route;
    }

    final Set<String> getSegmentNames() {
        HashSet<String> names = new HashSet<String>();
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            names.add(childSegment.name);
        }
        return names;
    }

    final int getSegmentSize(String segmentName) {
        int size = 0;
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            if (!segmentName.equals(childSegment.name)) continue;
            ++size;
        }
        return size;
    }

    final SegmentRoute getSegment(String segmentName, int index) {
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            if (!segmentName.equals(childSegment.name)) continue;
            if (index == 0) {
                return childSegment;
            }
            --index;
        }
        return null;
    }

    final int getPatternSize() {
        int size = 0;
        for (Route route : this.children) {
            if (!(route instanceof PatternRoute)) continue;
            ++size;
        }
        return size;
    }

    final PatternRoute getPattern(int index) {
        for (Route route : this.children) {
            if (!(route instanceof PatternRoute)) continue;
            if (index == 0) {
                return (PatternRoute)route;
            }
            --index;
        }
        return null;
    }

    final Route append(RouteDescriptor descriptor) throws MalformedRouteException {
        Route route = this.append(descriptor.getPathParams(), descriptor.getPath());
        for (RouteParamDescriptor routeParamDesc : descriptor.getRouteParams()) {
            route.add(RouteParam.create(routeParamDesc));
        }
        for (RequestParamDescriptor requestParamDesc : descriptor.getRequestParams()) {
            route.add(RequestParam.create(requestParamDesc));
        }
        for (RouteDescriptor childDescriptor : descriptor.getChildren()) {
            route.append(childDescriptor);
        }
        return route;
    }

    final Route add(RouteParam param) throws MalformedRouteException {
        Param existing = this.findParam(param.name);
        if (existing != null) {
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        this.routeParams.put(param.name, param);
        return this;
    }

    final Route add(RequestParam param) throws MalformedRouteException {
        Param existing = this.findParam(param.name);
        if (existing != null) {
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        this.requestParams.put(param.matchName, param);
        return this;
    }

    private Route append(Map<QualifiedName, PathParamDescriptor> pathParamDescriptors, String path) throws MalformedRouteException {
        Route next;
        if (path.length() == 0 || path.charAt(0) != '/') {
            throw new MalformedRouteException();
        }
        int pos = path.length();
        int level = 0;
        ArrayList<Integer> start = new ArrayList<Integer>();
        ArrayList<Integer> end = new ArrayList<Integer>();
        for (int i = 1; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '{') {
                if (level++ != 0) continue;
                start.add(i);
                continue;
            }
            if (c == '}') {
                if (--level != 0) continue;
                end.add(i);
                continue;
            }
            if (c != '/' || level != 0) continue;
            pos = i;
            break;
        }
        if (start.isEmpty()) {
            String segment = path.substring(1, pos);
            SegmentRoute route = new SegmentRoute(this.router, segment);
            this.add(route);
            next = route;
        } else if (start.size() == end.size()) {
            PatternBuilder builder = new PatternBuilder();
            builder.expr("^").expr('/');
            ArrayList<String> chunks = new ArrayList<String>();
            ArrayList<PathParam> parameterPatterns = new ArrayList<PathParam>();
            int previous = 1;
            for (int i = 0; i < start.size(); ++i) {
                builder.litteral(path, previous, (Integer)start.get(i));
                chunks.add(path.substring(previous, (Integer)start.get(i)));
                String parameterName = path.substring((Integer)start.get(i) + 1, (Integer)end.get(i));
                QualifiedName parameterQName = QualifiedName.parse(parameterName);
                PathParamDescriptor parameterDescriptor = pathParamDescriptors.get(parameterQName);
                PathParam param = parameterDescriptor != null ? PathParam.create(parameterDescriptor) : PathParam.create(parameterQName);
                builder.expr("(").expr(param.routingRegex).expr(")");
                parameterPatterns.add(param);
                previous = (Integer)end.get(i) + 1;
            }
            builder.litteral(path, previous, pos);
            builder.expr("(?:(?<=^/)|(?=/)|$)");
            chunks.add(path.substring(previous, pos));
            PatternRoute route = new PatternRoute(this.router, builder.build(), parameterPatterns, chunks);
            this.add(route);
            next = route;
        } else {
            throw new UnsupportedOperationException("Report error");
        }
        if (pos < path.length()) {
            return super.append(pathParamDescriptors, path.substring(pos));
        }
        return next;
    }

    private Param getParam(QualifiedName name) {
        if (this.routeParams.containsKey(name)) {
            return this.routeParams.get(name);
        }
        for (RequestParam param : this.requestParams.values()) {
            if (!param.name.equals(name)) continue;
            return param;
        }
        if (this instanceof PatternRoute) {
            for (PathParam param : ((PatternRoute)this).params) {
                if (!param.name.equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    private Param findParam(QualifiedName name) {
        Param param = this.getParam(name);
        if (param == null && this.parent != null) {
            param = this.parent.findParam(name);
        }
        return param;
    }

    private void findParams(List<Param> params) {
        for (RouteParam routeParam : this.routeParams.values()) {
            params.add(routeParam);
        }
        for (RequestParam requestParam : this.requestParams.values()) {
            params.add(requestParam);
        }
        if (this instanceof PatternRoute) {
            Collections.addAll(params, ((PatternRoute)this).params);
        }
    }

    private void findAncestorOrSelfParams(List<Param> params) {
        this.findParams(params);
        if (this.parent != null) {
            this.parent.findAncestorOrSelfParams(params);
        }
    }

    private void findDescendantOrSelfParams(QualifiedName name, List<Param> params) {
        Param param = this.getParam(name);
        if (param != null) {
            params.add(param);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteMatcher
    implements Iterator<Map<QualifiedName, String>> {
        private final Map<String, String[]> requestParams;
        private RouteFrame frame;
        private RouteFrame next;

        RouteMatcher(Route route, Path path, Map<String, String[]> requestParams) {
            this.frame = new RouteFrame(route, path);
            this.requestParams = requestParams;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                if (this.frame != null) {
                    this.frame = Route.route(this.frame, this.requestParams);
                }
                if (this.frame != null && this.frame.status == RouteFrame.Status.MATCHED) {
                    this.next = this.frame;
                }
            }
            return this.next != null;
        }

        @Override
        public Map<QualifiedName, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map<QualifiedName, String> parameters = this.next.getParameters();
            this.next = null;
            return parameters;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteFrame {
        private final RouteFrame parent;
        private final Route route;
        private final Path path;
        private Status status;
        private Map<QualifiedName, String> matches;
        private int childIndex;

        private RouteFrame(RouteFrame parent, Route route, Path path) {
            this.parent = parent;
            this.route = route;
            this.path = path;
            this.status = Status.BEGIN;
            this.childIndex = 0;
        }

        private RouteFrame(Route route, Path path) {
            this(null, route, path);
        }

        Map<QualifiedName, String> getParameters() {
            Map<QualifiedName, String> parameters = null;
            RouteFrame frame = this;
            while (frame != null) {
                if (frame.matches != null) {
                    if (parameters == null) {
                        parameters = new HashMap<QualifiedName, String>();
                    }
                    parameters.putAll(frame.matches);
                }
                if (frame.route.routeParams.size() > 0) {
                    if (parameters == null) {
                        parameters = new HashMap<QualifiedName, String>();
                    }
                    for (RouteParam param : frame.route.routeParams.values()) {
                        parameters.put(param.name, param.value);
                    }
                }
                frame = frame.parent;
            }
            return parameters != null ? parameters : Collections.emptyMap();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Status {
            BEGIN,
            MATCHED_PARAMS,
            PROCESS_CHILDREN,
            MATCHED,
            END;

        }
    }
}

