/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="social/people")
public class PeopleRestService
implements ResourceContainer {
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String IGNORED_STATUS = "ignored";
    private static final String WAITING_STATUS = "waiting";
    private static final String ALIEN_STATUS = "alien";
    private static final String INVITE_ACTION = "Invite";
    private static final String ACCEPT_ACTION = "Accept";
    private static final String DENY_ACTION = "Deny";
    private static final String REVOKE_ACTION = "Revoke";
    private static final String REMOVE_ACTION = "Remove";
    private static final String SPACE_MEMBER = "member_of_space";
    private static final String USER_TO_INVITE = "user_to_invite";
    private static final long SUGGEST_LIMIT = 20L;
    private String portalName_;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;

    @GET
    @Path(value="suggest.{format}")
    public Response suggestUsernames(@Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String name, @QueryParam(value="currentUser") String currentUser, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="spaceURL") String spaceURL, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        excludedIdentityList.add(Util.getViewerIdentity(currentUser));
        UserNameList nameList = new UserNameList();
        ProfileFilter filter = new ProfileFilter();
        filter.setName(name);
        filter.setCompany("");
        filter.setGender("");
        filter.setPosition("");
        filter.setSkills("");
        filter.setExcludedIdentityList(excludedIdentityList);
        List<Object> identities = Arrays.asList(this.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, false).load(0, 20));
        Identity currentIdentity = this.getIdentityManager().getOrCreateIdentity("organization", currentUser, false);
        Space space = this.getSpaceService().getSpaceByUrl(spaceURL);
        if (PENDING_STATUS.equals(typeOfRelation)) {
            this.addToNameList(currentIdentity, this.getRelationshipManager().getPending(currentIdentity, identities), nameList);
        } else if (INCOMING_STATUS.equals(typeOfRelation)) {
            this.addToNameList(currentIdentity, this.getRelationshipManager().getIncoming(currentIdentity, identities), nameList);
        } else if (CONFIRMED_STATUS.equals(typeOfRelation)) {
            this.addToNameList(currentIdentity, this.getRelationshipManager().getConfirmed(currentIdentity, identities), nameList);
        } else if (SPACE_MEMBER.equals(typeOfRelation)) {
            this.addSpaceUserToList(identities, nameList, space, typeOfRelation);
        } else if (USER_TO_INVITE.equals(typeOfRelation)) {
            this.addSpaceUserToList(identities, nameList, space, typeOfRelation);
        } else {
            for (Identity identity : identities) {
                nameList.addName(identity.getProfile().getFullName());
            }
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{portalName}/{currentUserName}/getPeopleInfo/{userId}.{format}")
    public Response getPeopleInfo(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="currentUserName") String currentUserName, @PathParam(value="userId") String userId, @PathParam(value="format") String format, @QueryParam(value="updatedType") String updatedType) throws Exception {
        PeopleInfo peopleInfo = new PeopleInfo();
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", userId, false);
        Identity currentIdentity = this.getIdentityManager().getOrCreateIdentity("organization", currentUserName, false);
        if (updatedType != null) {
            Relationship rel = this.getRelationshipManager().get(currentIdentity, identity);
            if (ACCEPT_ACTION.equals(updatedType)) {
                this.getRelationshipManager().confirm(rel);
            } else if (DENY_ACTION.equals(updatedType)) {
                this.getRelationshipManager().deny(rel);
            } else if (REVOKE_ACTION.equals(updatedType)) {
                this.getRelationshipManager().deny(rel);
            } else if (INVITE_ACTION.equals(updatedType)) {
                this.getRelationshipManager().invite(currentIdentity, identity);
            } else if (REMOVE_ACTION.equals(updatedType)) {
                this.getRelationshipManager().remove(rel);
            }
        }
        Relationship relationship = this.getRelationshipManager().get(currentIdentity, identity);
        peopleInfo.setRelationshipType(this.getRelationshipType(relationship, currentIdentity));
        List activities = this.getActivityManager().getActivities(identity);
        if (activities.size() > 0) {
            peopleInfo.setActivityTitle(((ExoSocialActivity)activities.get(0)).getTitle());
        } else {
            peopleInfo.setActivityTitle("Not any updates posted yet.");
        }
        peopleInfo.setAvatarURL((String)identity.getProfile().getProperty("avatarUrl"));
        return Util.getResponse(peopleInfo, uriInfo, mediaType, Response.Status.OK);
    }

    private void addToNameList(Identity currentIdentity, List<Relationship> identitiesHasRelation, UserNameList nameList) {
        for (Relationship relationship : identitiesHasRelation) {
            Identity identity = relationship.getPartner(currentIdentity);
            String fullName = identity.getProfile().getFullName();
            nameList.addName(fullName);
        }
    }

    private void addSpaceUserToList(List<Identity> identities, UserNameList nameList, Space space, String typeOfRelation) throws SpaceException {
        SpaceService spaceSrv = this.getSpaceService();
        for (Identity identity : identities) {
            String fullName = identity.getProfile().getFullName();
            String userName = (String)identity.getProfile().getProperty("username");
            if (SPACE_MEMBER.equals(typeOfRelation) && spaceSrv.isMember(space, userName)) {
                nameList.addName(fullName);
                continue;
            }
            if (!USER_TO_INVITE.equals(typeOfRelation) || spaceSrv.isInvited(space, userName) || spaceSrv.isPending(space, userName) || spaceSrv.isMember(space, userName)) continue;
            nameList.addName(userName);
        }
    }

    private String getRelationshipType(Relationship relationship, Identity identity) {
        if (relationship == null) {
            return ALIEN_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.PENDING) {
            if (relationship.getSender().equals((Object)identity)) {
                return WAITING_STATUS;
            }
            return PENDING_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.CONFIRMED) {
            return CONFIRMED_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.IGNORED) {
            return IGNORED_STATUS;
        }
        return ALIEN_STATUS;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)this.getPortalContainer().getComponentInstanceOfType(ActivityManager.class);
        }
        return this.activityManager;
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private PortalContainer getPortalContainer() {
        PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_);
        if (portalContainer == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return portalContainer;
    }

    @XmlRootElement
    public static class PeopleInfo {
        private String avatarURL;
        private String activityTitle;
        private String relationshipType;

        public String getActivityTitle() {
            return this.activityTitle;
        }

        public void setActivityTitle(String activityTitle) {
            this.activityTitle = activityTitle;
        }

        public String getAvatarURL() {
            return this.avatarURL;
        }

        public void setAvatarURL(String avatarURL) {
            this.avatarURL = avatarURL;
        }

        public String getRelationshipType() {
            return this.relationshipType;
        }

        public void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class UserNameList {
        private List<String> _names;

        public void setNames(List<String> names) {
            this._names = names;
        }

        public List<String> getNames() {
            return this._names;
        }

        public void addName(String name) {
            if (this._names == null) {
                this._names = new ArrayList<String>();
            }
            this._names.add(name);
        }
    }
}

