/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.PerQueryCache;

class MatchAllScorer
extends Scorer {
    private int nextDoc = -1;
    private IndexReader reader;
    private String field;
    private BitSet docFilter;
    private final Explanation matchExpl;

    MatchAllScorer(IndexReader reader, String field) throws IOException {
        super(Similarity.getDefault());
        this.reader = reader;
        this.field = field;
        this.matchExpl = new Explanation(Similarity.getDefault().idf(reader.maxDoc(), reader.maxDoc()), "matchAll");
        this.calculateDocFilter();
    }

    public void score(Collector hc) throws IOException {
        while (this.next()) {
            hc.collect(this.doc());
        }
    }

    public boolean next() throws IOException {
        this.nextDoc = this.docFilter.nextSetBit(this.nextDoc + 1);
        return this.nextDoc > -1;
    }

    public int doc() {
        return this.nextDoc;
    }

    public float score() throws IOException {
        return 1.0f;
    }

    public boolean skipTo(int target) throws IOException {
        this.nextDoc = target - 1;
        return this.next();
    }

    public Explanation explain(int doc) {
        return this.matchExpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDocFilter() throws IOException {
        PerQueryCache cache = PerQueryCache.getInstance();
        HashMap<String, BitSet> readerCache = (HashMap<String, BitSet>)cache.get(MatchAllScorer.class, this.reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, BitSet>();
            cache.put(MatchAllScorer.class, this.reader, readerCache);
        }
        this.docFilter = (BitSet)readerCache.get(this.field);
        if (this.docFilter != null) {
            return;
        }
        this.docFilter = new BitSet(this.reader.maxDoc());
        String namedValue = FieldNames.createNamedValue(this.field, "");
        TermEnum terms = this.reader.terms(new Term(FieldNames.PROPERTIES, namedValue));
        try {
            TermDocs docs = this.reader.termDocs();
            try {
                while (terms.term() != null && terms.term().field() == FieldNames.PROPERTIES && terms.term().text().startsWith(namedValue)) {
                    docs.seek(terms);
                    while (docs.next()) {
                        this.docFilter.set(docs.doc());
                    }
                    terms.next();
                }
            }
            finally {
                docs.close();
            }
        }
        finally {
            terms.close();
        }
        readerCache.put(this.field, this.docFilter);
    }
}

