/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class MySQLSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    protected static final String PATTERN_ESCAPE_STRING = "\\\\";

    public MySQLSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I force index(PRIMARY) where I.CONTAINER_NAME=? AND I.I_CLASS=1 AND I.ID > ? order by I.ID LIMIT ? OFFSET ?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by ID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addNodeRecord(NodeData data) throws SQLException {
        if (data.getParentIdentifier() != null) {
            ResultSet item = this.findItemByIdentifier(this.getInternalId(data.getParentIdentifier()));
            try {
                if (!item.next()) {
                    throw new SQLException("Parent is not found. Behaviour of " + this.JCR_FK_ITEM_PARENT);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        return super.addNodeRecord(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addPropertyRecord(PropertyData data) throws SQLException {
        if (data.getParentIdentifier() != null) {
            ResultSet item = this.findItemByIdentifier(this.getInternalId(data.getParentIdentifier()));
            try {
                if (!item.next()) {
                    throw new SQLException("Parent is not found. Behaviour of " + this.JCR_FK_ITEM_PARENT);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        return super.addPropertyRecord(data);
    }

    protected String getLikeExpressionEscape() {
        return PATTERN_ESCAPE_STRING;
    }
}

