/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIItemSelector.gtmpl")
public class UIItemSelector
extends UIComponent {
    private String name_;
    private List<SelectItemCategory> categories_;

    public UIItemSelector(String name) {
        this.name_ = name;
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        this.categories_ = new ArrayList<SelectItemCategory>();
    }

    public String getName() {
        return this.name_;
    }

    public List<SelectItemCategory> getItemCategories() {
        return this.categories_;
    }

    public void setItemCategories(List<SelectItemCategory> categories) {
        this.categories_ = categories;
        boolean selected = false;
        for (SelectItemCategory ele : categories) {
            if (!ele.isSelected()) continue;
            if (selected) {
                ele.setSelected(false);
                continue;
            }
            selected = true;
        }
        if (!selected) {
            this.categories_.get(0).setSelected(true);
        }
    }

    public SelectItemCategory getSelectedItemCategory() {
        for (SelectItemCategory category : this.categories_) {
            if (!category.isSelected()) continue;
            return category;
        }
        if (this.categories_.size() > 0) {
            SelectItemCategory category = this.categories_.get(0);
            category.setSelected(true);
            ((SelectItemOption)category.getSelectItemOptions().get(0)).setSelected(true);
            return category;
        }
        return null;
    }

    public SelectItemOption getSelectedItemOption() {
        SelectItemCategory selectedCategory = this.getSelectedItemCategory();
        if (selectedCategory != null) {
            return selectedCategory.getSelectedItemOption();
        }
        return null;
    }
}

