/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.PageListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.PageQueryAccessList;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.page.UIPageSearchForm;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBrowser.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPageBrowse.deletePage"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddNewActionListener.class})}), @ComponentConfig(id="UIBrowserPageForm", type=UIPageForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, name="Save"), @EventConfig(listeners={UIPageForm.ChangeOwnerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.ChangeOwnerIdActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="PageTemplate", value="system:/WEB-INF/conf/uiconf/portal/webui/page/PageTemplate.groovy")}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl", events={@EventConfig(listeners={UIFormInputSet.SelectComponentActionListener.class})})})
@Serialized
public class UIPageBrowser
extends UIContainer {
    public static final String[] BEAN_FIELD = new String[]{"pageId", "title", "accessPermissions", "editPermission"};
    public static final String[] ACTIONS = new String[]{"EditInfo", "Delete"};
    private boolean showAddNewPage = false;
    protected String pageSelectedId_;
    private List<SelectItemOption<String>> OPTIONS = new ArrayList<SelectItemOption<String>>(2);
    private Query<Page> lastQuery_;

    public UIPageBrowser() throws Exception {
        WebuiRequestContext contextui = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = contextui.getApplicationResourceBundle();
        this.OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearchForm.label.option.portal"), (Object)"portal"));
        this.OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearchForm.label.option.group"), (Object)"group"));
        UIPageSearchForm uiSearchForm = (UIPageSearchForm)this.addChild(UIPageSearchForm.class, null, null);
        uiSearchForm.setOptions(this.OPTIONS);
        uiSearchForm.setId("UIPageSearchForm");
        UIRepeater uiRepeater = (UIRepeater)this.createUIComponent(UIRepeater.class, null, null);
        uiRepeater.configure("pageId", BEAN_FIELD, ACTIONS);
        this.lastQuery_ = new Query(null, null, null, null, Page.class);
        this.lastQuery_.setOwnerType((String)this.OPTIONS.get(0).getValue());
        UIVirtualList virtualList = (UIVirtualList)this.addChild(UIVirtualList.class, null, null);
        virtualList.setPageSize(10);
        virtualList.setUIComponent((UIComponent)uiRepeater);
    }

    public Query<Page> getLastQuery() {
        return this.lastQuery_;
    }

    public Query<Page> getQuery(UIFormInputSet searchInputs) {
        Query query = new Query(null, null, null, null, Page.class);
        UIFormStringInput titleInput = (UIFormStringInput)searchInputs.getChild(0);
        UIFormStringInput siteNameInput = (UIFormStringInput)searchInputs.getChild(1);
        UIFormSelectBox select = (UIFormSelectBox)searchInputs.getChild(2);
        String siteName = (String)siteNameInput.getValue();
        String title = (String)titleInput.getValue();
        String ownerType = (String)select.getValue();
        if (title != null && title != "") {
            query.setTitle(title);
        }
        if (siteName != null && siteName != "") {
            query.setOwnerId(siteName);
        }
        query.setOwnerType(ownerType);
        query.setName(null);
        return query;
    }

    public boolean feedDataWithQuery(Query<Page> query) throws Exception {
        this.lastQuery_ = query;
        UIVirtualList virtualList = (UIVirtualList)this.getChild(UIVirtualList.class);
        if (this.lastQuery_ == null) {
            this.lastQuery_ = new Query(null, null, null, null, Page.class);
        }
        virtualList.dataBind((PageList)new PageQueryAccessList(this.lastQuery_, 10));
        UIRepeater repeater = (UIRepeater)virtualList.getDataFeed();
        PageList datasource = repeater.getDataSource();
        return datasource.getAvailable() > 0;
    }

    public static void showNoResultMessagePopup() {
        UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
        uiApp.addMessage(new ApplicationMessage("UISearchForm.msg.empty", null));
    }

    public void quickSearch(UIFormInputSet quickSearchInput) throws Exception {
        this.lastQuery_ = this.getQuery(quickSearchInput);
        boolean dataAvailable = this.feedDataWithQuery(this.lastQuery_);
        if (!dataAvailable) {
            UIPageBrowser.showNoResultMessagePopup();
        }
        if (this.getParent() instanceof UIPopupWindow) {
            UIPopupWindow popupWindow = (UIPopupWindow)this.getParent();
            popupWindow.setShow(true);
        }
    }

    public boolean isShowAddNewPage() {
        return this.showAddNewPage;
    }

    public void setShowAddNewPage(boolean showAddNewPage) {
        this.showAddNewPage = showAddNewPage;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = null;
        action = uiForm != null ? uiForm.getSubmitAction() : context.getRequestParameter("formOp");
        if (action == null) {
            return;
        }
        Event event = this.createEvent(action, Event.Phase.PROCESS, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void advancedSearch(UIFormInputSet advancedSearchInput) throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavePageActionListener
    extends UIPageForm.SaveActionListener {
        @Override
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiPageForm = (UIPageForm)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageForm.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPage uiPage = uiPageForm.getUIPage();
            Page page = new Page();
            uiPageForm.invokeSetBindingBean(page);
            DataStorage dataService = (DataStorage)uiPageForm.getApplicationComponent(DataStorage.class);
            if (uiPage == null) {
                Page existPage = dataService.getPage(page.getPageId());
                if (existPage != null) {
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                    return;
                }
                page.setModifiable(true);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                dataService.create(page);
                this.postSave(uiPortalApp, pcontext);
                return;
            }
            page.setOwnerType(uiPage.getSiteKey().getTypeName());
            List uiChildren = uiPage.getChildren();
            if (uiChildren == null) {
                return;
            }
            ArrayList<ModelObject> children = new ArrayList<ModelObject>();
            for (UIComponent child : uiChildren) {
                ModelObject component = PortalDataMapper.buildModelObject(child);
                if (component == null) continue;
                children.add(component);
            }
            page.setChildren(children);
            uiPage.getChildren().clear();
            PortalDataMapper.toUIPage(uiPage, page);
        }

        private void postSave(UIPortalApplication uiPortalApp, WebuiRequestContext context) throws Exception {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            uiMaskWS.setShow(false);
            context.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            UIWorkingWorkspace uiWorkWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            uiWorkWS.updatePortletsByName("PageManagementPortlet");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)prContext.getUIApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPageForm uiPageForm = uiMaskWS.createUIComponent(UIPageForm.class, "UIBrowserPageForm", "UIPageForm");
            uiPageForm.buildForm(null);
            uiMaskWS.setUIComponent((UIComponent)uiPageForm);
            uiMaskWS.setShow(true);
            uiPageForm.getUIStringInput("ownerType").setValue((Object)SiteType.USER.getName());
            uiPageForm.getUIStringInput("ownerId").setValue((Object)prContext.getRemoteUser());
            UIFormSelectBox slcOwnerType = uiPageForm.getUIFormSelectBox("ownerType");
            List types = slcOwnerType.getOptions();
            for (int i = 0; i < types.size(); ++i) {
                if (!PortalConfig.USER_TYPE.equals(((SelectItemOption)types.get(i)).getValue())) continue;
                types.remove(types.get(i));
                break;
            }
            slcOwnerType.setOptions(types);
            Event slcEvent = uiPageForm.createEvent("ChangeOwnerType", Event.Phase.DECODE, event.getRequestContext());
            slcEvent.broadcast();
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            PortalRequestContext pcontext = (PortalRequestContext)context.getParentAppRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)pcontext.getUIApplication();
            String id = context.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            Page page = service.getPage(id);
            if (page == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{id}, 1));
                return;
            }
            UserACL userACL = (UserACL)uiPageBrowser.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermission(page)) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.edit.NotEditPage", (Object[])new String[]{id}, 1));
                return;
            }
            UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
            UIPage uipage = clazz.createUIPage(null);
            uipage.switchToEditMode(page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String id = context.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            DataStorage dataService = (DataStorage)uiPageBrowser.getApplicationComponent(DataStorage.class);
            UIApplication uiApp = context.getUIApplication();
            if (service.getPage(id) == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{id}, 1));
                return;
            }
            Page page = service.getPage(id, context.getRemoteUser());
            if (page == null || !page.isModifiable() || page.getOwnerType().equals(SiteType.USER.getName()) && !page.getOwnerId().equals(context.getRemoteUser())) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.delete.NotDelete", (Object[])new String[]{id}, 1));
                return;
            }
            UIPortal uiPortal = Util.getUIPortal();
            UserNode userNode = uiPortal.getSelectedUserNode();
            boolean isDeleteCurrentPage = userNode.getPageRef().equals(page.getPageId());
            if (isDeleteCurrentPage && page.getOwnerType().equals(SiteType.USER.getName())) {
                ApplicationMessage msg = new ApplicationMessage("UIPageBrowser.msg.delete.DeleteCurrentUserPage", null, 1);
                event.getRequestContext().getUIApplication().addMessage(msg);
                return;
            }
            UIVirtualList virtualList = (UIVirtualList)uiPageBrowser.getChild(UIVirtualList.class);
            UIRepeater repeater = (UIRepeater)virtualList.getDataFeed();
            PageListAccess datasource = (PageListAccess)repeater.getDataSource();
            int currentPage = datasource.getCurrentPage();
            if (page.getOwnerType().equals(SiteType.USER.getName())) {
                this.removePageNode(page, event);
            }
            dataService.remove(page);
            if (isDeleteCurrentPage) {
                SiteKey siteKey = userNode.getNavigation().getKey();
                PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(Util.getUIPortalApplication(), "ChangeNode", siteKey, userNode.getURI());
                uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
            } else {
                boolean dataAvailable = uiPageBrowser.feedDataWithQuery(uiPageBrowser.getLastQuery());
                if (!dataAvailable) {
                    UIPageBrowser.showNoResultMessagePopup();
                }
                if (currentPage > datasource.getAvailablePage()) {
                    currentPage = datasource.getAvailablePage();
                }
                datasource.getPage(currentPage);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPageBrowser);
            }
        }

        private void removePageNode(Page page, Event<UIPageBrowser> event) throws Exception {
            UserNavigation userNav;
            PortalRequestContext prc = Util.getPortalRequestContext();
            UserPortal userPortal = prc.getUserPortalConfig().getUserPortal();
            UserNode rootNode = userPortal.getNode(userNav = userPortal.getNavigation(SiteKey.user((String)event.getRequestContext().getRemoteUser())), Scope.CHILDREN, null, null);
            if (rootNode == null) {
                return;
            }
            for (UserNode userNode : rootNode.getChildren()) {
                if (!page.getPageId().equals(userNode.getPageRef())) continue;
                rootNode.removeChild(userNode.getName());
                userPortal.saveNode(rootNode, null);
                String pageRef = page.getPageId();
                if (pageRef != null && pageRef.length() > 0) {
                    UIPortal uiPortal = Util.getUIPortal();
                    uiPortal.clearUIPage(pageRef);
                }
                ActionResponse actResponse = (ActionResponse)event.getRequestContext().getResponse();
                actResponse.setEvent(new QName("NavigationChange"), (Serializable)((Object)userNode.getName()));
                return;
            }
        }
    }
}

