/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.expressions.ELTypeConverter;
import org.apache.shindig.expressions.ExpressionProvider;
import org.apache.shindig.expressions.Functions;
import org.apache.shindig.expressions.JsonELResolver;
import org.apache.shindig.expressions.juel.JuelProvider;
import org.apache.shindig.expressions.juel.JuelTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Expressions {
    private final ExpressionFactory factory;
    private final ELContext parseContext;
    private final ELResolver defaultELResolver;
    private final Functions functions;
    private final ELTypeConverter typeConverter;

    public static Expressions forTesting(Functions functions) {
        return new Expressions(functions, null, new JuelTypeConverter(), new JuelProvider());
    }

    public static Expressions forTesting() {
        return new Expressions(null, null, new JuelTypeConverter(), new JuelProvider());
    }

    @Inject
    public Expressions(Functions functions, CacheProvider cacheProvider, ELTypeConverter typeConverter, ExpressionProvider expProvider) {
        this.functions = functions;
        this.typeConverter = typeConverter;
        this.factory = this.newExpressionFactory(expProvider, cacheProvider);
        this.parseContext = new Context(null);
        this.defaultELResolver = this.createDefaultELResolver();
    }

    public ELContext newELContext(ELResolver ... customResolvers) {
        CompositeELResolver composite = new CompositeELResolver();
        for (ELResolver customResolver : customResolvers) {
            composite.add(customResolver);
        }
        composite.add(this.defaultELResolver);
        return new Context((ELResolver)composite);
    }

    public ValueExpression parse(String expression, Class<?> type) {
        boolean shouldConvert = this.typeConverter.isPostConvertible(type);
        if (shouldConvert) {
            return new ValueExpressionWrapper(this.factory.createValueExpression(this.parseContext, expression, Object.class), this.typeConverter, type);
        }
        return this.factory.createValueExpression(this.parseContext, expression, type);
    }

    public ValueExpression constant(Object value, Class<?> type) {
        boolean shouldConvert = this.typeConverter.isPostConvertible(type);
        if (shouldConvert) {
            return new ValueExpressionWrapper(this.factory.createValueExpression(value, Object.class), this.typeConverter, type);
        }
        return this.factory.createValueExpression(value, type);
    }

    private ExpressionFactory newExpressionFactory(ExpressionProvider expProvider, CacheProvider cacheProvider) {
        return expProvider.newExpressionFactory(cacheProvider, this.typeConverter);
    }

    private ELResolver createDefaultELResolver() {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new JsonELResolver());
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        return resolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueExpressionWrapper
    extends ValueExpression {
        private static final long serialVersionUID = 2135607228206570229L;
        private ValueExpression expression = null;
        private Class<?> type = null;
        private ELTypeConverter converter = null;

        public ValueExpressionWrapper(ValueExpression ve, ELTypeConverter converter, Class<?> type) {
            this.expression = ve;
            this.type = type;
            this.converter = converter;
        }

        public Object getValue(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.converter.convert(this.expression.getValue(context), this.type);
        }

        public Class<?> getExpectedType() {
            return this.expression.getExpectedType();
        }

        public Class<?> getType(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.expression.getType(context);
        }

        public boolean isReadOnly(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.expression.isReadOnly(context);
        }

        public void setValue(ELContext context, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
            this.expression.setValue(context, value);
        }

        public boolean equals(Object obj) {
            return this.expression.equals(obj);
        }

        public String getExpressionString() {
            return this.expression.getExpressionString();
        }

        public int hashCode() {
            return this.expression.hashCode();
        }

        public boolean isLiteralText() {
            return this.expression.isLiteralText();
        }
    }

    private static class Variables
    extends VariableMapper {
        private final Map<String, ValueExpression> variables = Maps.newHashMap();

        private Variables() {
        }

        public ValueExpression resolveVariable(String var) {
            return this.variables.get(var);
        }

        public ValueExpression setVariable(String var, ValueExpression expression) {
            return this.variables.put(var, expression);
        }
    }

    private class Context
    extends ELContext {
        private final ELResolver resolver;
        private VariableMapper variables;

        public Context(ELResolver resolver) {
            this.resolver = resolver;
        }

        public ELResolver getELResolver() {
            return this.resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return Expressions.this.functions;
        }

        public VariableMapper getVariableMapper() {
            if (this.variables == null) {
                this.variables = new Variables();
            }
            return this.variables;
        }
    }
}

