/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.quasiliteral.InnocentCodeRewriter;
import com.google.caja.parser.quasiliteral.RewriterTestCase;
import com.google.caja.util.Executor;
import com.google.caja.util.RhinoTestBed;
import java.io.IOException;
import java.util.Arrays;

public class InnocentCodeRewriterTest
extends RewriterTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setRewriter(new InnocentCodeRewriter(this.mq, false));
    }

    public final void testForEachPlain() throws Exception {
        this.checkSucceeds("for (var k in x) { k; }", "var x0___;for (x0___ in x) {  if (x0___.match(/___$/)) {    continue;  }  k = x0___;  { k; }}");
        this.rewriteAndExecute("var test = new Object;test.number = 0;test.other = 450;test.__defineGetter__('num',     function() { this.number++; return this.number; });test.__defineSetter__('num',     function(y) { return this.number = y; });", "for (k in test) {  var p = test[k];}", "assertEquals(test.number, 1);");
        this.rewriteAndExecute("var test = new Object;test.number = 0;var k = new Object;k.one = 1;k.__defineGetter__('foo',     function() { this.one++; return this.one; });k.__defineSetter__('foo',     function() { this.one++; return this.one; });", "for (k.foo in test) {  k.one;}", "assertEquals(k.one, 2);");
        this.rewriteAndExecute("var test = new Object;test.visible = 0;test.hidden___ = 5;test.hiddenObj___ = new Object;var counter = 0;", "for (k in test) {  counter++;}", "assertEquals(counter,1);");
    }

    public final void testForEachFunc() throws Exception {
        this.checkSucceeds("function add() {  for (var k in x) { k; }}", "function add() {  var x0___;  for (x0___ in x) {    if (x0___.match(/___$/)) {      continue;    }    k = x0___;    { k; }  }}");
        this.rewriteAndExecute(";", "function () {  var test = new Object;  test.visible = 0;  var counter = 0;  for (k in test) {    counter++;  }}", "var q = 0;if (typeof x0___ == 'undefined') {  q = 1;}assertEquals(q,1);");
    }

    public final void testThis() throws Exception {
        this.rewriteAndExecute(";", "assertThrows(function a() {  this.fun();});", ";");
        this.rewriteAndExecute(";", "assertThrows(function a() {  var q = this[0];});", ";");
        this.rewriteAndExecute(";", "assertThrows(function a() {  var k = this.q;});", ";");
        this.rewriteAndExecute(";", "assertEquals(undefined, (function a() { return this; })());", ";");
        this.rewriteAndExecute(";", "assertEquals(assertEquals, this.assertEquals);", ";");
    }

    protected Object executePlain(String caja) throws IOException {
        this.mq.getMessages().clear();
        return RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(caja, this.getName() + "-uncajoled"));
    }

    protected Object rewriteAndExecute(String pre, String trans, String post) throws IOException, ParseException {
        this.mq.getMessages().clear();
        Block input = new Block(FilePosition.UNKNOWN, Arrays.asList(this.js(this.fromResource("../../../../../js/jsunit/2.2/jsUnitCore.js")), this.js(this.fromString(trans, this.is))));
        String transJs = InnocentCodeRewriterTest.render(this.rewriteTopLevelNode(input));
        this.assertNoErrors();
        Object result = RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/plugin/console-stubs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(pre, this.getName()), new Executor.Input(transJs, this.getName()), new Executor.Input(post, this.getName()));
        this.assertNoErrors();
        return result;
    }
}

