/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateConfigurationHelper {
    private List<Pattern> includes = new ArrayList<Pattern>();
    private List<Pattern> excludes = new ArrayList<Pattern>();
    private ConfigurationManager cfm;

    public TemplateConfigurationHelper(String[] includes, String[] excludes, ConfigurationManager cfm) {
        this.cfm = cfm;
        for (String regex : includes) {
            this.includes.add(Pattern.compile(regex));
        }
        for (String regex : excludes) {
            this.excludes.add(Pattern.compile(regex));
        }
    }

    public InputStream fillTemplate(InputStream inputStream, Map<String, String> parameters) throws IOException {
        if (inputStream == null || parameters == null || parameters.size() == 0) {
            return inputStream;
        }
        Map<String, String> preparedParams = this.prepareParameters(parameters);
        String configuration = this.readStream(inputStream);
        for (Map.Entry<String, String> entry : preparedParams.entrySet()) {
            configuration = configuration.replace(entry.getKey(), entry.getValue());
        }
        ByteArrayInputStream configurationStream = new ByteArrayInputStream(configuration.getBytes());
        return configurationStream;
    }

    public InputStream fillTemplate(String filename, Map<String, String> parameters) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.cfm.getInputStream(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (inputStream == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream inputStream2 = inputStream = cl == null ? null : cl.getResourceAsStream(filename);
        }
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        if (inputStream == null) {
            try {
                inputStream = PrivilegedFileHelper.fileInputStream((String)filename);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            throw new IOException("Can't find or open file:" + filename);
        }
        return this.fillTemplate(inputStream, parameters);
    }

    public InputStream fillTemplate(InputStream inputStream, List<SimpleParameterEntry> parameters) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SimpleParameterEntry parameterEntry : parameters) {
            map.put(parameterEntry.getName(), parameterEntry.getValue());
        }
        return this.fillTemplate(inputStream, map);
    }

    public InputStream fillTemplate(String filename, List<SimpleParameterEntry> parameters) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SimpleParameterEntry parameterEntry : parameters) {
            map.put(parameterEntry.getName(), parameterEntry.getValue());
        }
        return this.fillTemplate(filename, map);
    }

    private boolean matches(List<Pattern> patterns, String parameter) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(parameter).matches()) continue;
            return true;
        }
        return false;
    }

    protected Map<String, String> prepareParameters(Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!this.matches(this.includes, entry.getKey()) || this.matches(this.excludes, entry.getKey())) continue;
            map.put("${" + entry.getKey() + "}", entry.getValue());
        }
        return map;
    }

    protected String readStream(InputStream inputStream) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = inputStream.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

