/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.WorkspaceRestoreException;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JobExistingWorkspaceSameConfigRestore
extends JobWorkspaceRestore {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.JobExistingWorkspaceSameConfigRestore");

    public JobExistingWorkspaceSameConfigRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, BackupChainLog log, WorkspaceEntry wEntry) {
        super(repositoryService, backupManager, repositoryName, log, wEntry);
    }

    /*
     * Loose catch block
     */
    protected void restore() throws WorkspaceRestoreException {
        block34: {
            ArrayList<DataRestore> dataRestorer = new ArrayList<DataRestore>();
            ManageableRepository repository = this.repositoryService.getRepository(this.repositoryName);
            if (!this.wEntry.getContainer().getParameterBoolean("multi-db").booleanValue()) {
                repository.setState(3);
            } else {
                repository.getWorkspaceContainer(this.wEntry.getName()).setState(3);
            }
            List backupable = repository.getWorkspaceContainer(this.wEntry.getName()).getComponentInstancesOfType(Backupable.class);
            File storageDir = this.backupChainLog.getBackupConfig().getBackupDir();
            File fullBackupDir = JCRRestore.getFullBackupFile((File)storageDir);
            DataRestoreContext context = new DataRestoreContext(new String[]{"storage-dir"}, new Object[]{fullBackupDir});
            for (Backupable component : backupable) {
                dataRestorer.add(component.getDataRestorer(context));
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.commit();
            }
            if (!this.wEntry.getContainer().getParameterBoolean("multi-db").booleanValue()) {
                repository.setState(1);
            } else {
                repository.getWorkspaceContainer(this.wEntry.getName()).setState(1);
            }
            WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)repository.getWorkspaceContainer(this.wEntry.getName()).getComponent(WorkspacePersistentDataManager.class);
            FileCleanerHolder fileCleanHolder = (FileCleanerHolder)repository.getWorkspaceContainer(this.wEntry.getName()).getComponent(FileCleanerHolder.class);
            JCRRestore restorer = new JCRRestore((DataManager)dataManager, fileCleanHolder.getFileCleaner());
            for (File incrBackupFile : JCRRestore.getIncrementalFiles((File)storageDir)) {
                restorer.incrementalRestore(incrBackupFile);
            }
            Object var13_16 = null;
            for (DataRestore restorer2 : dataRestorer) {
                try {
                    restorer2.close();
                }
                catch (BackupException e) {
                    log.error((Object)"Can't close restorer", e);
                }
            }
            try {
                ManageableRepository repository2 = this.repositoryService.getRepository(this.repositoryName);
                if (!this.wEntry.getContainer().getParameterBoolean("multi-db").booleanValue()) {
                    if (repository2.getState() != 1) {
                        repository2.setState(1);
                    }
                } else if (repository2.getWorkspaceContainer(this.wEntry.getName()).getState() != 1) {
                    repository2.getWorkspaceContainer(this.wEntry.getName()).setState(1);
                }
                break block34;
            }
            catch (RepositoryException e) {
                log.error((Object)"Can't resume component", e);
            }
            catch (RepositoryConfigurationException e) {
                log.error((Object)"Can't resume component", e);
            }
            break block34;
            {
                catch (Throwable t) {
                    for (DataRestore restorer3 : dataRestorer) {
                        try {
                            restorer3.rollback();
                        }
                        catch (BackupException e) {
                            log.error((Object)"Can't rollback changes", e);
                        }
                    }
                    throw new WorkspaceRestoreException("Workspace " + this.wEntry.getName() + " was not restored", t);
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                for (DataRestore restorer2 : dataRestorer) {
                    try {
                        restorer2.close();
                    }
                    catch (BackupException e) {
                        log.error((Object)"Can't close restorer", e);
                    }
                }
                try {
                    ManageableRepository repository2 = this.repositoryService.getRepository(this.repositoryName);
                    if (!this.wEntry.getContainer().getParameterBoolean("multi-db").booleanValue()) {
                        if (repository2.getState() != 1) {
                            repository2.setState(1);
                        }
                    } else if (repository2.getWorkspaceContainer(this.wEntry.getName()).getState() != 1) {
                        repository2.getWorkspaceContainer(this.wEntry.getName()).setState(1);
                    }
                }
                catch (RepositoryException e) {
                    log.error((Object)"Can't resume component", e);
                }
                catch (RepositoryConfigurationException e) {
                    log.error((Object)"Can't resume component", e);
                }
                throw throwable;
            }
        }
    }
}

