/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log.impl;

import java.lang.reflect.Method;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class DynamicLocationAwareLogger {
    private Method log;
    private static final String LOG_METHOD_INVOKE_ERROR_MSG = "LocationAwareLogger had some issues on method 'log' invocation. Using location unaware methods.\n";
    private boolean parameterSupported = false;
    private LocationAwareLogger logger;

    public DynamicLocationAwareLogger(LocationAwareLogger logger) {
        this.logger = logger;
        for (Method m : logger.getClass().getDeclaredMethods()) {
            if (!"log".equals(m.getName())) continue;
            this.log = m;
            if (this.log.getParameterTypes().length != 6) break;
            this.parameterSupported = true;
            break;
        }
        if (this.log == null) {
            throw new UnsupportedOperationException("Currently used logger does not have log method.");
        }
    }

    public void log(Marker marker, String fqcn, int level, String message, Throwable t) {
        try {
            if (!this.parameterSupported) {
                this.log.invoke((Object)this.logger, marker, fqcn, level, message, t);
            } else {
                this.log.invoke((Object)this.logger, marker, fqcn, level, message, null, t);
            }
        }
        catch (Exception e) {
            switch (level) {
                case 0: {
                    this.logger.trace(LOG_METHOD_INVOKE_ERROR_MSG + message, t);
                    break;
                }
                case 10: {
                    this.logger.debug(LOG_METHOD_INVOKE_ERROR_MSG + message, t);
                    break;
                }
                case 20: {
                    this.logger.info(LOG_METHOD_INVOKE_ERROR_MSG + message, t);
                    break;
                }
                case 30: {
                    this.logger.warn(LOG_METHOD_INVOKE_ERROR_MSG + message, t);
                    break;
                }
                case 40: {
                    this.logger.error(LOG_METHOD_INVOKE_ERROR_MSG + message, t);
                }
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }
}

