/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.NamingException;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.RestoreTableRule;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseDBRestore
extends DBRestore {
    private final Boolean isMultiDb;

    public SybaseDBRestore(File storageDir, Connection jdbcConn, Map<String, RestoreTableRule> tables, WorkspaceEntry wsConfig, FileCleaner fileCleaner, DBCleaner dbCleaner) throws NamingException, SQLException, RepositoryConfigurationException {
        super(storageDir, jdbcConn, tables, wsConfig, fileCleaner, dbCleaner);
        this.isMultiDb = tables.entrySet().iterator().next().getValue().getDstMultiDb();
    }

    /*
     * Loose catch block
     */
    @Override
    public void clean() throws BackupException {
        block7: {
            this.jdbcConn.setAutoCommit(true);
            super.prepareQueries(this.isMultiDb);
            super.executeQueries(this.dropQueries);
            Object var3_1 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block7;
            {
                catch (SQLException e) {
                    throw new BackupException(ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
        super.clean();
    }

    @Override
    public void commit() throws BackupException {
        super.commit();
        this.restoreConstraint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws BackupException {
        BackupException rollbackException = null;
        try {
            try {
                super.rollback();
            }
            catch (BackupException e) {
                rollbackException = e;
                throw rollbackException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                this.restoreConstraint();
                throw throwable;
            }
            catch (BackupException e) {
                if (rollbackException == null) throw e;
                LOG.error((Object)"Can not restore constraint", (Throwable)e);
                throw rollbackException;
            }
        }
        try {}
        catch (BackupException e) {
            if (rollbackException == null) throw e;
            LOG.error((Object)"Can not restore constraint", (Throwable)e);
            throw rollbackException;
        }
        this.restoreConstraint();
    }

    /*
     * Loose catch block
     */
    private void restoreConstraint() throws BackupException {
        block10: {
            block9: {
                this.jdbcConn.setAutoCommit(true);
                if (this.successfulExecuted.size() == this.addQueries.size()) {
                    this.executeQueries(this.addQueries);
                    break block9;
                }
                ArrayList notDeletedConstraints = new ArrayList();
                notDeletedConstraints.addAll(this.addQueries.keySet());
                notDeletedConstraints.removeAll(this.successfulExecuted);
                for (String notDeletedConstraint : notDeletedConstraints) {
                    this.addQueries.remove(notDeletedConstraint);
                }
                this.executeQueries(this.addQueries);
            }
            Object var5_5 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block10;
            {
                catch (SQLException e) {
                    throw new BackupException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void preRestoreTables(boolean isMultiDb) throws SQLException {
    }

    @Override
    public void postRestoreTables(boolean isMultiDb) throws SQLException {
    }

    @Override
    protected String validateConstraintName(String string) {
        if (string.equals("JCR_PK_SCONTAINER")) {
            return "JCR_PK_MCONTAINER";
        }
        return super.validateConstraintName(string);
    }
}

