/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.clean.rdbms.RecursiveDBCleanHelper;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCleanService {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleanService");
    public static final String OLD_OBJECT_SUFFIX = "_OLD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanWorkspaceData(WorkspaceEntry wsEntry) throws RepositoryConfigurationException, NamingException, SQLException {
        String dsName = wsEntry.getContainer().getParameterValue("source-name");
        final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
        if (ds == null) {
            throw new NameNotFoundException("Data source " + dsName + " not found");
        }
        Connection jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return ds.getConnection();
            }
        });
        jdbcConn.setAutoCommit(false);
        DBCleaner dbCleaner = DBCleanService.getWorkspaceDBCleaner(jdbcConn, wsEntry);
        try {
            try {
                dbCleaner.executeCleanScripts();
                try {
                    dbCleaner.executeCommitScripts();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't remove temporary objects", (Throwable)e);
                }
                jdbcConn.commit();
            }
            catch (SQLException e) {
                jdbcConn.rollback();
                dbCleaner.executeRollbackScripts();
                jdbcConn.commit();
                Object var7_8 = null;
                jdbcConn.close();
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            jdbcConn.close();
            throw throwable;
        }
        jdbcConn.close();
    }

    public static void cleanRepositoryData(RepositoryEntry rEntry) throws RepositoryConfigurationException, NamingException, SQLException {
        for (WorkspaceEntry wsEntry : rEntry.getWorkspaceEntries()) {
            DBCleanService.cleanWorkspaceData(wsEntry);
        }
    }

    public static DBCleaner getRepositoryDBCleaner(Connection jdbcConn, RepositoryEntry repoEntry) throws SQLException, RepositoryConfigurationException {
        boolean isMultiDB = Boolean.parseBoolean(repoEntry.getWorkspaceEntries().get(0).getContainer().getParameterValue("multi-db"));
        if (isMultiDB) {
            return null;
        }
        String dialect = DialectDetecter.detect(jdbcConn.getMetaData());
        if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
            ArrayList<String> dbCleanerScripts = new ArrayList<String>();
            dbCleanerScripts.addAll(DBCleanService.getRenameScripts(isMultiDB, dialect));
            dbCleanerScripts.addAll(DBCleanService.getInitializationDBScript(isMultiDB, dialect));
            return new DBCleaner(jdbcConn, dbCleanerScripts, DBCleanService.getRollbackRenamedScript(isMultiDB, dialect), DBCleanService.getAfterRestoreScript(isMultiDB, dialect));
        }
        if (dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
            ArrayList<String> dbCleanerScripts = new ArrayList<String>();
            dbCleanerScripts.add("delete from JCR_" + (isMultiDB ? "M" : "S") + "VALUE");
            dbCleanerScripts.add("delete from JCR_" + (isMultiDB ? "M" : "S") + "ITEM");
            dbCleanerScripts.add("delete from JCR_" + (isMultiDB ? "M" : "S") + "REF");
            dbCleanerScripts.add("delete from JCR_" + (isMultiDB ? "M" : "S") + "CONTAINER");
            dbCleanerScripts.add(DBInitializerHelper.getRootNodeInitializeScript(isMultiDB));
            return new DBCleaner(jdbcConn, dbCleanerScripts);
        }
        ArrayList<String> dbCleanerScripts = new ArrayList<String>();
        dbCleanerScripts.addAll(DBCleanService.getDropTableScripts(isMultiDB, dialect));
        dbCleanerScripts.addAll(DBCleanService.getInitializationDBScript(isMultiDB, dialect));
        return new DBCleaner(jdbcConn, dbCleanerScripts);
    }

    protected static List<String> getDropTableScripts(boolean multiDb, String dialect) {
        String isMultiDB = multiDb ? "M" : "S";
        ArrayList<String> cleanScripts = new ArrayList<String>();
        if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
            cleanScripts.add("drop trigger BI_JCR_" + isMultiDB + "VALUE");
            cleanScripts.add("drop sequence JCR_" + isMultiDB + "VALUE_SEQ");
        }
        cleanScripts.add("drop table JCR_" + isMultiDB + "VALUE");
        cleanScripts.add("drop table JCR_" + isMultiDB + "ITEM");
        cleanScripts.add("drop table JCR_" + isMultiDB + "REF");
        cleanScripts.add("drop table JCR_" + isMultiDB + "CONTAINER");
        return cleanScripts;
    }

    protected static List<String> getRenameScripts(boolean multiDb, String dialect) {
        String isMultiDB = multiDb ? "M" : "S";
        ArrayList<String> renameScripts = new ArrayList<String>();
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME TO JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "VALUE TO JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_FK_" + isMultiDB + "VALUE_PROPERTY TO JCR_FK_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "VALUE RENAME TO JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "VALUE_PROPERTY RENAME TO JCR_IDX_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX);
        if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
            renameScripts.add("RENAME JCR_" + isMultiDB + "VALUE_SEQ TO JCR_" + isMultiDB + "VALUE_SEQ" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TRIGGER BI_JCR_" + isMultiDB + "VALUE RENAME TO BI_JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
        }
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME TO JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "ITEM TO JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_FK_" + isMultiDB + "ITEM_PARENT TO JCR_FK_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "ITEM RENAME TO JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "CONTAINER RENAME TO JCR_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "CONTAINER TO JCR_PK_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "CONTAINER RENAME TO JCR_PK_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF RENAME TO JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "REF TO JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "REF RENAME TO JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
        renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "REF_PROPERTY RENAME TO JCR_IDX_" + isMultiDB + "REF_PROPERTY" + OLD_OBJECT_SUFFIX);
        return renameScripts;
    }

    protected static List<String> getRollbackRenamedScript(boolean multiDb, String dialect) {
        String isMultiDB = multiDb ? "M" : "S";
        ArrayList<String> rollbackScripts = new ArrayList<String>();
        rollbackScripts.addAll(DBCleanService.getDropTableScripts(multiDb, dialect));
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "VALUE");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME CONSTRAINT JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "VALUE");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME CONSTRAINT JCR_FK_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX + " TO JCR_FK_" + isMultiDB + "VALUE_PROPERTY");
        rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "VALUE");
        rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "VALUE_PROPERTY");
        if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
            rollbackScripts.add("RENAME JCR_" + isMultiDB + "VALUE_SEQ" + OLD_OBJECT_SUFFIX + " TO JCR_" + isMultiDB + "VALUE_SEQ");
            rollbackScripts.add("ALTER TRIGGER BI_JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO BI_JCR_" + isMultiDB + "VALUE");
        }
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "ITEM");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME CONSTRAINT JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "ITEM");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME CONSTRAINT JCR_FK_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX + " TO JCR_FK_" + isMultiDB + "ITEM_PARENT");
        rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "ITEM");
        rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK");
        rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT");
        rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME");
        rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "CONTAINER");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "CONTAINER RENAME CONSTRAINT JCR_PK_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "CONTAINER");
        rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "CONTAINER" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "CONTAINER");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "REF");
        rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF RENAME CONSTRAINT JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "REF");
        rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "REF");
        rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "REF_PROPERTY" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "REF_PROPERTY");
        return rollbackScripts;
    }

    protected static List<String> getAfterRestoreScript(boolean multiDb, String dialect) {
        ArrayList<String> afterRetoreScripts = new ArrayList<String>();
        for (String query : DBCleanService.getDropTableScripts(multiDb, dialect)) {
            afterRetoreScripts.add(query + OLD_OBJECT_SUFFIX);
        }
        return afterRetoreScripts;
    }

    protected static List<String> getInitializationDBScript(boolean multiDb, String dialect) throws RepositoryConfigurationException {
        String script;
        String scriptsPath = DBInitializerHelper.scriptPath(dialect, multiDb);
        try {
            script = DBInitializerHelper.readScriptResource(scriptsPath);
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Can not read script file " + scriptsPath, e);
        }
        ArrayList<String> scripts = new ArrayList<String>();
        for (String query : DBInitializerHelper.scripts(script)) {
            scripts.add(DBInitializerHelper.cleanWhitespaces(query));
        }
        String rootParent_container = DBInitializerHelper.getRootNodeInitializeScript(multiDb);
        scripts.add(rootParent_container);
        return scripts;
    }

    public static DBCleaner getWorkspaceDBCleaner(Connection jdbcConn, WorkspaceEntry wsEntry) throws SQLException, RepositoryConfigurationException {
        String deleteItems;
        String selectItems;
        boolean multiDb = Boolean.parseBoolean(wsEntry.getContainer().getParameterValue("multi-db"));
        String containerName = wsEntry.getName();
        String dialect = DialectDetecter.detect(jdbcConn.getMetaData());
        boolean cleanWithHelper = false;
        if (dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
            cleanWithHelper = true;
        } else if (dialect.equals(DBConstants.DB_DIALECT_MYSQL) || dialect.equals(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
            String engine;
            cleanWithHelper = true;
            Statement st = jdbcConn.createStatement();
            st.execute("SELECT ENGINE FROM information_schema.TABLES where TABLE_SCHEMA='" + jdbcConn.getCatalog() + "' and (TABLE_NAME='JCR_SITEM' or TABLE_NAME='JCR_MITEM')");
            ResultSet result = st.getResultSet();
            if (result.next() && (engine = result.getString("ENGINE")).equalsIgnoreCase("MyISAM")) {
                cleanWithHelper = false;
            }
        }
        ArrayList<String> cleanScripts = new ArrayList<String>();
        if (multiDb) {
            if (dialect.equals(DBConstants.DB_DIALECT_SYBASE) || dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
                cleanScripts.add("delete from JCR_MVALUE");
                cleanScripts.add("delete from JCR_MREF");
                if (cleanWithHelper) {
                    cleanScripts.add("delete from JCR_MITEM where I_CLASS=2");
                    selectItems = "select ID from JCR_MITEM where I_CLASS=1 and PARENT_ID=?";
                    deleteItems = "delete from JCR_MITEM where I_CLASS=1 and PARENT_ID=?";
                    return new DBCleaner(jdbcConn, cleanScripts, new RecursiveDBCleanHelper(jdbcConn, selectItems, deleteItems));
                }
                cleanScripts.add("delete from JCR_MITEM where JCR_MITEM.name <> '__root_parent'");
            } else {
                cleanScripts.addAll(DBCleanService.getDropTableScripts(multiDb, dialect));
                cleanScripts.addAll(DBCleanService.getInitializationDBScript(multiDb, dialect));
            }
        } else {
            cleanScripts.add("delete from JCR_SVALUE where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SVALUE.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + containerName + "')");
            cleanScripts.add("delete from JCR_SREF where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SREF.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + containerName + "')");
            if (cleanWithHelper) {
                cleanScripts.add("delete from JCR_SITEM where I_CLASS=2 and CONTAINER_NAME='" + containerName + "'");
                selectItems = "select ID from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME='" + containerName + "' and PARENT_ID=?";
                deleteItems = "delete from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME='" + containerName + "' and PARENT_ID=?";
                return new DBCleaner(jdbcConn, cleanScripts, new RecursiveDBCleanHelper(jdbcConn, selectItems, deleteItems));
            }
            cleanScripts.add("delete from JCR_SITEM where CONTAINER_NAME='" + containerName + "'");
        }
        if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
            ArrayList<String> dbCleanerScripts = new ArrayList<String>();
            dbCleanerScripts.addAll(DBCleanService.getRenameScripts(multiDb, dialect));
            dbCleanerScripts.addAll(DBCleanService.getInitializationDBScript(multiDb, dialect));
            return new DBCleaner(jdbcConn, dbCleanerScripts, DBCleanService.getRollbackRenamedScript(multiDb, dialect), DBCleanService.getAfterRestoreScript(multiDb, dialect));
        }
        return new DBCleaner(jdbcConn, cleanScripts);
    }
}

