/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.config.ConfigurationPersister;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.impl.config.RepositoryServiceConfigurationPlugin;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.picocontainer.Startable;

public class RepositoryServiceConfigurationImpl
extends RepositoryServiceConfiguration
implements Startable {
    private ValueParam param;
    private ConfigurationManager configurationService;
    private ConfigurationPersister configurationPersister;
    private final List<String> configExtensionPaths = new CopyOnWriteArrayList<String>();

    public RepositoryServiceConfigurationImpl(InitParams params, ConfigurationManager configurationService, InitialContextInitializer initialContextInitializer) throws RepositoryConfigurationException {
        this.param = params.getValueParam("conf-path");
        if (params.getPropertiesParam("working-conf") != null) {
            String cn = params.getPropertiesParam("working-conf").getProperty("persister-class-name");
            if (cn == null) {
                cn = params.getPropertiesParam("working-conf").getProperty("persisterClassName");
            }
            if (cn != null) {
                try {
                    Class<?> configurationPersisterClass = Class.forName(cn);
                    this.configurationPersister = (ConfigurationPersister)configurationPersisterClass.newInstance();
                    this.configurationPersister.init(params.getPropertiesParam("working-conf"));
                }
                catch (InstantiationException e) {
                    throw new RepositoryConfigurationException(e.getLocalizedMessage());
                }
                catch (IllegalAccessException e) {
                    throw new RepositoryConfigurationException(e.getLocalizedMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryConfigurationException(e.getLocalizedMessage());
                }
            }
        }
        this.configurationService = configurationService;
    }

    public RepositoryServiceConfigurationImpl(InputStream is) throws RepositoryConfigurationException {
        this.init(is);
    }

    public void addConfig(RepositoryServiceConfigurationPlugin plugin) {
        this.configExtensionPaths.add(plugin.getConfPath());
    }

    public boolean isRetainable() {
        URL fileURL;
        if (this.configurationPersister != null) {
            return true;
        }
        String strfileUri = this.param.getValue();
        try {
            fileURL = this.configurationService.getURL(strfileUri);
        }
        catch (Exception e) {
            return false;
        }
        return fileURL.getProtocol().equals("file");
    }

    public synchronized void retain() throws RepositoryException {
        try {
            IBindingFactory bfact;
            if (!this.isRetainable()) {
                throw new RepositoryException("Unsupported  configuration place " + this.configurationService.getURL(this.param.getValue()) + " If you want to save configuration, start repository from standalone file." + " Or persister-class-name not configured");
            }
            OutputStream saveStream = null;
            if (this.configurationPersister != null) {
                saveStream = new ByteArrayOutputStream();
            } else {
                URL filePath = this.configurationService.getURL(this.param.getValue());
                File sourceConfig = new File(filePath.toURI());
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
                File backUp = new File(sourceConfig.getAbsoluteFile() + "_" + format.format(new Date()));
                try {
                    DirectoryHelper.renameFile(sourceConfig, backUp);
                }
                catch (IOException ioe) {
                    throw new RepositoryException("Can't back up configuration on path " + PrivilegedFileHelper.getAbsolutePath((File)sourceConfig), (Throwable)ioe);
                }
                saveStream = PrivilegedFileHelper.fileOutputStream((File)sourceConfig);
            }
            try {
                bfact = (IBindingFactory)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<IBindingFactory>(){

                    @Override
                    public IBindingFactory run() throws Exception {
                        return BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.marshalDocument((Object)this, "ISO-8859-1", null, saveStream);
            ((OutputStream)saveStream).close();
            if (this.configurationPersister != null) {
                this.configurationPersister.write(new ByteArrayInputStream(saveStream.toByteArray()));
            }
        }
        catch (JiBXException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFromStream(InputStream jcrConfigurationInputStream) throws RepositoryConfigurationException {
        try {
            if (this.configurationPersister != null) {
                if (!this.configurationPersister.hasConfig()) {
                    this.configurationPersister.write(jcrConfigurationInputStream);
                }
                this.init(this.configurationPersister.read());
            } else {
                this.init(jcrConfigurationInputStream);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                jcrConfigurationInputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jcrConfigurationInputStream.close();
        }
        catch (IOException e) {}
    }

    public void start() {
        try {
            String[] paths = this.configExtensionPaths.toArray(new String[this.configExtensionPaths.size()]);
            for (int i = paths.length - 1; i >= 0; --i) {
                if (i == paths.length - 1) {
                    this.init(this.configurationService.getInputStream(paths[i]));
                    continue;
                }
                this.merge(this.configurationService.getInputStream(paths[i]));
            }
            if (this.configExtensionPaths.isEmpty()) {
                this.init(this.configurationService.getInputStream(this.param.getValue()));
            } else {
                this.merge(this.configurationService.getInputStream(this.param.getValue()));
            }
            if (this.configurationPersister != null) {
                if (this.configurationPersister.hasConfig()) {
                    this.merge(this.configurationPersister.read());
                }
                this.retain();
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(new RepositoryConfigurationException("Fail to init from xml! Reason: " + e, e));
        }
    }

    public void stop() {
    }
}

