/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.backup.rdbms.DirectoryRestore;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.DefaultChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexException;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.LocalIndexMarker;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineIOException;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineRepositoryException;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneVirtualTableResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.rpc.TopologyChangeEvent;
import org.exoplatform.services.rpc.TopologyChangeListener;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
@Managed
@NameTemplate(value={@Property(key="service", value="SearchManager")})
public class SearchManager
implements Startable,
MandatoryItemsPersistenceListener,
Suspendable,
Backupable,
TopologyChangeListener {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.SearchManager");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected final QueryHandlerEntry config;
    protected final DocumentReaderService extractor;
    protected QueryHandler handler;
    protected final ItemDataConsumer itemMgr;
    protected final NamespaceRegistryImpl nsReg;
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final SearchManager parentSearchManager;
    protected IndexingTree indexingTree;
    private final ConfigurationManager cfm;
    protected LuceneVirtualTableResolver virtualTableResolver;
    protected IndexerChangesFilter changesFilter;
    protected final String repositoryName;
    protected final String workspaceName;
    protected final RepositoryService rService;
    protected final String wsId;
    protected final String wsContainerId;
    protected final RPCService rpcService;
    protected boolean isSuspended = false;
    protected Boolean isResponsibleForResuming = false;
    private RemoteCommand suspend;
    private RemoteCommand resume;
    private final IndexRecovery indexRecovery;
    private RemoteCommand requestForResponsibleForResuming;
    private RemoteCommand changeIndexState;
    private final ExoContainerContext ctx;
    private String hotReindexingState = "not stated";

    public SearchManager(ExoContainerContext ctx, WorkspaceEntry wEntry, RepositoryEntry rEntry, RepositoryService rService, QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder) throws RepositoryException, RepositoryConfigurationException {
        this(ctx, wEntry, rEntry, rService, config, nsReg, ntReg, itemMgr, parentSearchManager, extractor, cfm, indexSearcherHolder, null);
    }

    public SearchManager(ExoContainerContext ctx, WorkspaceEntry wEntry, RepositoryEntry rEntry, RepositoryService rService, QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder, RPCService rpcService) throws RepositoryException, RepositoryConfigurationException {
        this.ctx = ctx;
        this.wsContainerId = ctx.getName();
        this.rpcService = rpcService;
        this.repositoryName = rEntry.getName();
        this.workspaceName = wEntry.getName();
        this.rService = rService;
        this.wsId = wEntry.getUniqueName();
        this.extractor = extractor;
        indexSearcherHolder.addIndexSearcher(this);
        this.config = config;
        this.nodeTypeDataManager = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.cfm = cfm;
        this.virtualTableResolver = new LuceneVirtualTableResolver(this.nodeTypeDataManager, nsReg);
        SearchManager searchManager = this.parentSearchManager = parentSearchManager != null ? parentSearchManager.get() : null;
        if (parentSearchManager != null) {
            ((WorkspacePersistentDataManager)this.itemMgr).addItemPersistenceListener(this);
        }
        if (rpcService == null) {
            this.indexRecovery = null;
        } else {
            this.doInitRemoteCommands();
            this.indexRecovery = new IndexRecoveryImpl(rpcService, this);
            rpcService.registerTopologyChangeListener((TopologyChangeListener)this);
            rpcService.registerTopologyChangeListener((TopologyChangeListener)this.indexRecovery);
        }
    }

    public void createNewOrAdd(String key, ItemState state, Map<String, List<ItemState>> updatedNodes) {
        List<ItemState> list = updatedNodes.get(key);
        if (list == null) {
            list = new ArrayList<ItemState>();
            updatedNodes.put(key, list);
        }
        list.add(state);
    }

    public javax.jcr.query.Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, node);
        return query;
    }

    public javax.jcr.query.Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, statement, language);
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getFieldNames() throws IndexException {
        HashSet<String> fildsSet = new HashSet<String>();
        if (!(this.handler instanceof SearchIndex)) return fildsSet;
        IndexReader reader = null;
        try {
            try {
                reader = ((SearchIndex)this.handler).getIndexReader();
                Collection fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
                for (Object field : fields) {
                    fildsSet.add((String)field);
                }
                Object var7_7 = null;
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
        }
        try {}
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        if (reader == null) return fildsSet;
        reader.close();
        return fildsSet;
    }

    public QueryHandler getHandler() {
        return this.handler;
    }

    public Set<String> getNodesByNodeType(InternalQName nodeType) throws RepositoryException {
        return this.getNodes(this.virtualTableResolver.resolve(nodeType, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNodesByUri(String uri) throws RepositoryException {
        Set<String> result;
        int defaultClauseCount = BooleanQuery.getMaxClauseCount();
        try {
            ValueFactoryImpl valueFactory = new ValueFactoryImpl(new LocationFactory(this.nsReg));
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            BooleanQuery query = new BooleanQuery();
            String prefix = this.nsReg.getNamespacePrefixByURI(uri);
            query.add((Query)new WildcardQuery(new Term(FieldNames.LABEL, prefix + ":*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(FieldNames.PROPERTIES_SET, prefix + ":*")), BooleanClause.Occur.SHOULD);
            result = this.getNodes((Query)query);
            try {
                Set<String> props = this.getFieldNames();
                query = new BooleanQuery();
                for (String fieldName : props) {
                    if (FieldNames.PROPERTIES_SET.equals(fieldName)) continue;
                    query.add((Query)new WildcardQuery(new Term(fieldName, "*" + prefix + ":*")), BooleanClause.Occur.SHOULD);
                }
            }
            catch (IndexException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
            Set<String> propSet = this.getNodes((Query)query);
            for (String uuid : propSet) {
                if (!this.isPrefixMatch(valueFactory, uuid, prefix)) continue;
                result.add(uuid);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            BooleanQuery.setMaxClauseCount((int)defaultClauseCount);
            throw throwable;
        }
        BooleanQuery.setMaxClauseCount((int)defaultClauseCount);
        return result;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        if (itemStates.getSize() > 0 && this.changesFilter != null && this.parentSearchManager != null) {
            this.changesFilter.onSaveItems(itemStates);
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start");
        }
        try {
            if (this.indexingTree == null) {
                ArrayList<QPath> excludedPath = new ArrayList<QPath>();
                excludedPath.add(Constants.JCR_SYSTEM_PATH);
                String excludedNodeIdentifer = this.config.getParameterValue("excluded-node-identifers", null);
                if (excludedNodeIdentifer != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(excludedNodeIdentifer);
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            ItemData excludeData = this.itemMgr.getItemData(stringTokenizer.nextToken());
                            if (excludeData == null) continue;
                            excludedPath.add(excludeData.getQPath());
                        }
                        catch (RepositoryException e) {
                            log.warn((Object)e.getLocalizedMessage());
                        }
                    }
                }
                NodeData indexingRootData = null;
                String rootNodeIdentifer = this.config.getParameterValue("root-node-id", null);
                if (rootNodeIdentifer != null) {
                    try {
                        ItemData indexingRootDataItem = this.itemMgr.getItemData(rootNodeIdentifer);
                        if (indexingRootDataItem != null && indexingRootDataItem.isNode()) {
                            indexingRootData = (NodeData)indexingRootDataItem;
                        }
                    }
                    catch (RepositoryException e) {
                        log.warn((Object)(e.getLocalizedMessage() + " Indexing root set to " + Constants.ROOT_PATH.getAsString()));
                    }
                } else {
                    try {
                        indexingRootData = (NodeData)this.itemMgr.getItemData("00exo0jcr0root0uuid0000000000000");
                    }
                    catch (RepositoryException e) {
                        log.error((Object)"Fail to load root node data");
                    }
                }
                this.indexingTree = new IndexingTree(indexingRootData, excludedPath);
            }
            this.initializeQueryHandler();
        }
        catch (RepositoryException e) {
            log.error((Object)e.getLocalizedMessage());
            this.handler = null;
            throw new RuntimeException(e.getLocalizedMessage(), e.getCause());
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)e.getLocalizedMessage());
            this.handler = null;
            throw new RuntimeException(e.getLocalizedMessage(), e.getCause());
        }
    }

    public void stop() {
        this.handler.close();
        if (this.parentSearchManager != null) {
            this.changesFilter.close();
        }
        log.info((Object)"Search manager stopped");
    }

    public void updateIndex(Set<String> removedNodes, Set<String> addedNodes) throws RepositoryException, IOException {
        ChangesHolder changes = this.getChanges(removedNodes, addedNodes);
        this.apply(changes);
    }

    public void apply(ChangesHolder changes) throws RepositoryException, IOException {
        if (!(this.handler == null || changes == null || changes.getAdd().isEmpty() && changes.getRemove().isEmpty())) {
            this.handler.apply(changes);
        }
    }

    public ChangesHolder getChanges(final Set<String> removedNodes, final Set<String> addedNodes) {
        if (this.handler != null) {
            Iterator<NodeData> addedStates = new Iterator<NodeData>(){
                private final Iterator<String> iter;
                {
                    this.iter = addedNodes.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public NodeData next() {
                    do {
                        String id = this.iter.next();
                        try {
                            ItemData item = SearchManager.this.itemMgr.getItemData(id);
                            if (item != null) {
                                if (item.isNode()) {
                                    if (SearchManager.this.indexingTree.isExcluded(item)) continue;
                                    return (NodeData)item;
                                }
                                log.warn((Object)("Node not found, but property " + id + ", " + item.getQPath().getAsString() + " found. "));
                                continue;
                            }
                            log.warn((Object)("Unable to index node with id " + id + ", node does not exist."));
                        }
                        catch (RepositoryException e) {
                            log.error((Object)("Can't read next node data " + id), (Throwable)e);
                        }
                    } while (this.iter.hasNext());
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            Iterator<String> removedIds = new Iterator<String>(){
                private final Iterator<String> iter;
                {
                    this.iter = removedNodes.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public String next() {
                    return this.nextNodeId();
                }

                public String nextNodeId() throws NoSuchElementException {
                    return this.iter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            if (removedNodes.size() > 0 || addedNodes.size() > 0) {
                return this.handler.getChanges(removedIds, addedStates);
            }
        }
        return null;
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        WorkspaceContainerFacade container;
        try {
            container = this.rService.getRepository(this.repositoryName).getWorkspaceContainer(this.workspaceName);
        }
        catch (RepositoryException e) {
            throw new RepositoryConfigurationException(e);
        }
        String changesFilterClassName = this.config.getParameterValue("changesfilter-class", null);
        boolean recoveryFilterUsed = false;
        if (changesFilterClassName != null) {
            try {
                Class<?> changesFilterClass = Class.forName(changesFilterClassName);
                if (changesFilterClass != null) {
                    recoveryFilterUsed = LocalIndexMarker.class.isAssignableFrom(changesFilterClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException(e.getMessage(), e);
            }
        }
        QueryHandlerContext context = new QueryHandlerContext(container, this.itemMgr, this.indexingTree, this.nodeTypeDataManager, this.nsReg, parentHandler, PrivilegedFileHelper.getAbsolutePath((File)this.getIndexDirectory()), this.extractor, true, recoveryFilterUsed, this.virtualTableResolver, this.indexRecovery, this.rpcService, this.repositoryName, this.wsId);
        return context;
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            String queryImplClassName = this.handler.getQueryClass();
            Object obj = Class.forName(queryImplClassName).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(queryImplClassName + " is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString(), t);
        }
    }

    protected String getIndexDirParam() throws RepositoryConfigurationException {
        String dir = this.config.getParameterValue("index-dir", null);
        if (dir == null) {
            log.warn((Object)"index-dir parameter not found. Using outdated parameter name indexDir");
            dir = this.config.getParameterValue("indexDir");
        }
        return dir;
    }

    protected IndexingTree getIndexingTree() {
        return this.indexingTree;
    }

    public ExoContainerContext getExoContainerContext() {
        return this.ctx;
    }

    protected IndexerChangesFilter initializeChangesFilter() throws RepositoryException, RepositoryConfigurationException {
        IndexerChangesFilter newChangesFilter = null;
        Class changesFilterClass = DefaultChangesFilter.class;
        String changesFilterClassName = this.config.getParameterValue("changesfilter-class", null);
        try {
            if (changesFilterClassName != null) {
                changesFilterClass = Class.forName(changesFilterClassName, true, this.getClass().getClassLoader());
            }
            Constructor constuctor = changesFilterClass.getConstructor(SearchManager.class, SearchManager.class, QueryHandlerEntry.class, IndexingTree.class, IndexingTree.class, QueryHandler.class, QueryHandler.class, ConfigurationManager.class);
            if (this.parentSearchManager != null) {
                newChangesFilter = (IndexerChangesFilter)constuctor.newInstance(this, this.parentSearchManager, this.config, this.indexingTree, this.parentSearchManager.getIndexingTree(), this.handler, this.parentSearchManager.getHandler(), this.cfm);
            }
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        return newChangesFilter;
    }

    protected void initializeQueryHandler() throws RepositoryException, RepositoryConfigurationException {
        String className = this.config.getType();
        if (className == null) {
            throw new RepositoryConfigurationException("Content hanler       configuration fail");
        }
        try {
            Class<?> qHandlerClass = Class.forName(className, true, this.getClass().getClassLoader());
            try {
                Constructor<?> constuctor = qHandlerClass.getConstructor(String.class, QueryHandlerEntry.class, ConfigurationManager.class);
                this.handler = (QueryHandler)constuctor.newInstance(this.wsContainerId, this.config, this.cfm);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constuctor = qHandlerClass.getConstructor(QueryHandlerEntry.class, ConfigurationManager.class);
                this.handler = (QueryHandler)constuctor.newInstance(this.config, this.cfm);
            }
            QueryHandler parentHandler = this.parentSearchManager != null ? this.parentSearchManager.getHandler() : null;
            QueryHandlerContext context = this.createQueryHandlerContext(parentHandler);
            this.handler.setContext(context);
            if (this.parentSearchManager != null) {
                this.changesFilter = this.initializeChangesFilter();
                this.parentSearchManager.setChangesFilter(this.changesFilter);
            }
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setChangesFilter(IndexerChangesFilter changesFilter) {
        if (this.changesFilter == null) {
            this.changesFilter = changesFilter;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getNodes(Query query) throws RepositoryException {
        HashSet<String> hashSet;
        HashSet<String> result = new HashSet<String>();
        QueryHits hits = null;
        try {
            try {
                ScoreNode sn;
                hits = this.handler.executeQuery(query);
                while ((sn = hits.nextScoreNode()) != null) {
                    result.add(sn.getNodeId());
                }
                hashSet = result;
                Object var7_8 = null;
                if (hits == null) return hashSet;
            }
            catch (IndexOfflineIOException e) {
                throw new IndexOfflineRepositoryException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (hits == null) throw throwable;
            try {
                hits.close();
                throw throwable;
            }
            catch (IOException e) {
                log.error((Object)"Can not close QueryHits.", (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            log.error((Object)"Can not close QueryHits.", (Throwable)e);
            return hashSet;
        }
        hits.close();
        return hashSet;
    }

    private boolean isPrefixMatch(InternalQName value, String prefix) throws RepositoryException {
        return value.getNamespace().equals(this.nsReg.getNamespaceURIByPrefix(prefix));
    }

    private boolean isPrefixMatch(QPath value, String prefix) throws RepositoryException {
        for (int i = 0; i < value.getEntries().length; ++i) {
            if (!this.isPrefixMatch(value.getEntries()[i], prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrefixMatch(ValueFactoryImpl valueFactory, String uuid, String prefix) throws RepositoryException {
        ItemData node = this.itemMgr.getItemData(uuid);
        if (node != null && node.isNode()) {
            List<PropertyData> props = this.itemMgr.getChildPropertiesData((NodeData)node);
            for (PropertyData propertyData : props) {
                if (propertyData.getType() != 8 && propertyData.getType() != 7) continue;
                for (ValueData vdata : propertyData.getValues()) {
                    Value val = valueFactory.loadValue(vdata, propertyData.getType());
                    if (!(propertyData.getType() == 8 ? this.isPrefixMatch(((PathValue)val).getQPath(), prefix) : propertyData.getType() == 7 && this.isPrefixMatch(((NameValue)val).getQName(), prefix))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isTXAware() {
        return false;
    }

    public String getWsId() {
        return this.wsId;
    }

    @Override
    public void suspend() throws SuspendException {
        this.isResponsibleForResuming = true;
        if (this.rpcService != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.suspend, true, new Serializable[0]);
            }
            catch (SecurityException e) {
                throw new SuspendException(e);
            }
            catch (RPCException e) {
                throw new SuspendException(e);
            }
        } else {
            this.suspendLocally();
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setOnline(boolean isOnline, boolean allowQuery, boolean dropStaleIndexes) throws IOException {
        this.handler.setOnline(isOnline, allowQuery, dropStaleIndexes);
    }

    public boolean isOnline() {
        return this.handler.isOnline();
    }

    @Override
    public void resume() throws ResumeException {
        if (this.rpcService != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.resume, true, new Serializable[0]);
            }
            catch (SecurityException e) {
                throw new ResumeException(e);
            }
            catch (RPCException e) {
                throw new ResumeException(e);
            }
        } else {
            this.resumeLocally();
        }
        this.isResponsibleForResuming = false;
    }

    @Managed
    @ManagedDescription(value="Starts hot async reindexing")
    public void reindex(final boolean dropExisting) throws IllegalStateException {
        if (this.handler == null || this.handler.getIndexerIoModeHandler() == null || this.changesFilter == null) {
            throw new IllegalStateException("Index might have not been initialized yet.");
        }
        if (this.handler.getIndexerIoModeHandler().getMode() != IndexerIoMode.READ_WRITE) {
            throw new IllegalStateException("Index is not in READ_WRITE mode and reindexing can't be launched. Please start reindexing on coordinator node.");
        }
        if (this.isSuspended || !this.handler.isOnline()) {
            throw new IllegalStateException("Can't start reindexing while index is " + (this.isSuspended ? "SUSPENDED." : "already OFFLINE (it means that reindexing is in progress).") + ".");
        }
        log.info((Object)("Starting hot reindexing on the " + this.handler.getContext().getRepositoryName() + "/" + this.handler.getContext().getContainer().getWorkspaceName() + ", with" + (dropExisting ? "" : "out") + " dropping the existing indexes."));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block55: {
                    boolean successful;
                    block54: {
                        block53: {
                            block52: {
                                successful = false;
                                SearchManager.this.hotReindexingState = "Running. Started at " + sdf.format(Calendar.getInstance().getTime());
                                SearchManager.this.isResponsibleForResuming = true;
                                if (SearchManager.this.rpcService != null && SearchManager.this.changesFilter.isShared()) {
                                    SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(false), Boolean.valueOf(!dropExisting)});
                                } else {
                                    SearchManager.this.handler.setOnline(false, !dropExisting, true);
                                }
                                if (SearchManager.this.handler instanceof SearchIndex) {
                                    ((SearchIndex)SearchManager.this.handler).getIndex().reindex(SearchManager.this.itemMgr);
                                    successful = true;
                                    break block52;
                                }
                                log.error((Object)"This kind of QuerHandler class doesn't support hot reindxing.");
                            }
                            Object var4_2 = null;
                            if (SearchManager.this.rpcService == null || !SearchManager.this.changesFilter.isShared()) break block53;
                            try {
                                SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(true)});
                            }
                            catch (SecurityException e2) {
                                log.error((Object)"Error setting index back online in a cluster", (Throwable)e2);
                            }
                            catch (RPCException e3) {
                                log.error((Object)"Error setting index back online in a cluster", (Throwable)e3);
                            }
                            break block54;
                        }
                        try {
                            SearchManager.this.handler.setOnline(true, true, true);
                        }
                        catch (IOException e4) {
                            log.error((Object)"Error setting index back online locally");
                        }
                    }
                    if (successful) {
                        SearchManager.this.hotReindexingState = "Finished at " + sdf.format(Calendar.getInstance().getTime());
                        log.info((Object)"Reindexing finished successfully.");
                    } else {
                        SearchManager.this.hotReindexingState = "Stopped with errors at " + sdf.format(Calendar.getInstance().getTime());
                        log.info((Object)"Reindexing halted with errors.");
                    }
                    SearchManager.this.isResponsibleForResuming = false;
                    {
                        break block55;
                        catch (RepositoryException e) {
                            log.error((Object)"Error while reindexing the workspace", (Throwable)e);
                            Object var4_3 = null;
                            if (SearchManager.this.rpcService != null && SearchManager.this.changesFilter.isShared()) {
                                try {
                                    SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(true)});
                                }
                                catch (SecurityException e2) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e2);
                                }
                                catch (RPCException e3) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e3);
                                }
                            } else {
                                try {
                                    SearchManager.this.handler.setOnline(true, true, true);
                                }
                                catch (IOException e4) {
                                    log.error((Object)"Error setting index back online locally");
                                }
                            }
                            if (successful) {
                                SearchManager.this.hotReindexingState = "Finished at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing finished successfully.");
                            } else {
                                SearchManager.this.hotReindexingState = "Stopped with errors at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing halted with errors.");
                            }
                            SearchManager.this.isResponsibleForResuming = false;
                            break block55;
                        }
                        catch (SecurityException e) {
                            log.error((Object)"Can't change state to offline.", (Throwable)e);
                            Object var4_4 = null;
                            if (SearchManager.this.rpcService != null && SearchManager.this.changesFilter.isShared()) {
                                try {
                                    SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(true)});
                                }
                                catch (SecurityException e2) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e2);
                                }
                                catch (RPCException e3) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e3);
                                }
                            } else {
                                try {
                                    SearchManager.this.handler.setOnline(true, true, true);
                                }
                                catch (IOException e4) {
                                    log.error((Object)"Error setting index back online locally");
                                }
                            }
                            if (successful) {
                                SearchManager.this.hotReindexingState = "Finished at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing finished successfully.");
                            } else {
                                SearchManager.this.hotReindexingState = "Stopped with errors at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing halted with errors.");
                            }
                            SearchManager.this.isResponsibleForResuming = false;
                            break block55;
                        }
                        catch (RPCException e) {
                            log.error((Object)"Can't change state to offline.", (Throwable)e);
                            Object var4_5 = null;
                            if (SearchManager.this.rpcService != null && SearchManager.this.changesFilter.isShared()) {
                                try {
                                    SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(true)});
                                }
                                catch (SecurityException e2) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e2);
                                }
                                catch (RPCException e3) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e3);
                                }
                            } else {
                                try {
                                    SearchManager.this.handler.setOnline(true, true, true);
                                }
                                catch (IOException e4) {
                                    log.error((Object)"Error setting index back online locally");
                                }
                            }
                            if (successful) {
                                SearchManager.this.hotReindexingState = "Finished at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing finished successfully.");
                            } else {
                                SearchManager.this.hotReindexingState = "Stopped with errors at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing halted with errors.");
                            }
                            SearchManager.this.isResponsibleForResuming = false;
                            break block55;
                        }
                        catch (IOException e) {
                            log.error((Object)"Erroe while reindexing the workspace", (Throwable)e);
                            Object var4_6 = null;
                            if (SearchManager.this.rpcService != null && SearchManager.this.changesFilter.isShared()) {
                                try {
                                    SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(true)});
                                }
                                catch (SecurityException e2) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e2);
                                }
                                catch (RPCException e3) {
                                    log.error((Object)"Error setting index back online in a cluster", (Throwable)e3);
                                }
                            } else {
                                try {
                                    SearchManager.this.handler.setOnline(true, true, true);
                                }
                                catch (IOException e4) {
                                    log.error((Object)"Error setting index back online locally");
                                }
                            }
                            if (successful) {
                                SearchManager.this.hotReindexingState = "Finished at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing finished successfully.");
                            } else {
                                SearchManager.this.hotReindexingState = "Stopped with errors at " + sdf.format(Calendar.getInstance().getTime());
                                log.info((Object)"Reindexing halted with errors.");
                            }
                            SearchManager.this.isResponsibleForResuming = false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        if (SearchManager.this.rpcService != null && SearchManager.this.changesFilter.isShared()) {
                            try {
                                SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.changeIndexState, true, new Serializable[]{Boolean.valueOf(true), Boolean.valueOf(true)});
                            }
                            catch (SecurityException e2) {
                                log.error((Object)"Error setting index back online in a cluster", (Throwable)e2);
                            }
                            catch (RPCException e3) {
                                log.error((Object)"Error setting index back online in a cluster", (Throwable)e3);
                            }
                        } else {
                            try {
                                SearchManager.this.handler.setOnline(true, true, true);
                            }
                            catch (IOException e4) {
                                log.error((Object)"Error setting index back online locally");
                            }
                        }
                        if (successful) {
                            SearchManager.this.hotReindexingState = "Finished at " + sdf.format(Calendar.getInstance().getTime());
                            log.info((Object)"Reindexing finished successfully.");
                        } else {
                            SearchManager.this.hotReindexingState = "Stopped with errors at " + sdf.format(Calendar.getInstance().getTime());
                            log.info((Object)"Reindexing halted with errors.");
                        }
                        SearchManager.this.isResponsibleForResuming = false;
                        throw throwable;
                    }
                }
            }
        }, "HotReindexing-" + this.handler.getContext().getRepositoryName() + "-" + this.handler.getContext().getContainer().getWorkspaceName()).start();
    }

    @Managed
    @ManagedDescription(value="Hot async reindexing state")
    public String getHotReindexingState() {
        return this.hotReindexingState;
    }

    @Managed
    @ManagedDescription(value="Index IO mode (READ_ONLY/READ_WRITE)")
    public String getIOMode() {
        if (this.handler == null || this.handler.getIndexerIoModeHandler() == null) {
            return "not initialized";
        }
        return this.handler.getIndexerIoModeHandler().getMode() == IndexerIoMode.READ_WRITE ? "READ_WRITE" : "READ_ONLY";
    }

    @Managed
    @ManagedDescription(value="Index state (Online/Offline(indexing))")
    public String getState() {
        if (this.handler == null) {
            return "not initialized";
        }
        return this.handler.isOnline() ? "Online" : "Offline (indexing)";
    }

    @Managed
    @ManagedDescription(value="QueryHandler class")
    public String getQuerHandlerClass() {
        if (this.handler != null) {
            return this.handler.getClass().getCanonicalName();
        }
        return "not initialized";
    }

    @Managed
    @ManagedDescription(value="ChangesFilter class")
    public String getChangesFilterClass() {
        if (this.changesFilter != null) {
            return this.changesFilter.getClass().getCanonicalName();
        }
        return "not initialized";
    }

    private void doInitRemoteCommands() {
        this.suspend = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-suspend-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                SearchManager.this.suspendLocally();
                return null;
            }
        });
        this.resume = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-resume-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                SearchManager.this.resumeLocally();
                return null;
            }
        });
        this.requestForResponsibleForResuming = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-requestForResponsibilityForResuming-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                return SearchManager.this.isResponsibleForResuming;
            }
        });
        this.changeIndexState = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-changeIndexerState-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                boolean isOnline = (Boolean)args[0];
                boolean allowQuery = args.length == 2 ? (Boolean)args[1] : false;
                SearchManager.this.setOnline(isOnline, allowQuery, true);
                return null;
            }
        });
    }

    protected void suspendLocally() throws SuspendException {
        if (!this.handler.isOnline()) {
            throw new SuspendException("Can't suspend index, while reindexing in progeress.");
        }
        if (this.isSuspended) {
            throw new SuspendException("Component already suspended.");
        }
        if (this.handler instanceof Suspendable) {
            ((Suspendable)((Object)this.handler)).suspend();
        }
        this.isSuspended = true;
    }

    protected void resumeLocally() throws ResumeException {
        if (!this.isSuspended) {
            throw new ResumeException("Component is not suspended.");
        }
        if (this.handler instanceof Suspendable) {
            ((Suspendable)((Object)this.handler)).resume();
        }
        this.isSuspended = false;
    }

    public void onChange(TopologyChangeEvent event) {
        if (this.isSuspended) {
            new Thread(){

                public synchronized void run() {
                    try {
                        List results = SearchManager.this.rpcService.executeCommandOnAllNodes(SearchManager.this.requestForResponsibleForResuming, true, new Serializable[0]);
                        for (Object result : results) {
                            if (!((Boolean)result).booleanValue()) continue;
                            return;
                        }
                        try {
                            SearchManager.this.resumeLocally();
                        }
                        catch (ResumeException e) {
                            log.error((Object)"Can not resume component", (Throwable)e);
                        }
                    }
                    catch (SecurityException e1) {
                        log.error((Object)"You haven't privileges to execute remote command", (Throwable)e1);
                    }
                    catch (RPCException e1) {
                        log.error((Object)"Exception during command execution", (Throwable)e1);
                    }
                }
            }.start();
        }
    }

    @Override
    public void clean() throws BackupException {
        try {
            DirectoryHelper.removeDirectory(this.getIndexDirectory());
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void backup(File storageDir) throws BackupException {
        try {
            File indexDir = this.getIndexDirectory();
            if (!PrivilegedFileHelper.exists((File)indexDir)) {
                throw new BackupException("Can't backup index. Directory " + PrivilegedFileHelper.getCanonicalPath((File)indexDir) + " doesn't exists");
            }
            File destZip = new File(storageDir, this.getStorageName() + ".zip");
            DirectoryHelper.compressDirectory(indexDir, destZip);
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    protected File getIndexDirectory() throws RepositoryConfigurationException {
        return new File(this.getIndexDirParam());
    }

    protected String getStorageName() {
        return "index";
    }

    @Override
    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        try {
            File zipFile = new File((File)context.getObject("storage-dir"), this.getStorageName() + ".zip");
            if (PrivilegedFileHelper.exists((File)zipFile)) {
                return new DirectoryRestore(this.getIndexDirectory(), zipFile);
            }
            zipFile = new File((File)context.getObject("storage-dir"), this.getStorageName());
            if (PrivilegedFileHelper.exists((File)zipFile)) {
                return new DirectoryRestore(this.getIndexDirectory(), zipFile);
            }
            throw new BackupException("There is no backup data for index");
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
    }
}

