/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.util.regex.Pattern;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class ExpressionValidator
implements Validator {
    private Pattern pattern;
    private String key_;

    public ExpressionValidator() {
    }

    public ExpressionValidator(String regex) {
        this.pattern = Pattern.compile(regex);
        this.key_ = "ExpressionValidator.msg.value-invalid";
    }

    public ExpressionValidator(String regex, String key) {
        this.pattern = Pattern.compile(regex);
        this.key_ = key;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        String value;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        if (uiInput.getValue() != null && this.pattern.matcher(value = ((String)uiInput.getValue()).trim()).find()) {
            return;
        }
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        Object[] args = new Object[]{label};
        throw new MessageException(new ApplicationMessage(this.key_, args, 1));
    }
}

