/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CleanableFilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.SQLExceptionHandler;
import org.exoplatform.services.jcr.impl.storage.value.ValueStorageNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileIOHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCStorageConnection
extends DBConstants
implements WorkspaceStorageConnection {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCStorageConnection");
    public static final int I_CLASS_NODE = 1;
    public static final int I_CLASS_PROPERTY = 2;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected final int maxBufferSize;
    protected final File swapDirectory;
    protected final FileCleaner swapCleaner;
    protected final Connection dbConnection;
    protected final String containerName;
    protected final SQLExceptionHandler exceptionHandler;
    protected final List<ValueIOChannel> valueChanges;
    protected final WriteValueHelper writeValueHelper = new WriteValueHelper();
    protected PreparedStatement findItemById;
    protected PreparedStatement findItemByPath;
    protected PreparedStatement findItemByName;
    protected PreparedStatement findChildPropertyByPath;
    protected PreparedStatement findPropertyByName;
    protected PreparedStatement findDescendantNodes;
    protected PreparedStatement findDescendantProperties;
    protected PreparedStatement findReferences;
    protected PreparedStatement findValuesByPropertyId;
    protected PreparedStatement findValuesStorageDescriptorsByPropertyId;
    protected PreparedStatement findValuesDataByPropertyId;
    protected PreparedStatement findValueByPropertyIdOrderNumber;
    protected PreparedStatement findNodesByParentId;
    protected PreparedStatement findLastOrderNumberByParentId;
    protected PreparedStatement findNodesCountByParentId;
    protected PreparedStatement findPropertiesByParentId;
    protected PreparedStatement insertItem;
    protected PreparedStatement insertNode;
    protected PreparedStatement insertProperty;
    protected PreparedStatement insertReference;
    protected PreparedStatement insertValue;
    protected PreparedStatement updateItem;
    protected PreparedStatement updateItemPath;
    protected PreparedStatement updateNode;
    protected PreparedStatement updateProperty;
    protected PreparedStatement deleteItem;
    protected PreparedStatement deleteNode;
    protected PreparedStatement deleteProperty;
    protected PreparedStatement deleteReference;
    protected PreparedStatement deleteValue;
    protected PreparedStatement renameNode;
    protected PreparedStatement findNodesAndProperties;
    protected final boolean readOnly;
    protected static Comparator<ValueData> COMPARATOR_VALUE_DATA = new Comparator<ValueData>(){

        @Override
        public int compare(ValueData vd1, ValueData vd2) {
            return vd1.getOrderNumber() - vd2.getOrderNumber();
        }
    };

    protected JDBCStorageConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        this.valueStorageProvider = valueStorageProvider;
        this.maxBufferSize = maxBufferSize;
        this.swapDirectory = swapDirectory;
        this.swapCleaner = swapCleaner;
        this.containerName = containerName;
        this.dbConnection = dbConnection;
        this.readOnly = readOnly;
        if (!readOnly && dbConnection.getAutoCommit()) {
            dbConnection.setAutoCommit(false);
        }
        this.prepareQueries();
        this.exceptionHandler = new SQLExceptionHandler(containerName, this);
        this.valueChanges = new ArrayList<ValueIOChannel>();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JDBCStorageConnection) {
            JDBCStorageConnection another = (JDBCStorageConnection)obj;
            return this.getJdbcConnection() == another.getJdbcConnection();
        }
        return false;
    }

    public Connection getJdbcConnection() {
        return this.dbConnection;
    }

    protected abstract void prepareQueries() throws SQLException;

    protected abstract String getInternalId(String var1);

    protected abstract String getIdentifier(String var1);

    protected void checkIfOpened() throws IllegalStateException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    @Override
    public boolean isOpened() {
        try {
            return !this.dbConnection.isClosed();
        }
        catch (SQLException e) {
            LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public final void rollback() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            try {
                this.closeStatements();
                if (!this.readOnly) {
                    this.dbConnection.rollback();
                }
                this.dbConnection.close();
                for (int p = this.valueChanges.size() - 1; p >= 0; --p) {
                    this.valueChanges.get(p).rollback();
                }
                Object var3_4 = null;
                this.valueChanges.clear();
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.valueChanges.clear();
            throw throwable;
        }
    }

    @Override
    public final void close() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.closeStatements();
            if (!this.readOnly && this.dbConnection.getTransactionIsolation() > 2) {
                this.dbConnection.rollback();
            }
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void closeStatements() {
        try {
            if (this.findItemById != null) {
                this.findItemById.close();
            }
            if (this.findItemByPath != null) {
                this.findItemByPath.close();
            }
            if (this.findItemByName != null) {
                this.findItemByName.close();
            }
            if (this.findChildPropertyByPath != null) {
                this.findChildPropertyByPath.close();
            }
            if (this.findPropertyByName != null) {
                this.findPropertyByName.close();
            }
            if (this.findDescendantNodes != null) {
                this.findDescendantNodes.close();
            }
            if (this.findDescendantProperties != null) {
                this.findDescendantProperties.close();
            }
            if (this.findReferences != null) {
                this.findReferences.close();
            }
            if (this.findValuesByPropertyId != null) {
                this.findValuesByPropertyId.close();
            }
            if (this.findValuesStorageDescriptorsByPropertyId != null) {
                this.findValuesStorageDescriptorsByPropertyId.close();
            }
            if (this.findValuesDataByPropertyId != null) {
                this.findValuesDataByPropertyId.close();
            }
            if (this.findValueByPropertyIdOrderNumber != null) {
                this.findValueByPropertyIdOrderNumber.close();
            }
            if (this.findNodesByParentId != null) {
                this.findNodesByParentId.close();
            }
            if (this.findLastOrderNumberByParentId != null) {
                this.findLastOrderNumberByParentId.close();
            }
            if (this.findNodesCountByParentId != null) {
                this.findNodesCountByParentId.close();
            }
            if (this.findPropertiesByParentId != null) {
                this.findPropertiesByParentId.close();
            }
            if (this.insertItem != null) {
                this.insertItem.close();
            }
            if (this.insertNode != null) {
                this.insertNode.close();
            }
            if (this.insertProperty != null) {
                this.insertProperty.close();
            }
            if (this.insertReference != null) {
                this.insertReference.close();
            }
            if (this.insertValue != null) {
                this.insertValue.close();
            }
            if (this.updateItem != null) {
                this.updateItem.close();
            }
            if (this.updateItemPath != null) {
                this.updateItemPath.close();
            }
            if (this.updateNode != null) {
                this.updateNode.close();
            }
            if (this.updateProperty != null) {
                this.updateProperty.close();
            }
            if (this.deleteItem != null) {
                this.deleteItem.close();
            }
            if (this.deleteNode != null) {
                this.deleteNode.close();
            }
            if (this.deleteProperty != null) {
                this.deleteProperty.close();
            }
            if (this.deleteReference != null) {
                this.deleteReference.close();
            }
            if (this.deleteValue != null) {
                this.deleteValue.close();
            }
            if (this.renameNode != null) {
                this.renameNode.close();
            }
            if (this.findNodesAndProperties != null) {
                this.findNodesAndProperties.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the statement: " + e));
        }
    }

    @Override
    public final void commit() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.closeStatements();
            if (!this.readOnly) {
                this.dbConnection.commit();
            }
            this.dbConnection.close();
            try {
                try {
                    for (ValueIOChannel vo : this.valueChanges) {
                        vo.commit();
                    }
                    Object var4_5 = null;
                    this.valueChanges.clear();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.valueChanges.clear();
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addNodeRecord(data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node added " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Node add. Database error: " + e));
            }
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    @Override
    public void add(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addPropertyRecord(data);
            if (data.getType() == 9) {
                try {
                    this.addReference(data);
                }
                catch (IOException e) {
                    throw new RepositoryException("Can't read REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
                }
            }
            this.addValues(this.getInternalId(data.getIdentifier()), data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property added " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property add. IO error: " + e), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value add " + e, (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property add. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    @Override
    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            if (this.renameNode(data) <= 0) {
                throw new JCRInvalidItemStateException("(rename) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 32);
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property add. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getIdentifier());
        try {
            int nc = this.deleteItemByIdentifier(cid);
            if (nc <= 0) {
                throw new JCRInvalidItemStateException("(delete) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 4);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node deleted " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Node remove. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    @Override
    public void delete(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getIdentifier());
        try {
            this.deleteValues(cid, data, false);
            this.deleteReference(cid);
            int nc = this.deleteItemByIdentifier(cid);
            if (nc <= 0) {
                throw new JCRInvalidItemStateException("(delete) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 4);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property deleted " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property remove. IO error: " + e), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value delete " + e, (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property remove. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getIdentifier());
            if (this.updateNodeByIdentifier(data.getPersistedVersion(), data.getQPath().getIndex(), data.getOrderNumber(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node updated " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Node update. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
    }

    @Override
    public void update(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getIdentifier());
            if (this.updatePropertyByIdentifier(data.getPersistedVersion(), data.getType(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            try {
                this.deleteReference(cid);
                if (data.getType() == 9) {
                    this.addReference(data);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't update REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
            }
            this.deleteValues(cid, data, true);
            this.addValues(cid, data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property updated " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property update. IO error: " + e), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value update " + e, (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property update. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ArrayList<NodeData> arrayList;
            ResultSet node = this.findChildNodesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            try {
                ArrayList<NodeData> childrens = new ArrayList<NodeData>();
                while (node.next()) {
                    childrens.add((NodeData)this.itemData(parent.getQPath(), node, 1, parent.getACL()));
                }
                arrayList = childrens;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    node.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                node.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        return this.getChildNodesData(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        this.checkIfOpened();
        try {
            int n;
            ResultSet count = this.findLastOrderNumberByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            if (!count.next() || count.getInt(1) <= 0) break block9;
            int n2 = count.getInt(2);
            Object var5_6 = null;
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            {
                block9: {
                    return n2;
                }
                n = -1;
            }
            Object var5_7 = null;
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return n;
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        this.checkIfOpened();
        try {
            ResultSet count = this.findChildNodesCountByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            if (!count.next()) break block7;
            int n = count.getInt(1);
            Object var5_5 = null;
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            {
                block7: {
                    return n;
                }
                throw new RepositoryException("FATAL No resulton childNodes count for " + parent.getQPath().getAsString());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ArrayList<PropertyData> arrayList;
            ResultSet prop = this.findChildPropertiesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            try {
                ArrayList<PropertyData> children = new ArrayList<PropertyData>();
                while (prop.next()) {
                    children.add((PropertyData)this.itemData(parent.getQPath(), prop, 2, null));
                }
                arrayList = children;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    prop.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                prop.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilter) throws RepositoryException, IllegalStateException {
        return this.getChildPropertiesData(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeDataIndexing> getNodesAndProperties(String lastNodeId, int offset, int limit) throws RepositoryException, IllegalStateException {
        ArrayList<NodeDataIndexing> result = new ArrayList<NodeDataIndexing>();
        this.checkIfOpened();
        try {
            ResultSet resultSet = this.findNodesAndProperties(lastNodeId, offset, limit);
            int processed = 0;
            try {
                TempNodeData tempNodeData = null;
                while (resultSet.next()) {
                    if (tempNodeData == null) {
                        tempNodeData = new TempNodeData(resultSet);
                        ++processed;
                    } else if (!resultSet.getString("ID").equals(tempNodeData.cid)) {
                        if (!this.needToSkipOffsetNodes() || processed > offset) {
                            result.add(this.createNodeDataIndexing(tempNodeData));
                        }
                        tempNodeData = new TempNodeData(resultSet);
                        ++processed;
                    }
                    if (this.needToSkipOffsetNodes() && processed <= offset) continue;
                    String key = resultSet.getString("P_NAME");
                    SortedSet<TempPropertyData> values = tempNodeData.properties.get(key);
                    if (values == null) {
                        values = new TreeSet<TempPropertyData>();
                        tempNodeData.properties.put(key, values);
                    }
                    values.add(new ExtendedTempPropertyData(resultSet));
                }
                if (!(tempNodeData == null || this.needToSkipOffsetNodes() && processed <= offset)) {
                    result.add(this.createNodeDataIndexing(tempNodeData));
                }
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        return result;
    }

    protected boolean needToSkipOffsetNodes() {
        return false;
    }

    @Override
    public boolean getChildNodesDataByPage(NodeData parent, int fromOrderNum, int limit, List<NodeData> childNodes) throws RepositoryException, IllegalStateException {
        throw new UnsupportedRepositoryOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ArrayList<PropertyData> arrayList;
            ResultSet prop = this.findChildPropertiesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            try {
                ArrayList<PropertyData> children = new ArrayList<PropertyData>();
                while (prop.next()) {
                    children.add(this.propertyData(parent.getQPath(), prop));
                }
                arrayList = children;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    prop.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                prop.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public List<ACLHolder> getACLHolders() throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported by the old JDBCWorkspaceDataContainer, use CQJDBCWorkspaceDataContainer instead.");
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        return this.getItemByIdentifier(this.getInternalId(identifier));
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException, IllegalStateException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        if (parentData != null) {
            return this.getItemByName(parentData, this.getInternalId(parentData.getIdentifier()), name, itemType);
        }
        return this.getItemByName(null, null, name, itemType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ArrayList<PropertyData> arrayList;
            ResultSet refProps = this.findReferences(this.getInternalId(nodeIdentifier));
            try {
                ArrayList<PropertyData> references = new ArrayList<PropertyData>();
                while (refProps.next()) {
                    references.add((PropertyData)this.itemData(null, refProps, 2, null));
                }
                arrayList = references;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    refProps.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                refProps.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValueData getValue(String propertyId, int orderNumb, int persistedVersion) throws RepositoryException {
        try {
            ValueData valueData;
            String cid = this.getInternalId(propertyId);
            ResultSet valueRecord = this.findValueByPropertyIdOrderNumber(cid, orderNumb);
            if (!valueRecord.next()) break block10;
            String storageId = valueRecord.getString("STORAGE_DESC");
            ValueData valueData2 = valueRecord.wasNull() ? this.readValueData(cid, orderNumb, persistedVersion, valueRecord.getBinaryStream("DATA")) : this.readValueData(propertyId, orderNumb, storageId);
            Object var9_11 = null;
            try {
                valueRecord.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            {
                block10: {
                    return valueData2;
                }
                valueData = null;
            }
            Object var9_12 = null;
            try {
                valueRecord.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return valueData;
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    valueRecord.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected ItemData getItemByIdentifier(String cid) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ItemData itemData;
            ResultSet item = this.findItemByIdentifier(cid);
            if (!item.next()) break block10;
            ItemData itemData2 = this.itemData(null, item, item.getInt("I_CLASS"), null);
            Object var5_7 = null;
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            {
                block10: {
                    return itemData2;
                }
                itemData = null;
            }
            Object var5_8 = null;
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return itemData;
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ItemData getItemByName(NodeData parent, String parentId, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            block11: {
                block10: {
                    item = null;
                    try {
                        item = this.findItemByName(parentId, name.getAsString(), name.getIndex());
                        while (item.next()) {
                            columnClass = item.getInt("I_CLASS");
                            if (itemType != ItemType.UNKNOWN && columnClass != itemType.ordinal()) continue;
                            var7_10 = this.itemData(parent.getQPath(), item, columnClass, parent.getACL());
                            var9_11 = null;
                            break block10;
                        }
                        var6_9 = null;
                        break block11;
                    }
                    catch (Throwable var8_17) {
                        var9_13 = null;
                        try {
                            if (item == null) throw var8_17;
                            item.close();
                            throw var8_17;
                        }
                        catch (SQLException e) {
                            JDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
                        }
                        throw var8_17;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [3 : 111->126)] { 
lbl28:
                // 1 sources

                if (item == null) return var7_10;
                item.close();
                return var7_10;
lbl31:
                // 1 sources

                catch (SQLException e) {
                    JDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                return var7_10;
            }
            var9_12 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 111->126)] { 
lbl37:
            // 1 sources

            if (item == null) return var6_9;
            item.close();
            return var6_9;
lbl40:
            // 1 sources

            catch (SQLException e) {
                JDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return var6_9;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        return this.traverseQPathSQ(cpid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QPath traverseQPathSQ(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        String caid = cpid;
        do {
            SQLException e2;
            Object var7_7;
            ResultSet parent = this.findItemByIdentifier(caid);
            try {
                if (!parent.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                QPathEntry qpe = new QPathEntry(InternalQName.parse(parent.getString("NAME")), parent.getInt("I_INDEX"), caid);
                qrpath.add(qpe);
                caid = parent.getString("PARENT_ID");
                var7_7 = null;
            }
            catch (Throwable throwable) {
                var7_7 = null;
                try {
                    parent.close();
                }
                catch (SQLException e2) {
                    LOG.error((Object)("Can't close the ResultSet: " + e2));
                }
                throw throwable;
            }
            try {
                parent.close();
            }
            catch (SQLException e2) {
                LOG.error((Object)("Can't close the ResultSet: " + e2));
            }
        } while (!caid.equals(Constants.ROOT_PARENT_UUID));
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    private List<AccessControlEntry> traverseACLPermissions(String cpid) throws SQLException, IllegalACLException, IllegalNameException, RepositoryException {
        String caid = cpid;
        while (!caid.equals(Constants.ROOT_PARENT_UUID)) {
            MixinInfo naMixins = this.readMixins(caid);
            if (naMixins.hasPrivilegeable()) {
                return this.readACLPermisions(caid);
            }
            if (naMixins.parentId == null) {
                caid = this.findParentId(caid);
                continue;
            }
            caid = naMixins.parentId;
        }
        throw new IllegalACLException("Can not find permissions for a node with id " + this.getIdentifier(cpid));
    }

    protected String findParentId(String cid) throws SQLException, RepositoryException {
        block6: {
            String string;
            ResultSet pidrs = this.findItemByIdentifier(cid);
            try {
                if (!pidrs.next()) break block6;
                string = pidrs.getString("PARENT_ID");
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    pidrs.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                pidrs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return string;
        }
        throw new RepositoryException("Item not found id: " + this.getIdentifier(cid));
    }

    private String traverseACLOwner(String cpid) throws SQLException, IllegalACLException, IllegalNameException, RepositoryException {
        String caid = cpid;
        while (!caid.equals(Constants.ROOT_PARENT_UUID)) {
            MixinInfo naMixins = this.readMixins(caid);
            if (naMixins.hasOwneable()) {
                return this.readACLOwner(caid);
            }
            if (naMixins.parentId == null) {
                caid = this.findParentId(caid);
                continue;
            }
            caid = naMixins.parentId;
        }
        throw new IllegalACLException("Can not find owner for a node with id " + this.getIdentifier(cpid));
    }

    private AccessControlList traverseACL(String cpid) throws SQLException, IllegalACLException, IllegalNameException, RepositoryException {
        String naOwner = null;
        List<AccessControlEntry> naPermissions = null;
        String caid = cpid;
        while (!caid.equals(Constants.ROOT_PARENT_UUID)) {
            MixinInfo naMixins = this.readMixins(caid);
            if (naOwner == null && naMixins.hasOwneable()) {
                naOwner = this.readACLOwner(caid);
                if (naPermissions != null) break;
            }
            if (naPermissions == null && naMixins.hasPrivilegeable()) {
                naPermissions = this.readACLPermisions(caid);
                if (naOwner != null) break;
            }
            if (naMixins.parentId == null) {
                caid = this.findParentId(caid);
                continue;
            }
            caid = naMixins.parentId;
        }
        if (naOwner != null && naPermissions != null) {
            return new AccessControlList(naOwner, naPermissions);
        }
        if (naOwner == null && naPermissions == null) {
            return new AccessControlList();
        }
        throw new IllegalACLException("ACL is not found for node with id " + this.getIdentifier(cpid) + " or for its ancestors. But repository is ACL enabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QPath traverseQPath_SP_PGSQL(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        PreparedStatement cstmt;
        ArrayList<QPathEntry> qrpath;
        block12: {
            if (cpid == null) {
                return null;
            }
            qrpath = new ArrayList<QPathEntry>();
            cstmt = null;
            ResultSet parent = null;
            try {
                cstmt = this.dbConnection.prepareStatement("select * from get_qpath(?) AS (id varchar, name varchar, parent_id varchar, i_index int)");
                cstmt.setString(1, cpid);
                parent = cstmt.executeQuery();
                while (parent.next()) {
                    QPathEntry qpe = new QPathEntry(InternalQName.parse(parent.getString("NAME")), parent.getInt("I_INDEX"));
                    qrpath.add(qpe);
                }
                if (qrpath.size() <= 0) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(cpid));
                }
                Object var7_6 = null;
                if (parent == null) break block12;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (parent != null) {
                    try {
                        parent.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the ResultSet: " + e));
                    }
                }
                if (cstmt != null) {
                    cstmt.close();
                }
                throw throwable;
            }
            try {
                parent.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        if (cstmt != null) {
            cstmt.close();
        }
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    private ItemData itemData(QPath parentPath, ResultSet item, int itemClass, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        String cid = item.getString("ID");
        String cname = item.getString("NAME");
        int cversion = item.getInt("VERSION");
        String cpid = item.getString("PARENT_ID");
        try {
            if (itemClass == 1) {
                int cindex = item.getInt("I_INDEX");
                int cnordernumb = item.getInt("N_ORDER_NUM");
                return this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, parentACL);
            }
            int cptype = item.getInt("P_TYPE");
            boolean cpmultivalued = item.getBoolean("P_MULTIVALUED");
            return this.loadPropertyRecord(parentPath, cname, cid, cpid, cversion, cptype, cpmultivalued);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("FATAL: Can't build item path for name " + cname + " id: " + this.getIdentifier(cid) + ". " + (Object)((Object)e));
        }
    }

    private PropertyData propertyData(QPath parentPath, ResultSet item) throws RepositoryException, SQLException, IOException {
        String cid = item.getString("ID");
        String cname = item.getString("NAME");
        int cversion = item.getInt("VERSION");
        String cpid = item.getString("PARENT_ID");
        int cptype = item.getInt("P_TYPE");
        boolean cpmultivalued = item.getBoolean("P_MULTIVALUED");
        try {
            InternalQName qname = InternalQName.parse(cname);
            QPath qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, qname);
            PersistedPropertyData pdata = new PersistedPropertyData(this.getIdentifier(cid), qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, new ArrayList<ValueData>());
            return pdata;
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("FATAL: Can't build property path for name " + cname + " id: " + this.getIdentifier(cid) + ". " + (Object)((Object)e));
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MixinInfo readMixins(String cid) throws SQLException, IllegalNameException {
        MixinInfo mixinInfo;
        ResultSet mtrs = this.findPropertyByName(cid, Constants.JCR_MIXINTYPES.getAsString());
        try {
            ArrayList<InternalQName> mts = null;
            boolean owneable = false;
            boolean privilegeable = false;
            if (mtrs.next()) {
                mts = new ArrayList<InternalQName>();
                do {
                    byte[] mxnb;
                    if ((mxnb = mtrs.getBytes("DATA")) == null) continue;
                    InternalQName mxn = InternalQName.parse(new String(mxnb));
                    mts.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                } while (mtrs.next());
            }
            mixinInfo = new MixinInfo(mts, owneable, privilegeable);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                mtrs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            throw throwable;
        }
        try {
            mtrs.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
        }
        return mixinInfo;
    }

    protected List<AccessControlEntry> readACLPermisions(String cid) throws SQLException, IllegalACLException {
        block7: {
            ArrayList<AccessControlEntry> arrayList;
            ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
            ResultSet exoPerm = this.findPropertyByName(cid, Constants.EXO_PERMISSIONS.getAsString());
            try {
                if (!exoPerm.next()) break block7;
                do {
                    StringTokenizer parser = new StringTokenizer(new String(exoPerm.getBytes("DATA")), " ");
                    naPermissions.add(new AccessControlEntry(parser.nextToken(), parser.nextToken()));
                } while (exoPerm.next());
                arrayList = naPermissions;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    exoPerm.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                exoPerm.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return arrayList;
        }
        throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
    }

    protected String readACLOwner(String cid) throws SQLException, IllegalACLException {
        block6: {
            String string;
            ResultSet exoOwner = this.findPropertyByName(cid, Constants.EXO_OWNER.getAsString());
            try {
                if (!exoOwner.next()) break block6;
                string = new String(exoOwner.getBytes("DATA"));
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    exoOwner.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                exoOwner.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            return string;
        }
        throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        try {
            PersistedNodeData persistedNodeData;
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex, cid);
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex, cid);
                parentCid = cpid;
            }
            ResultSet ptProp = this.findPropertyByName(cid, Constants.JCR_PRIMARYTYPE.getAsString());
            try {
                try {
                    if (!ptProp.next()) {
                        throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + cid + ", container " + this.containerName, null);
                    }
                    byte[] data = ptProp.getBytes("DATA");
                    InternalQName ptName = InternalQName.parse(new String(data != null ? data : new byte[]{}));
                    MixinInfo mixins = this.readMixins(cid);
                    AccessControlList acl = mixins.hasOwneable() ? (mixins.hasPrivilegeable() ? new AccessControlList(this.readACLOwner(cid), this.readACLPermisions(cid)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid), null))) : (mixins.hasPrivilegeable() ? (mixins.hasOwneable() ? new AccessControlList(this.readACLOwner(cid), this.readACLPermisions(cid)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid)) : new AccessControlList(null, this.readACLPermisions(cid)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                    persistedNodeData = new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mixins.mixinNames(), acl);
                    Object var19_20 = null;
                }
                catch (IllegalACLException e) {
                    throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                try {
                    ptProp.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                return persistedNodeData;
            }
            ptProp.close();
            return persistedNodeData;
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected PersistedPropertyData loadPropertyRecord(QPath parentPath, String cname, String cid, String cpid, int cversion, int cptype, boolean cpmultivalued) throws RepositoryException, SQLException, IOException {
        try {
            QPath qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
            String identifier = this.getIdentifier(cid);
            List<ValueData> values = this.readValues(cid, identifier, cversion);
            PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, values);
            return pdata;
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValues(String cid, PropertyData pdata, boolean update) throws IOException, SQLException, ValueStorageNotFoundException {
        ResultSet valueRecords = this.findValuesStorageDescriptorsByPropertyId(cid);
        try {
            if (valueRecords.next()) {
                this.deleteValueData(cid);
                do {
                    Object var8_7;
                    String storageId = valueRecords.getString("STORAGE_DESC");
                    if (valueRecords.wasNull()) continue;
                    ValueIOChannel channel = this.valueStorageProvider.getChannel(storageId);
                    try {
                        channel.delete(pdata.getIdentifier());
                        this.valueChanges.add(channel);
                        var8_7 = null;
                        channel.close();
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        channel.close();
                        throw throwable;
                    }
                } while (valueRecords.next());
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                valueRecords.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            throw throwable;
        }
        try {
            valueRecords.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValueData> readValues(String cid, String identifier, int cversion) throws IOException, SQLException, ValueStorageNotFoundException {
        ArrayList<ValueData> data = new ArrayList<ValueData>();
        ResultSet valueRecords = this.findValuesByPropertyId(cid);
        try {
            while (valueRecords.next()) {
                int orderNum = valueRecords.getInt("ORDER_NUM");
                String storageId = valueRecords.getString("STORAGE_DESC");
                ValueData vdata = valueRecords.wasNull() ? this.readValueData(cid, orderNum, cversion, valueRecords.getBinaryStream("DATA")) : this.readValueData(identifier, orderNum, storageId);
                data.add(vdata);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                valueRecords.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            throw throwable;
        }
        try {
            valueRecords.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValueData(String identifier, int orderNumber, String storageId) throws SQLException, IOException, ValueStorageNotFoundException {
        ValueIOChannel channel = this.valueStorageProvider.getChannel(storageId);
        try {
            ValueData valueData = channel.read(identifier, orderNumber, this.maxBufferSize);
            Object var7_6 = null;
            channel.close();
            return valueData;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            channel.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ValueData readValueData(String cid, int orderNumber, int version, InputStream content) throws SQLException, IOException {
        SwapFile swapFile;
        byte[] buffer;
        block9: {
            buffer = new byte[]{};
            byte[] spoolBuffer = new byte[32768];
            int len = 0;
            OutputStream out = null;
            swapFile = null;
            try {
                if (content != null) {
                    int read;
                    while ((read = content.read(spoolBuffer)) >= 0) {
                        if (out != null) {
                            out.write(spoolBuffer, 0, read);
                            len += read;
                            continue;
                        }
                        if (len + read > this.maxBufferSize) {
                            swapFile = SwapFile.get(this.swapDirectory, cid + orderNumber + "." + version);
                            if (swapFile.isSpooled()) {
                                buffer = null;
                                break;
                            }
                            out = PrivilegedFileHelper.fileOutputStream((File)swapFile);
                            out.write(buffer, 0, len);
                            out.write(spoolBuffer, 0, read);
                            buffer = null;
                            len += read;
                            continue;
                        }
                        byte[] newBuffer = new byte[len + read];
                        System.arraycopy(buffer, 0, newBuffer, 0, len);
                        System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                        buffer = newBuffer;
                        len += read;
                    }
                }
                Object var13_12 = null;
                if (out == null) break block9;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (out != null) {
                    out.close();
                    swapFile.spoolDone();
                }
                throw throwable;
            }
            out.close();
            swapFile.spoolDone();
        }
        if (buffer == null) {
            return new CleanableFilePersistedValueData(orderNumber, swapFile, this.swapCleaner);
        }
        return new ByteArrayPersistedValueData(orderNumber, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValues(String cid, PropertyData data) throws IOException, SQLException, RepositoryException {
        List<ValueData> vdata = data.getValues();
        for (int i = 0; i < vdata.size(); ++i) {
            String storageId;
            int streamLength;
            InputStream stream;
            ValueData vd = vdata.get(i);
            ValueIOChannel channel = this.valueStorageProvider.getApplicableChannel(data, i);
            if (channel == null) {
                if (vd.isByteArray()) {
                    byte[] dataBytes = vd.getAsByteArray();
                    stream = new ByteArrayInputStream(dataBytes);
                    streamLength = dataBytes.length;
                } else {
                    Object var13_14;
                    StreamPersistedValueData streamData = (StreamPersistedValueData)vd;
                    SwapFile swapFile = SwapFile.get(this.swapDirectory, cid + i + "." + data.getPersistedVersion());
                    try {
                        this.writeValueHelper.writeStreamedValue(swapFile, streamData);
                        var13_14 = null;
                        swapFile.spoolDone();
                    }
                    catch (Throwable throwable) {
                        var13_14 = null;
                        swapFile.spoolDone();
                        throw throwable;
                    }
                    long vlen = PrivilegedFileHelper.length((File)swapFile);
                    if (vlen > Integer.MAX_VALUE) {
                        throw new RepositoryException("Value data large of allowed by JDBC (Integer.MAX_VALUE) " + vlen + ". Property " + data.getQPath().getAsString());
                    }
                    streamLength = (int)vlen;
                    stream = streamData.getAsStream();
                }
                storageId = null;
            } else {
                channel.write(data.getIdentifier(), vd);
                this.valueChanges.add(channel);
                storageId = channel.getStorageId();
                stream = null;
                streamLength = 0;
            }
            this.addValueData(cid, i, stream, streamLength, storageId);
        }
    }

    protected NodeDataIndexing createNodeDataIndexing(TempNodeData tempNode) throws RepositoryException, SQLException, IOException, IllegalNameException {
        QPath parentPath;
        String parentCid;
        if (tempNode.cpid.equals(Constants.ROOT_PARENT_UUID)) {
            parentCid = null;
            parentPath = Constants.ROOT_PATH;
        } else {
            parentCid = tempNode.cpid;
            parentPath = QPath.makeChildPath(this.traverseQPath(tempNode.cpid), InternalQName.parse(tempNode.cname), tempNode.cindex);
        }
        InternalQName ptName = null;
        ValueData ptValue = null;
        SortedSet<TempPropertyData> ptTempProp = tempNode.properties.get(Constants.JCR_PRIMARYTYPE.getAsString());
        if (ptTempProp != null) {
            ptValue = ptTempProp.first().getValueData();
            ptName = InternalQName.parse(new String(ptValue.getAsByteArray(), "UTF-8"));
        }
        ArrayList<ValueData> mixinsData = new ArrayList<ValueData>();
        ArrayList<InternalQName> mixins = new ArrayList<InternalQName>();
        Set mixinsTempProps = tempNode.properties.get(Constants.JCR_MIXINTYPES.getAsString());
        if (mixinsTempProps != null) {
            for (TempPropertyData mxnb : mixinsTempProps) {
                ValueData vdata = mxnb.getValueData();
                mixinsData.add(vdata);
                mixins.add(InternalQName.parse(new String(vdata.getAsByteArray(), "UTF-8")));
            }
        }
        PersistedNodeData nodeData = new PersistedNodeData(this.getIdentifier(tempNode.cid), parentPath, this.getIdentifier(parentCid), tempNode.cversion, tempNode.cnordernumb, ptName, mixins.toArray(new InternalQName[mixins.size()]), null);
        HashMap<String, PropertyData> childProps = new HashMap<String, PropertyData>();
        for (String propName : tempNode.properties.keySet()) {
            ExtendedTempPropertyData prop = (ExtendedTempPropertyData)tempNode.properties.get(propName).first();
            String identifier = this.getIdentifier(prop.id);
            QPath qpath = QPath.makeChildPath(parentPath, InternalQName.parse(prop.name));
            ArrayList<ValueData> valueData = new ArrayList<ValueData>();
            if (propName.equals(Constants.JCR_PRIMARYTYPE.getAsString())) {
                valueData.add(ptValue);
            } else if (propName.equals(Constants.JCR_MIXINTYPES.getAsString())) {
                valueData = mixinsData;
            } else {
                for (TempPropertyData tempProp : tempNode.properties.get(propName)) {
                    ExtendedTempPropertyData exTempProp = (ExtendedTempPropertyData)tempProp;
                    valueData.add(exTempProp.getValueData());
                }
            }
            PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, tempNode.cid, prop.version, prop.type, prop.multi, valueData);
            childProps.put(propName, pdata);
        }
        return new NodeDataIndexing(nodeData, childProps);
    }

    protected abstract int addNodeRecord(NodeData var1) throws SQLException;

    protected abstract int addPropertyRecord(PropertyData var1) throws SQLException;

    protected abstract ResultSet findItemByIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findPropertyByName(String var1, String var2) throws SQLException;

    protected abstract ResultSet findItemByName(String var1, String var2, int var3) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findLastOrderNumberByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesCountByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findNodesAndProperties(String var1, int var2, int var3) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifier(String var1, int var2, int var3) throws SQLException;

    protected abstract int addReference(PropertyData var1) throws SQLException, IOException;

    protected abstract int renameNode(NodeData var1) throws SQLException;

    protected abstract int deleteReference(String var1) throws SQLException;

    protected abstract void deleteLockProperties() throws SQLException;

    protected abstract ResultSet findReferences(String var1) throws SQLException;

    protected abstract int deleteItemByIdentifier(String var1) throws SQLException;

    protected abstract int updateNodeByIdentifier(int var1, int var2, int var3, String var4) throws SQLException;

    protected abstract int updatePropertyByIdentifier(int var1, int var2, String var3) throws SQLException;

    protected abstract int addValueData(String var1, int var2, InputStream var3, int var4, String var5) throws SQLException;

    protected abstract int deleteValueData(String var1) throws SQLException;

    protected abstract ResultSet findValuesByPropertyId(String var1) throws SQLException;

    protected abstract ResultSet findValuesStorageDescriptorsByPropertyId(String var1) throws SQLException;

    protected abstract ResultSet findValueByPropertyIdOrderNumber(String var1, int var2) throws SQLException;

    protected class ExtendedTempPropertyData
    extends TempPropertyData {
        protected final String id;
        protected final String name;
        protected final int version;
        protected final int type;
        protected final boolean multi;
        protected final String storage_desc;

        public ExtendedTempPropertyData(ResultSet item) throws SQLException, ValueStorageNotFoundException, IOException {
            super(item, false);
            this.id = item.getString("P_ID");
            this.name = item.getString("P_NAME");
            this.version = item.getInt("P_VERSION");
            this.type = item.getInt("P_TYPE");
            this.multi = item.getBoolean("P_MULTIVALUED");
            this.storage_desc = item.getString("STORAGE_DESC");
            InputStream is = item.getBinaryStream("DATA");
            this.data = this.storage_desc == null ? JDBCStorageConnection.this.readValueData(this.id, this.orderNum, this.version, is) : JDBCStorageConnection.this.readValueData(JDBCStorageConnection.this.getIdentifier(this.id), this.orderNum, this.storage_desc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TempPropertyData
    implements Comparable<TempPropertyData> {
        protected final int orderNum;
        protected ValueData data;

        public TempPropertyData(ResultSet item) throws SQLException {
            this(item, true);
        }

        public TempPropertyData(ResultSet item, boolean readValue) throws SQLException {
            this.orderNum = item.getInt("ORDER_NUM");
            this.data = readValue ? new ByteArrayPersistedValueData(this.orderNum, item.getBytes("DATA")) : null;
        }

        @Override
        public int compareTo(TempPropertyData o) {
            return this.orderNum - o.orderNum;
        }

        public ValueData getValueData() {
            return this.data;
        }
    }

    protected class TempNodeData {
        public String cid;
        public String cname;
        public int cversion;
        public String cpid;
        public int cindex;
        public int cnordernumb;
        public Map<String, SortedSet<TempPropertyData>> properties = new HashMap<String, SortedSet<TempPropertyData>>();

        public TempNodeData(ResultSet item) throws SQLException {
            this.cid = item.getString("ID");
            this.cname = item.getString("NAME");
            this.cversion = item.getInt("VERSION");
            this.cpid = item.getString("PARENT_ID");
            this.cindex = item.getInt("I_INDEX");
            this.cnordernumb = item.getInt("N_ORDER_NUM");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MixinInfo {
        static final int OWNEABLE = 1;
        static final int PRIVILEGEABLE = 2;
        static final int OWNEABLE_PRIVILEGEABLE = 3;
        final List<InternalQName> mixinTypes;
        final boolean owneable;
        final boolean privilegeable;
        final String parentId;

        public MixinInfo(List<InternalQName> mixinTypes, boolean owneable, boolean privilegeable) {
            this.parentId = null;
            this.mixinTypes = mixinTypes;
            this.owneable = owneable;
            this.privilegeable = privilegeable;
        }

        public InternalQName[] mixinNames() {
            if (this.mixinTypes != null) {
                InternalQName[] mns = new InternalQName[this.mixinTypes.size()];
                this.mixinTypes.toArray(mns);
                return mns;
            }
            return new InternalQName[0];
        }

        public boolean hasPrivilegeable() {
            return this.privilegeable;
        }

        public boolean hasOwneable() {
            return this.owneable;
        }

        public String getParentId() {
            return this.parentId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemLocationInfo {
        final QPath qpath;
        final List<String> ancestors;
        final String itemId;

        ItemLocationInfo(QPath qpath, List<String> ancestors, String itemId) {
            this.qpath = qpath;
            this.ancestors = ancestors;
            this.itemId = itemId;
        }
    }

    protected class WriteValueHelper
    extends ValueFileIOHelper {
        protected WriteValueHelper() {
        }

        public void writeStreamedValue(File file, ValueData value) throws IOException {
            super.writeStreamedValue(file, value);
        }
    }
}

