/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.exoplatform.commons.utils.PrivilegedFileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryHelper {
    public static List<File> listFiles(File srcPath) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (!PrivilegedFileHelper.isDirectory((File)srcPath)) {
            throw new IOException(PrivilegedFileHelper.getAbsolutePath((File)srcPath) + " is a directory");
        }
        for (File subFile : PrivilegedFileHelper.listFiles((File)srcPath)) {
            result.add(subFile);
            if (!subFile.isDirectory()) continue;
            result.addAll(DirectoryHelper.listFiles(subFile));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        FileOutputStream out;
        block6: {
            if (PrivilegedFileHelper.isDirectory((File)srcPath)) {
                if (!PrivilegedFileHelper.exists((File)dstPath)) {
                    PrivilegedFileHelper.mkdirs((File)dstPath);
                }
                String[] files = PrivilegedFileHelper.list((File)srcPath);
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            FileInputStream in = null;
            out = null;
            try {
                in = PrivilegedFileHelper.fileInputStream((File)srcPath);
                out = PrivilegedFileHelper.fileOutputStream((File)dstPath);
                DirectoryHelper.transfer(in, out);
                Object var5_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out == null) throw throwable;
                out.flush();
                ((OutputStream)out).close();
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        out.flush();
        ((OutputStream)out).close();
    }

    public static void removeDirectory(File dir) throws IOException {
        if (PrivilegedFileHelper.isDirectory((File)dir)) {
            for (File subFile : PrivilegedFileHelper.listFiles((File)dir)) {
                DirectoryHelper.removeDirectory(subFile);
            }
            if (!PrivilegedFileHelper.delete((File)dir)) {
                throw new IOException("Can't remove folder : " + PrivilegedFileHelper.getCanonicalPath((File)dir));
            }
        } else if (!PrivilegedFileHelper.delete((File)dir)) {
            throw new IOException("Can't remove file : " + PrivilegedFileHelper.getCanonicalPath((File)dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void compressDirectory(File rootPath, File dstZipPath) throws IOException {
        ZipOutputStream zip = PrivilegedFileHelper.zipOutputStream((File)dstZipPath);
        try {
            if (PrivilegedFileHelper.isDirectory((File)rootPath)) {
                String[] files = PrivilegedFileHelper.list((File)rootPath);
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.compressDirectory("", new File(rootPath, files[i]), zip);
                }
            } else {
                DirectoryHelper.compressDirectory("", rootPath, zip);
            }
            Object var6_5 = null;
            if (zip == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (zip == null) throw throwable;
            zip.flush();
            zip.close();
            throw throwable;
        }
        zip.flush();
        zip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void compressDirectory(String relativePath, File srcPath, ZipOutputStream zip) throws IOException {
        if (PrivilegedFileHelper.isDirectory((File)srcPath)) {
            zip.putNextEntry(new ZipEntry(relativePath + "/" + srcPath.getName() + "/"));
            zip.closeEntry();
            String[] files = PrivilegedFileHelper.list((File)srcPath);
            for (int i = 0; i < files.length; ++i) {
                DirectoryHelper.compressDirectory(relativePath + "/" + srcPath.getName(), new File(srcPath, files[i]), zip);
            }
            return;
        }
        FileInputStream in = PrivilegedFileHelper.fileInputStream((File)srcPath);
        try {
            zip.putNextEntry(new ZipEntry(relativePath + "/" + srcPath.getName()));
            DirectoryHelper.transfer(in, zip);
            zip.closeEntry();
            Object var6_6 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (in == null) throw throwable;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uncompressDirectory(File srcZipPath, File dstDirPath) throws IOException {
        ZipInputStream in = PrivilegedFileHelper.zipInputStream((File)srcZipPath);
        ZipEntry entry = null;
        try {
            while ((entry = in.getNextEntry()) != null) {
                Object var7_6;
                File dstFile = new File(dstDirPath, entry.getName());
                PrivilegedFileHelper.mkdirs((File)dstFile.getParentFile());
                if (entry.isDirectory()) {
                    PrivilegedFileHelper.mkdirs((File)dstFile);
                    continue;
                }
                FileOutputStream out = PrivilegedFileHelper.fileOutputStream((File)dstFile);
                try {
                    DirectoryHelper.transfer(in, out);
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                ((OutputStream)out).close();
            }
            Object var9_8 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void uncompressEveryFileFromDirectory(File srcPath, File dstPath) throws IOException {
        FileOutputStream out;
        block6: {
            if (PrivilegedFileHelper.isDirectory((File)srcPath)) {
                if (!PrivilegedFileHelper.exists((File)dstPath)) {
                    PrivilegedFileHelper.mkdirs((File)dstPath);
                }
                String[] files = PrivilegedFileHelper.list((File)srcPath);
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.uncompressEveryFileFromDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            ZipInputStream in = null;
            out = null;
            try {
                in = PrivilegedFileHelper.zipInputStream((File)srcPath);
                in.getNextEntry();
                out = PrivilegedFileHelper.fileOutputStream((File)dstPath);
                DirectoryHelper.transfer(in, out);
                Object var5_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (in != null) {
                    in.close();
                }
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            in.close();
        }
        if (out == null) return;
        ((OutputStream)out).close();
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[2048];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void renameFile(File srcFile, File dstFile) throws IOException {
        FileOutputStream out;
        block7: {
            if (PrivilegedFileHelper.exists((File)dstFile) && !PrivilegedFileHelper.delete((File)dstFile)) {
                throw new IOException("Cannot delete " + dstFile);
            }
            if (PrivilegedFileHelper.renameTo((File)srcFile, (File)dstFile)) return;
            FileInputStream in = null;
            out = null;
            try {
                try {
                    in = PrivilegedFileHelper.fileInputStream((File)srcFile);
                    out = PrivilegedFileHelper.fileOutputStream((File)dstFile);
                    DirectoryHelper.transfer(in, out);
                    PrivilegedFileHelper.delete((File)srcFile);
                }
                catch (IOException ioe) {
                    IOException newExc = new IOException("Cannot rename " + srcFile + " to " + dstFile);
                    newExc.initCause(ioe);
                    throw newExc;
                }
                Object var7_4 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        ((OutputStream)out).close();
    }
}

