/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.exception.UniqueObjectException;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupEventListenerHandler;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.hibernate.MembershipDAOImpl;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOImpl
implements GroupHandler,
GroupEventListenerHandler {
    public static final String queryFindGroupByName = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.groupName = ? ";
    public static final String queryFindGroupById = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.id = ? ";
    public static final String queryFindGroupByParent = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.parentId = ? ";
    private static final String queryFindRootGroups = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.parentId is null";
    private static final String queryFindGroupsOfUser = "select distinct g from g in class org.exoplatform.services.organization.impl.GroupImpl,      m in class org.exoplatform.services.organization.impl.MembershipImpl where m.groupId = g.id   and m.userName = ?";
    private static final String queryFindGroupByMembership = "select g from m in class org.exoplatform.services.organization.impl.MembershipImpl,      g in class org.exoplatform.services.organization.impl.GroupImpl where m.groupId = g.id   and m.userName = ?   and m.membershipType = ? ";
    private static final String queryGetAllGroups = "from g in class org.exoplatform.services.organization.impl.GroupImpl";
    private HibernateService service_;
    private List<GroupEventListener> listeners_;

    public GroupDAOImpl(HibernateService service) {
        this.service_ = service;
        this.listeners_ = new ArrayList<GroupEventListener>();
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners_.add(listener);
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        this.listeners_.remove(listener);
    }

    public final Group createGroupInstance() {
        return new GroupImpl();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        String groupId = "/" + child.getGroupName();
        GroupImpl childImpl = (GroupImpl)child;
        if (parent != null) {
            Group parentGroup = (Group)session.get(GroupImpl.class, (Serializable)((Object)parent.getId()));
            groupId = parentGroup.getId() + "/" + child.getGroupName();
            childImpl.setParentId(parentGroup.getId());
        } else if (child.getId() != null) {
            groupId = child.getId();
        }
        Object o = session.get(GroupImpl.class, (Serializable)((Object)groupId));
        if (o != null) {
            Object[] args = new Object[]{child.getGroupName()};
            throw new UniqueObjectException("OrganizationService.unique-group-exception", args);
        }
        childImpl.setId(groupId);
        if (broadcast) {
            this.preSave(child, true);
        }
        session = this.service_.openSession();
        session.save((Object)childImpl);
        if (broadcast) {
            this.postSave(child, true);
        }
        session.flush();
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(group, false);
        }
        Session session = this.service_.openSession();
        session.update((Object)group);
        if (broadcast) {
            this.postSave(group, false);
        }
        session.flush();
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Session session;
        if (broadcast) {
            this.preDelete(group);
        }
        if ((session = this.service_.openSession()).get(group.getClass(), (Serializable)((Object)group.getId())) == null) {
            throw new InvalidNameException("Can not remove group " + group.getGroupName() + "record, because group does not exist.");
        }
        session.delete((Object)group);
        List entries = session.createQuery(queryFindGroupByParent).setString(0, group.getId()).list();
        for (int i = 0; i < entries.size(); ++i) {
            this.removeGroup((Group)entries.get(i), broadcast);
        }
        MembershipDAOImpl.removeMembershipEntriesOfGroup(group, session);
        if (broadcast) {
            this.postDelete(group);
        }
        session.flush();
        return group;
    }

    static void removeGroupEntry(String groupName, Session session) throws Exception {
        List entries = session.createQuery(queryFindGroupByName).setString(0, groupName).list();
        for (int i = 0; i < entries.size(); ++i) {
            session.delete(entries.get(i));
        }
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        Session session = this.service_.openSession();
        Query q = session.createQuery(queryFindGroupByMembership).setString(0, userName).setString(1, membershipType);
        List groups = q.list();
        return groups;
    }

    public Group findGroupByName(String groupName) throws Exception {
        Session session = this.service_.openSession();
        Group group = (Group)this.service_.findOne(session, queryFindGroupByName, groupName);
        return group;
    }

    public Group findGroupById(String groupId) throws Exception {
        Session session = this.service_.openSession();
        Group group = (Group)this.service_.findOne(session, queryFindGroupById, groupId);
        return group;
    }

    public Collection findGroups(Group parent) throws Exception {
        Session session = this.service_.openSession();
        if (parent == null) {
            return session.createQuery(queryFindRootGroups).list();
        }
        return session.createQuery(queryFindGroupByParent).setString(0, parent.getId()).list();
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        Session session = this.service_.openSession();
        return session.createQuery(queryFindGroupsOfUser).setString(0, user).list();
    }

    public Collection getAllGroups() throws Exception {
        Session session = this.service_.openSession();
        Query q = session.createQuery(queryGetAllGroups);
        List groups = q.list();
        return groups;
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    public List<GroupEventListener> getGroupListeners() {
        return Collections.unmodifiableList(this.listeners_);
    }
}

