/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.exception.UniqueObjectException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBObjectQuery;
import org.exoplatform.services.database.DBPageList;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.StandardSQLDAO;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.jdbc.GroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOImpl
extends StandardSQLDAO<GroupImpl>
implements GroupHandler {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.organization.jdbc.GroupDAOImpl");
    protected ListenerService listenerService_;

    public GroupDAOImpl(ListenerService lService, ExoDatasource datasource, DBObjectMapper<GroupImpl> mapper) {
        super(datasource, mapper, GroupImpl.class);
        this.listenerService_ = lService;
    }

    public Group createGroupInstance() {
        return new GroupImpl();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        GroupImpl childImpl = (GroupImpl)child;
        String groupId = "/" + child.getGroupName();
        Connection connection = this.eXoDS_.getConnection();
        childImpl.setParentId("/");
        DBObjectQuery query = new DBObjectQuery(GroupImpl.class);
        if (parent != null) {
            query.addLIKE("GROUP_ID", parent.getId());
            Group parentGroup = (Group)super.loadUnique(connection, query.toQuery());
            groupId = parentGroup.getId() + "/" + child.getGroupName();
            childImpl.setParentId(parentGroup.getId());
        } else if (child.getId() != null) {
            groupId = child.getId();
            childImpl.setParentId("/");
        }
        query.getParameters().clear();
        query.addLIKE("GROUP_ID", groupId);
        Group o = (Group)super.loadUnique(connection, query.toQuery());
        if (o != null) {
            Object[] args = new Object[]{child.getGroupName()};
            throw new UniqueObjectException("OrganizationService.unique-group-exception", args);
        }
        if (broadcast) {
            this.listenerService_.broadcast("organization.group.preSave", (Object)this, (Object)childImpl);
        }
        childImpl.setId(groupId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------ADD GROUP " + child.getId() + " into Group" + child.getParentId()));
        }
        try {
            if (childImpl.getDBObjectId() == -1L) {
                childImpl.setDBObjectId(this.eXoDS_.getIDGenerator().generateLongId((DBObject)childImpl));
            }
            long id = childImpl.getDBObjectId();
            this.execute(connection, this.eXoDS_.getQueryBuilder().createInsertQuery(this.type_, id), childImpl);
            if (broadcast) {
                this.listenerService_.broadcast("organization.group.postSave", (Object)this, (Object)childImpl);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    public Group findGroupById(String groupId) throws Exception {
        DBObjectQuery query = new DBObjectQuery(GroupImpl.class);
        query.addLIKE("GROUP_ID", groupId);
        Group g = (Group)super.loadUnique(query.toQuery());
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------FIND GROUP BY ID: " + groupId + " _ " + (g != null)));
        }
        return g;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        if (userName == null || membershipType == null) {
            return null;
        }
        MembershipHandler membershipHandler = this.getMembershipHandler();
        List members = (List)membershipHandler.findMembershipsByUser(userName);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Membership member : members) {
            Group g;
            if (!member.getMembershipType().equals(membershipType) || (g = this.findGroupById(member.getGroupId())) == null) continue;
            groups.add(g);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------FIND GROUP BY USERNAME AND TYPE: " + userName + " - " + membershipType + " - "));
        }
        return groups;
    }

    public Collection findGroups(Group parent) throws Exception {
        String parentId = "/";
        if (parent != null) {
            parentId = parent.getId();
        }
        DBObjectQuery query = new DBObjectQuery(GroupImpl.class);
        query.addLIKE("PARENT_ID", parentId);
        DBPageList pageList = new DBPageList(20, (DAO)this, query);
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------FIND GROUP BY PARENT: " + parent));
            log.debug((Object)(" Size = " + pageList.getAvailable()));
        }
        return pageList.getAll();
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        MembershipHandler membershipHandler = this.getMembershipHandler();
        List members = (List)membershipHandler.findMembershipsByUser(user);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Membership member : members) {
            Group g = this.findGroupById(member.getGroupId());
            if (g == null || this.hasGroup(groups, g)) continue;
            groups.add(g);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------FIND GROUP BY USER: " + user + " - " + (groups != null)));
        }
        return groups;
    }

    private boolean hasGroup(List<Group> list, Group g) {
        for (Group ele : list) {
            if (!ele.getId().endsWith(g.getId())) continue;
            return true;
        }
        return false;
    }

    public Collection getAllGroups() throws Exception {
        DBObjectQuery query = new DBObjectQuery(GroupImpl.class);
        DBPageList pageList = new DBPageList(20, (DAO)this, query);
        return pageList.getAll();
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        GroupImpl groupImpl = (GroupImpl)group;
        if (broadcast) {
            this.listenerService_.broadcast("organization.group.preUpdate", (Object)this, (Object)groupImpl);
        }
        super.update((DBObject)groupImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.group.postUpdate", (Object)this, (Object)groupImpl);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        GroupImpl groupImpl = (GroupImpl)group;
        if (broadcast) {
            this.listenerService_.broadcast("organization.group.preDelete", (Object)this, (Object)groupImpl);
        }
        super.remove((DBObject)groupImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.group.postDelete", (Object)this, (Object)groupImpl);
        }
        return group;
    }

    public void addGroupEventListener(GroupEventListener listener) {
    }

    public void removeGroupEventListener(GroupEventListener listener) {
    }

    private MembershipHandler getMembershipHandler() {
        PortalContainer manager = PortalContainer.getInstance();
        OrganizationService service = (OrganizationService)manager.getComponentInstanceOfType(OrganizationService.class);
        return service.getMembershipHandler();
    }
}

