/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSXWordDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.ms-word.template.macroenabled.12"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        String text = "";
        try {
            XWPFDocument doc;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                doc = (XWPFDocument)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XWPFDocument>(){

                    @Override
                    public XWPFDocument run() throws Exception {
                        return new XWPFDocument(is);
                    }
                });
            }
            catch (IOException e) {
                throw new DocumentReadException("Can't open message.", e);
            }
            catch (OpenXML4JRuntimeException e) {
                throw new DocumentReadException("Can't open message.", e);
            }
            final XWPFWordExtractor extractor = new XWPFWordExtractor(doc);
            text = (String)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return extractor.getText();
                }
            });
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return text.trim();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties((POIXMLDocument)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XWPFDocument>(){

            @Override
            public XWPFDocument run() throws Exception {
                return new XWPFDocument(is);
            }
        }));
        return reader.getProperties();
    }
}

