/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcurrentPreloads
extends ForwardingCollection<PreloadedData> {
    private final List<Future<PreloadedData>> tasks;
    private Collection<PreloadedData> loaded;

    ConcurrentPreloads() {
        this.tasks = Lists.newArrayList();
    }

    ConcurrentPreloads(int size) {
        this.tasks = Lists.newArrayListWithCapacity((int)size);
    }

    ConcurrentPreloads add(Future<PreloadedData> futureData) {
        this.tasks.add(futureData);
        return this;
    }

    protected Collection<PreloadedData> delegate() {
        if (this.loaded == null) {
            this.loaded = this.getData();
        }
        return this.loaded;
    }

    private Collection<PreloadedData> getData() {
        return Lists.transform(this.tasks, (Function)new Function<Future<PreloadedData>, PreloadedData>(){

            public PreloadedData apply(Future<PreloadedData> preloadedDataFuture) {
                return ConcurrentPreloads.this.getPreloadedData(preloadedDataFuture);
            }
        });
    }

    protected PreloadedData getPreloadedData(Future<PreloadedData> preloadedDataFuture) {
        try {
            return preloadedDataFuture.get();
        }
        catch (ExecutionException ee) {
            return new FailedPreload(ee.getCause());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Preloading was interrupted by thread termination", ie);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailedPreload
    implements PreloadedData {
        private final Throwable t;

        public FailedPreload(Throwable t) {
            this.t = t;
        }

        @Override
        public Collection<Object> toJson() throws PreloadException {
            if (this.t instanceof PreloadException) {
                throw (PreloadException)this.t;
            }
            throw new PreloadException(this.t);
        }
    }
}

