/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.opt.JsOptimizer;
import com.google.caja.ancillary.servlet.Resources;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserAgentDb {
    static final List<String> USER_AGENTS;
    private static final List<Pair<String, ObjectConstructor>> ENV_JSON;

    private UserAgentDb() {
    }

    private static SortedSet<String> parseUserAgents(String commaSeparatedUserAgents) {
        Set uas = Sets.newTreeSet((Comparable[])commaSeparatedUserAgents.split("\\s*,\\s*"));
        uas.remove("");
        return (SortedSet)uas;
    }

    static ObjectConstructor lookupEnvJson(String commaSeparatedUserAgents) {
        return UserAgentDb.lookupLocally(UserAgentDb.parseUserAgents(commaSeparatedUserAgents));
    }

    private static ObjectConstructor lookupLocally(SortedSet<String> uas) {
        StringBuilder patternBuf = new StringBuilder();
        for (String string : uas) {
            if (patternBuf.length() != 0) {
                patternBuf.append('|');
            }
            patternBuf.append("(?:").append(Pattern.quote(string)).append(')');
        }
        Pattern p = Pattern.compile(patternBuf.toString());
        ObjectConstructor result = null;
        for (Pair pair : ENV_JSON) {
            if (!p.matcher((CharSequence)pair.a).find()) continue;
            if (result == null) {
                result = (ObjectConstructor)((ObjectConstructor)pair.b).clone();
                continue;
            }
            result = UserAgentDb.merge(result, (ObjectConstructor)pair.b);
        }
        return result;
    }

    private static ObjectConstructor merge(ObjectConstructor a, ObjectConstructor b) {
        List<ObjProperty> props = Lists.newArrayList();
        List<? extends ObjProperty> children = a.children();
        for (ObjProperty objProperty : children) {
            StringLiteral key = objProperty.getPropertyNameNode();
            if (!(objProperty instanceof ValueProperty)) continue;
            Expression avalue = ((ValueProperty)objProperty).getValueExpr();
            ObjProperty bprop = b.propertyWithName(key.getUnquotedValue());
            if (!(bprop instanceof ValueProperty) || !ParseTreeNodes.deepEquals(avalue, ((ValueProperty)bprop).getValueExpr())) continue;
            props.add(objProperty);
        }
        return new ObjectConstructor(FilePosition.UNKNOWN, props);
    }

    private static ObjectConstructor parseEnvJson(CharProducer cp, MessageQueue mq) throws ParseException {
        FilePosition pos = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, pos.source());
        tq.setInputRange(pos);
        Expression e = new Parser(tq, mq).parseExpression(true);
        if (e instanceof ObjectConstructor) {
            return (ObjectConstructor)e;
        }
        return null;
    }

    private static MessageQueue logQueue() {
        return new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext());
    }

    static {
        ENV_JSON = Lists.newArrayList();
        List<String> userAgents = Lists.newArrayList();
        String[] envJsonFiles = new String[]{};
        try {
            envJsonFiles = Resources.read(JsOptimizer.class, "env.json.list.txt").toString().split("[\r\n]+");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (String envJsonFile : envJsonFiles) {
            if ("".equals(envJsonFile)) continue;
            assert (envJsonFile.endsWith(".env.json"));
            String userAgent = envJsonFile.substring(0, envJsonFile.length() - 9).replace('_', ' ');
            userAgents.add(userAgent);
            try {
                CharProducer cp = Resources.read(JsOptimizer.class, envJsonFile);
                ObjectConstructor json = UserAgentDb.parseEnvJson(cp, UserAgentDb.logQueue());
                if (json == null) continue;
                ENV_JSON.add(Pair.pair(userAgent, json));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        USER_AGENTS = Collections.unmodifiableList(userAgents);
    }
}

