/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.io.IOException;
import java.io.Reader;

public class CapturingReader
extends Reader {
    public static final int DEFAULT_INITIAL_SIZE = 1024;
    private final Reader delegate;
    private StringBuilder buf;
    private CharSequence capture = null;

    public CapturingReader(Reader delegate, int initialSize) {
        this.delegate = delegate;
        this.buf = new StringBuilder(initialSize);
    }

    public CapturingReader(Reader delegate) {
        this(delegate, 1024);
    }

    public int read(char[] chars, int off, int len) throws IOException {
        if (this.buf == null) {
            throw new IOException("Reader is closed");
        }
        int bytesRead = this.delegate.read(chars, off, len);
        if (bytesRead < 0) {
            return bytesRead;
        }
        this.buf.append(chars, off, bytesRead);
        return bytesRead;
    }

    public void close() throws IOException {
        if (this.buf == null) {
            return;
        }
        this.capture = this.buf.toString();
        this.buf = null;
        this.delegate.close();
    }

    public CharSequence getCapture() throws IOException {
        this.close();
        return this.capture;
    }
}

