/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Name;
import java.io.PrintWriter;
import java.util.Arrays;
import junit.framework.TestCase;

public class CssSchemaTest
extends TestCase {
    private CssSchema cssSchema;

    public void setUp() throws Exception {
        super.setUp();
        this.cssSchema = CssSchema.getDefaultCss21Schema(new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext()));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.cssSchema = null;
    }

    public final void testGetCssProperty() {
        CssSchemaTest.assertNull((Object)this.cssSchema.getCssProperty(Name.css("bogus")));
        CssSchemaTest.assertNotNull((Object)this.cssSchema.getCssProperty(Name.css("font-style")));
    }

    public final void testIsKeyword() {
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("inherit")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("default")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("initial")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("auto")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("sans-serif")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("monospace")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isKeyword(Name.css("INHERIT")));
        CssSchemaTest.assertFalse((boolean)this.cssSchema.isKeyword(Name.css("not-a-keyword")));
        CssSchemaTest.assertFalse((boolean)this.cssSchema.isKeyword(Name.css("notakeyword")));
    }

    public final void testIsPropertyAllowed() {
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isPropertyAllowed(Name.css("color")));
        CssSchemaTest.assertFalse((boolean)this.cssSchema.isPropertyAllowed(Name.css("expression")));
    }

    public final void testIsFunctionAllowed() {
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isFunctionAllowed(Name.css("rgb")));
        CssSchemaTest.assertTrue((boolean)this.cssSchema.isFunctionAllowed(Name.css("rgba")));
        CssSchemaTest.assertFalse((boolean)this.cssSchema.isFunctionAllowed(Name.css("rgbb")));
        CssSchemaTest.assertFalse((boolean)this.cssSchema.isFunctionAllowed(Name.css("expression")));
    }

    public final void testPropertyInfo() {
        CssSchemaTest.assertEquals(null, (Object)this.cssSchema.getCssProperty(Name.css("bogus")));
        CssSchema.CssPropertyInfo colorInfo = this.cssSchema.getCssProperty(Name.css("color"));
        CssSchemaTest.assertEquals(null, (String)colorInfo.defaultValue);
        MoreAsserts.assertListsEqual(Arrays.asList("color"), colorInfo.dom2properties);
        CssSchema.CssPropertyInfo floatInfo = this.cssSchema.getCssProperty(Name.css("float"));
        CssSchemaTest.assertEquals((String)"none", (String)floatInfo.defaultValue);
        MoreAsserts.assertListsEqual(Arrays.asList("cssFloat", "styleFloat"), floatInfo.dom2properties);
        CssSchema.CssPropertyInfo marginTopInfo = this.cssSchema.getCssProperty(Name.css("margin-top"));
        CssSchemaTest.assertEquals((String)"0", (String)marginTopInfo.defaultValue);
        MoreAsserts.assertListsEqual(Arrays.asList("marginTop"), marginTopInfo.dom2properties);
        CssSchema.CssPropertyInfo marginBottomInfo = this.cssSchema.getCssProperty(Name.css("margin-bottom"));
        CssSchemaTest.assertEquals((String)"0", (String)marginBottomInfo.defaultValue);
        MoreAsserts.assertListsEqual(Arrays.asList("marginBottom"), marginBottomInfo.dom2properties);
    }
}

