/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMapUtil {
    private static Class<?> singleton = Collections.singletonMap(null, null).getClass();
    private static Class<?> empty = Collections.emptyMap().getClass();

    private MinMapUtil() {
    }

    public static <K, V> Map<K, V> put(Map<K, V> map, K key, V value) {
        int size = map.size();
        if (size == 0) {
            return Collections.singletonMap(key, value);
        }
        if (size == 1) {
            HashMap<K, V> map2 = new HashMap<K, V>(map);
            map2.put(key, value);
            return map2;
        }
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> dest, Map<K, V> src) {
        if (src == null) {
            return dest;
        }
        int srcSize = src.size();
        if (srcSize == 0) {
            return dest;
        }
        if (srcSize == 1) {
            Map.Entry<K, V> next = src.entrySet().iterator().next();
            return Collections.singletonMap(next.getKey(), next.getValue());
        }
        Class<?> c = dest.getClass();
        if (c == empty || c == singleton) {
            return new HashMap<K, V>(src);
        }
        dest.putAll(src);
        return dest;
    }

    public static <K, V> Map<K, V> remove(Map<K, V> map, K key) {
        int size = map.size();
        if (size == 0) {
            return map;
        }
        if (size == 1) {
            if (map.containsKey(key)) {
                return Collections.emptyMap();
            }
            return map;
        }
        map.remove(key);
        return map;
    }
}

