/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.FileSystem;
import com.google.caja.ancillary.jsdoc.JsdocMain;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.util.CajaTestCase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsdocMainTest
extends CajaTestCase {
    public final void testPackageDescriptions() throws Exception {
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        FakeFileSystem fs = new FakeFileSystem("src/init.js", "function identity(x) { return x; }", "src/foo/bar.js", "/** @fileoverview Hi *//** Foo bar */ var foo_bar;", "src/baz.js", "/** Baz */ function baz() {}", "src/boo/package.html", "Nothing here in boo.  Nothing at {@code all}.", "src/foo/package.html", "There is some stuff here in foo/bar.");
        new JsdocMain(fs, err).run(Arrays.asList("src/init.js"), Arrays.asList("src/foo/bar.js", "src/baz.js", "src/boo/package.html"), null, out);
        JsdocMainTest.assertEquals((String)"", (String)err.toString());
        JsdocMainTest.assertEquals((String)this.rerender("{  \"@fileoverview\": {    \"boo\": {      \"@description\": \"Nothing here in boo.  Nothing at <code class=\\x22prettyprint\\x22>all</code>.\",      \"@pos\": \"boo/package.html:1+1 - 46\",      \"@summary\": \"Nothing here in boo.\"    },    \"foo\": {      \"@description\": \"There is some stuff here in foo/bar.\",      \"@pos\": \"foo/package.html:1+1 - 37\",      \"@summary\": \"There is some stuff here in foo/bar.\",      \"bar.js\": {        \"@description\": \"Hi \",        \"@pos\": \"foo/bar.js:1+1 - 24\",        \"@summary\": \"Hi \"      }    }  },  \"baz\": {    \"@description\": \"Baz \",    \"@extends\": [\"Object\"],    \"@field\": {},    \"@pos\": \"baz.js:1+1 - 11\",    \"@summary\": \"Baz \",    \"@type\": [\"Function\"],    \"prototype\": {      \"@type\": [\"baz\"]    }  },  \"foo_bar\": {    \"@description\": \"Foo bar \",    \"@pos\": \"foo/bar.js:1+24 - 38\",    \"@summary\": \"Foo bar \",    \"@type\": [\"undefined\"]  }}"), (String)this.rerender(out.toString()));
    }

    private String rerender(String js) throws ParseException {
        return JsdocMainTest.render(this.jsExpr(this.fromString(js)));
    }

    static class FakeFileSystem
    implements FileSystem {
        private final Set<String> dirs;
        private final Map<String, String> files;

        FakeFileSystem(String ... pathsAndContent) {
            HashSet<String> dirs = new HashSet<String>();
            HashMap<String, String> files = new HashMap<String, String>();
            for (int i = 0; i < pathsAndContent.length; i += 2) {
                String file = pathsAndContent[i];
                String content = pathsAndContent[i + 1];
                files.put(file, content);
                String dir = file;
                while ((dir = this.dirname(dir)) != null) {
                    dirs.add(dir);
                }
            }
            this.dirs = dirs;
            this.files = files;
        }

        public String basename(String path) {
            return path.substring(path.lastIndexOf(47) + 1);
        }

        public String canonicalPath(String path) {
            return path.replaceAll("^/+|/+$", "");
        }

        public String dirname(String path) {
            int lslash = path.lastIndexOf(47);
            if (lslash < 0) {
                return null;
            }
            return path.substring(0, lslash);
        }

        public boolean exists(String path) {
            return this.isDirectory(path) || this.isFile(path);
        }

        public boolean isDirectory(String path) {
            return this.dirs.contains(path);
        }

        public boolean isFile(String path) {
            return this.files.containsKey(path);
        }

        public String join(String dir, String filename) {
            return dir + "/" + filename;
        }

        public CharProducer read(String path) {
            return CharProducer.Factory.create(new StringReader(this.files.get(path)), this.toInputSource(path));
        }

        public InputSource toInputSource(String path) {
            return new InputSource(URI.create("file:///" + path));
        }

        public OutputStream writeBytes(String path) throws IOException {
            throw new IOException(path);
        }

        public Writer write(String path) throws IOException {
            throw new IOException(path);
        }

        public void mkdir(String path) throws IOException {
            throw new IOException(path);
        }
    }
}

