/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.opensocial.GadgetParser;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.GadgetSpec;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.Planner;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.ReadableReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGadgetRewriter {
    private final MessageQueue mq;
    private final BuildInfo buildInfo;
    private CssSchema cssSchema;
    private HtmlSchema htmlSchema;
    private Planner.PlanState preconditions = PipelineMaker.DEFAULT_PRECONDS;
    private Planner.PlanState goals = PipelineMaker.DEFAULT_GOALS;

    public DefaultGadgetRewriter(BuildInfo buildInfo, MessageQueue mq) {
        this.buildInfo = buildInfo;
        this.mq = mq;
    }

    public MessageQueue getMessageQueue() {
        return this.mq;
    }

    public void setCssSchema(CssSchema cssSchema) {
        this.cssSchema = cssSchema;
    }

    public void setHtmlSchema(HtmlSchema htmlSchema) {
        this.htmlSchema = htmlSchema;
    }

    public final Planner.PlanState getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(Planner.PlanState s) {
        this.preconditions = s;
    }

    public final Planner.PlanState getGoals() {
        return this.goals;
    }

    public void setGoals(Planner.PlanState s) {
        this.goals = s;
    }

    public void rewrite(ExternalReference gadgetRef, UriFetcher fetcher, UriPolicy policy, String view, Appendable output) throws GadgetRewriteException, IOException, ParseException, UriFetcher.UriFetchException {
        assert (gadgetRef.getUri().isAbsolute()) : gadgetRef.toString();
        this.rewrite(gadgetRef.getUri(), fetcher.fetch(gadgetRef, "text/xml").getTextualContent(), fetcher, policy, view, output);
    }

    public void rewrite(URI baseUri, CharProducer gadgetSpec, UriFetcher fetcher, UriPolicy policy, String view, Appendable output) throws GadgetRewriteException, IOException, ParseException {
        GadgetParser parser = new GadgetParser();
        GadgetSpec spec = parser.parse(gadgetSpec, new InputSource(baseUri), view, this.mq);
        StringBuilder rewritten = new StringBuilder();
        this.rewriteContent(baseUri, spec.getContent(), fetcher, policy, false, (Appendable)rewritten);
        spec.setContent(rewritten.toString());
        parser.render(spec, output);
    }

    public void rewriteContent(URI baseUri, Readable gadgetSpec, UriFetcher fetcher, UriPolicy policy, boolean debug, Appendable output) throws GadgetRewriteException, IOException {
        CharProducer content = this.readReadable(gadgetSpec, new InputSource(baseUri));
        output.append(this.rewriteContent(baseUri, content, fetcher, policy, debug));
    }

    public void rewriteContent(URI baseUri, CharProducer content, UriFetcher fetcher, UriPolicy policy, boolean debug, Appendable output) throws GadgetRewriteException, IOException {
        output.append(this.rewriteContent(baseUri, content, fetcher, policy, debug));
    }

    public Pair<Node, Element> rewriteContent(URI baseUri, Node htmlContent, UriFetcher fetcher, UriPolicy policy, Map<InputSource, CharSequence> originalSources) throws GadgetRewriteException {
        PluginCompiler compiler = this.compileGadget(htmlContent, baseUri, fetcher, policy);
        StringBuilder script = new StringBuilder();
        CajoledModule cajoled = compiler.getJavascript();
        if (cajoled != null) {
            if (originalSources != null) {
                cajoled.renderWithDebugSymbols(originalSources, this.createRenderContext(new Concatenator(script)));
            } else {
                JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(script));
                cajoled.render(this.createRenderContext(tc));
                tc.noMoreTokens();
            }
        }
        Node dom = compiler.getStaticHtml();
        if (!compiler.getJobs().hasNoErrors()) {
            throw new GadgetRewriteException();
        }
        Document doc = dom.getOwnerDocument();
        Element scriptElement = doc.createElementNS("http://www.w3.org/1999/xhtml", "script");
        scriptElement.setAttributeNS("http://www.w3.org/1999/xhtml", "type", "text/javascript");
        scriptElement.appendChild(doc.createTextNode(script.toString()));
        return Pair.pair(dom, scriptElement);
    }

    private String rewriteContent(URI baseUri, CharProducer content, UriFetcher fetcher, UriPolicy policy, boolean debug) throws GadgetRewriteException {
        DocumentFragment htmlContent;
        Map<InputSource, CharSequence> originalSources = null;
        if (debug) {
            originalSources = Maps.newLinkedHashMap();
            originalSources.put(content.getCurrentPosition().source(), content.clone());
        }
        try {
            htmlContent = this.parseHtml(content, new InputSource(baseUri));
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.mq);
            throw new GadgetRewriteException(ex);
        }
        Pair<Node, Element> result = this.rewriteContent(baseUri, htmlContent, fetcher, policy, originalSources);
        Node dom = (Node)result.a;
        Element scriptElement = (Element)result.b;
        String html = dom != null ? Nodes.render(dom) : "";
        String script = scriptElement != null ? Nodes.render(scriptElement) : "";
        return html + script;
    }

    private DocumentFragment parseHtml(CharProducer htmlContent, InputSource src) throws GadgetRewriteException, ParseException {
        DomParser p = new DomParser(new HtmlLexer(htmlContent), false, src, this.mq);
        if (p.getTokenQueue().isEmpty()) {
            this.mq.addMessage((MessageTypeInt)PluginMessageType.NO_CONTENT, src);
            throw new GadgetRewriteException("No content");
        }
        return p.parseFragment();
    }

    private PluginCompiler compileGadget(Node content, URI baseUri, UriFetcher fetcher, UriPolicy policy) throws GadgetRewriteException {
        PluginMeta meta = new PluginMeta(fetcher, policy);
        PluginCompiler compiler = this.createPluginCompiler(meta, this.mq);
        compiler.setPreconditions(this.preconditions);
        compiler.setGoals(this.goals);
        compiler.addInput(new Dom(content), baseUri);
        if (!compiler.run()) {
            throw new GadgetRewriteException("Gadget has compile errors");
        }
        return compiler;
    }

    private CharProducer readReadable(Readable input, InputSource src) throws IOException {
        return CharProducer.Factory.create((Reader)new ReadableReader(input), src);
    }

    protected RenderContext createRenderContext(TokenConsumer tc) {
        return new RenderContext(tc).withAsciiOnly(true).withEmbeddable(true);
    }

    protected PluginCompiler createPluginCompiler(PluginMeta meta, MessageQueue mq) {
        PluginCompiler compiler = new PluginCompiler(this.buildInfo, meta, mq);
        if (this.cssSchema != null) {
            compiler.setCssSchema(this.cssSchema);
        }
        if (this.htmlSchema != null) {
            compiler.setHtmlSchema(this.htmlSchema);
        }
        return compiler;
    }
}

