/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.util.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuasiNode {
    private final List<QuasiNode> children;
    static final Equivalence SAFE_EQUALS = new Equivalence(){

        public boolean equivalent(Object a, Object b) {
            return QuasiNode.safeEquals(a, b);
        }
    };
    static final Equivalence EQUAL_UNESCAPED = new Equivalence(){

        public boolean equivalent(Object a, Object b) {
            return StringLiteral.getUnquotedValueOf((String)a).equals(StringLiteral.getUnquotedValueOf((String)b));
        }
    };

    protected QuasiNode(QuasiNode ... children) {
        this.children = Collections.unmodifiableList(Arrays.asList(children));
    }

    public List<QuasiNode> getChildren() {
        return this.children;
    }

    public Map<String, ParseTreeNode> match(ParseTreeNode specimen) {
        List<ParseTreeNode> specimens = Lists.newArrayList();
        specimens.add(specimen);
        Map<String, ParseTreeNode> bindings = Rule.makeBindings();
        return this.consumeSpecimens(specimens, bindings) ? bindings : null;
    }

    public ParseTreeNode substitute(Map<String, ParseTreeNode> bindings) {
        ArrayList<ParseTreeNode> results = new ArrayList<ParseTreeNode>();
        return this.createSubstitutes(results, bindings) && results.size() == 1 ? (ParseTreeNode)results.get(0) : null;
    }

    protected abstract boolean consumeSpecimens(List<ParseTreeNode> var1, Map<String, ParseTreeNode> var2);

    protected abstract boolean createSubstitutes(List<ParseTreeNode> var1, Map<String, ParseTreeNode> var2);

    public String render() {
        return this.render(0);
    }

    private String render(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append("  ");
        }
        result.append(this.toString());
        result.append("\n");
        for (QuasiNode child : this.getChildren()) {
            result.append(child.render(level + 1));
        }
        return result.toString();
    }

    protected static boolean safeEquals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    protected static boolean putIfDeepEquals(Map<String, ParseTreeNode> bindings, String key, ParseTreeNode value) {
        if (bindings.containsKey(key)) {
            return ParseTreeNodes.deepEquals(value, bindings.get(key));
        }
        if (value instanceof Identifier && value.getValue() == null) {
            return false;
        }
        bindings.put(key, value);
        return true;
    }

    static interface Equivalence {
        public boolean equivalent(Object var1, Object var2);
    }
}

