/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataDistributionType
implements DataDistributionType {
    private static final String DEFAULT_NODE_TYPE = "nt:unstructured".intern();
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);

    @Override
    public Node getDataNode(Node rootNode, String dataId) throws PathNotFoundException, RepositoryException {
        return rootNode.getNode(this.getRelativePath(dataId));
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, nodeType, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType, List<String> mixinTypes) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, nodeType, mixinTypes, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        try {
            return this.getDataNode(rootNode, dataId);
        }
        catch (PathNotFoundException e) {
            Node node = rootNode;
            List<String> ancestors = this.getAncestors(dataId);
            int length = ancestors.size();
            for (int i = 0; i < length; ++i) {
                String nodeName = ancestors.get(i);
                try {
                    node = node.getNode(nodeName);
                    continue;
                }
                catch (PathNotFoundException e2) {
                    node = this.createNode(node, nodeName, nodeType, mixinTypes, permissions, i == length - 1, true);
                }
            }
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataNode(Node rootNode, String dataId) throws RepositoryException {
        Lock lock = this.getLock(rootNode, this.getRelativePath(dataId));
        lock.lock();
        try {
            Node node = this.getDataNode(rootNode, dataId);
            Node parentNode = node.getParent();
            node.remove();
            parentNode.save();
        }
        catch (PathNotFoundException e) {
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void migrate(Node rootNode) throws RepositoryException {
        throw new UnsupportedOperationException("The method is not supported");
    }

    @Override
    public void migrate(Node rootNode, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        throw new UnsupportedOperationException("The method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node createNode(Node parentNode, String nodeName, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions, boolean isLeaf, boolean callSave) throws RepositoryException {
        Lock lock = this.getLock(parentNode, nodeName);
        lock.lock();
        try {
            Node node = parentNode.getNode(nodeName);
            return node;
        }
        catch (PathNotFoundException e) {
            boolean useParameters = !this.useParametersOnLeafOnly() || this.useParametersOnLeafOnly() && isLeaf;
            Node node = nodeType == null || nodeType.isEmpty() || !useParameters ? parentNode.addNode(nodeName, DEFAULT_NODE_TYPE) : parentNode.addNode(nodeName, nodeType);
            if (useParameters) {
                if (permissions != null && !permissions.isEmpty()) {
                    if (node.canAddMixin("exo:privilegeable")) {
                        node.addMixin("exo:privilegeable");
                    }
                    ((ExtendedNode)node).setPermissions(permissions);
                }
                if (mixinTypes != null) {
                    int length = mixinTypes.size();
                    for (int i = 0; i < length; ++i) {
                        String mixin = mixinTypes.get(i);
                        if (!node.canAddMixin(mixin)) continue;
                        node.addMixin(mixin);
                    }
                }
            }
            if (callSave) {
                parentNode.save();
            }
            Node node2 = node;
            return node2;
        }
        finally {
            lock.unlock();
        }
    }

    private String createFullPath(Node parentNode, String relativePath) throws RepositoryException {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(((RepositoryImpl)parentNode.getSession().getRepository()).getName());
        buffer.append('/');
        buffer.append(parentNode.getSession().getWorkspace().getName());
        String rootPath = parentNode.getPath();
        buffer.append(rootPath);
        if (!rootPath.endsWith("/")) {
            buffer.append('/');
        }
        buffer.append(relativePath);
        return buffer.toString();
    }

    private Lock getLock(Node parentNode, String relativePath) throws RepositoryException {
        String fullPath = this.createFullPath(parentNode, relativePath);
        Lock lock = (Lock)this.locks.get(fullPath);
        if (lock != null) {
            return lock;
        }
        lock = new InternalLock(fullPath);
        Lock prevLock = this.locks.putIfAbsent(fullPath, lock);
        if (prevLock != null) {
            lock = prevLock;
        }
        return lock;
    }

    protected String getRelativePath(String dataId) {
        StringBuilder buffer = new StringBuilder(256);
        List<String> ancestors = this.getAncestors(dataId);
        int length = ancestors.size();
        for (int i = 0; i < length; ++i) {
            buffer.append(ancestors.get(i));
            if (i == length - 1) continue;
            buffer.append('/');
        }
        return buffer.toString();
    }

    protected abstract List<String> getAncestors(String var1);

    protected abstract boolean useParametersOnLeafOnly();

    private class InternalLock
    extends ReentrantLock {
        private static final long serialVersionUID = -3362387346368015145L;
        private final String fullPath;

        public InternalLock(String fullPath) {
            this.fullPath = fullPath;
        }

        public void unlock() {
            if (!this.hasQueuedThreads()) {
                AbstractDataDistributionType.this.locks.remove(this.fullPath, this);
            }
            super.unlock();
        }
    }
}

