/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureResourceLoader {
    private static final Logger LOG = Logger.getLogger("org.apache.shindig.gadgets");
    private HttpFetcher fetcher;
    private TimeSource timeSource = new TimeSource();
    private int updateCheckFrequency = 0;

    @Inject
    public void setHttpFetcher(HttpFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Inject
    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    @Inject(optional=true)
    public void setSupportFileUpdates(@Named(value="shindig.features.loader.file-update-check-frequency-ms") int updateCheckFrequency) {
        this.updateCheckFrequency = updateCheckFrequency;
    }

    public FeatureResource load(Uri uri, Map<String, String> attribs) throws GadgetException {
        try {
            if ("file".equals(uri.getScheme())) {
                return this.loadFile(uri.getPath(), attribs);
            }
            if ("res".equals(uri.getScheme())) {
                return this.loadResource(uri.getPath(), attribs);
            }
            return this.loadUri(uri, attribs);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, (Throwable)e);
        }
    }

    protected FeatureResource loadFile(String path, Map<String, String> attribs) throws IOException {
        return new DualModeFileResource(this.getOptPath(path), path);
    }

    protected String getFileContent(File file) {
        try {
            return ResourceLoader.getContent((File)file);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected FeatureResource loadResource(String path, Map<String, String> attribs) throws IOException {
        return new DualModeStaticResource(path, this.getResourceContent(this.getOptPath(path)), this.getResourceContent(path));
    }

    protected String getResourceContent(String resource) {
        try {
            return ResourceLoader.getContent((String)resource);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected FeatureResource loadUri(Uri uri, Map<String, String> attribs) {
        String inline = attribs.get("inline");
        inline = inline != null ? inline : "";
        return new UriResource(this.fetcher, uri, "1".equals(inline) || "true".equalsIgnoreCase(inline));
    }

    protected String getOptPath(String orig) {
        if (orig.endsWith(".js") && !orig.endsWith(".opt.js")) {
            return orig.substring(0, orig.length() - 3) + ".opt.js";
        }
        return orig;
    }

    protected boolean fileHasChanged(File file, long lastModified) {
        return file.lastModified() > lastModified;
    }

    private static final class UriResource
    implements FeatureResource {
        private final HttpFetcher fetcher;
        private final Uri uri;
        private final boolean isInline;
        private String content;
        private long lastLoadTryMs;

        private UriResource(HttpFetcher fetcher, Uri uri, boolean isInline) {
            this.fetcher = fetcher;
            this.uri = uri;
            this.isInline = isInline;
            this.lastLoadTryMs = 0L;
            this.content = this.getContent();
        }

        public String getContent() {
            if (this.isExternal()) {
                return this.uri.toString();
            }
            if (this.content != null) {
                return this.content;
            }
            long now = System.currentTimeMillis();
            if (this.fetcher != null && now > this.lastLoadTryMs + 60000L) {
                this.lastLoadTryMs = now;
                try {
                    HttpRequest request = new HttpRequest(this.uri);
                    HttpResponse response = this.fetcher.fetch(request);
                    if (response.getHttpStatusCode() == 200) {
                        this.content = response.getResponseAsString();
                    } else {
                        LOG.warning("Unable to retrieve remote library from " + this.uri);
                    }
                }
                catch (GadgetException e) {
                    LOG.warning("Unable to retrieve remote library from " + this.uri);
                }
            }
            return this.content;
        }

        public String getDebugContent() {
            return this.getContent();
        }

        public boolean isExternal() {
            return !this.isInline;
        }

        public boolean isProxyCacheable() {
            return this.content != null;
        }
    }

    private static final class DualModeStaticResource
    extends FeatureResource.Default {
        private final String content;
        private final String debugContent;

        private DualModeStaticResource(String path, String content, String debugContent) {
            this.content = content != null ? content : debugContent;
            this.debugContent = debugContent != null ? debugContent : content;
            Preconditions.checkArgument((this.content != null ? 1 : 0) != 0, (String)"Problems reading resource: %s", (Object[])new Object[]{path});
        }

        public String getContent() {
            return this.content;
        }

        public String getDebugContent() {
            return this.debugContent;
        }
    }

    private class DualModeFileResource
    extends FeatureResource.Default {
        private final FileContent optContent;
        private final FileContent dbgContent;

        protected DualModeFileResource(String optFilePath, String dbgFilePath) {
            this.optContent = new FileContent(optFilePath);
            this.dbgContent = new FileContent(dbgFilePath);
            Preconditions.checkArgument((this.optContent.get() != null || this.dbgContent.get() != null ? 1 : 0) != 0, (String)"Problems reading resource: %s", (Object[])new Object[]{dbgFilePath});
        }

        public String getContent() {
            String opt = this.optContent.get();
            return opt != null ? opt : this.dbgContent.get();
        }

        public String getDebugContent() {
            String dbg = this.dbgContent.get();
            return dbg != null ? dbg : this.optContent.get();
        }

        private final class FileContent {
            private final String filePath;
            private long lastModified;
            private long lastUpdateCheckTime;
            private String content;

            private FileContent(String filePath) {
                this.filePath = filePath;
                this.lastModified = 0L;
                this.lastUpdateCheckTime = 0L;
            }

            private String get() {
                long nowTime = FeatureResourceLoader.this.timeSource.currentTimeMillis();
                if (this.content == null || FeatureResourceLoader.this.updateCheckFrequency > 0 && this.lastUpdateCheckTime + (long)FeatureResourceLoader.this.updateCheckFrequency < nowTime) {
                    this.lastUpdateCheckTime = nowTime;
                    File file = new File(this.filePath);
                    if (FeatureResourceLoader.this.fileHasChanged(file, this.lastModified)) {
                        String newContent = FeatureResourceLoader.this.getFileContent(file);
                        if (newContent != null) {
                            this.content = newContent;
                            this.lastModified = file.lastModified();
                        } else if (this.content != null) {
                            LOG.warning("File existed before but is now missing! Name: " + this.filePath);
                        }
                    }
                }
                return this.content;
            }
        }
    }
}

