/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl;

import java.util.HashMap;
import java.util.Map;
import org.gatein.common.io.IOTools;
import org.gatein.common.io.Serialization;
import org.gatein.common.io.SerializationFilter;
import org.gatein.common.util.Base64;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.PortletURL;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.controller.state.PortletPageNavigationalState;

public class ControllerRequestParameterMapFactory {
    private final Serialization<PortletPageNavigationalState> serialization;

    public ControllerRequestParameterMapFactory(Serialization<PortletPageNavigationalState> serialization) {
        this.serialization = serialization;
    }

    public Map<String, String> encode(PortletPageNavigationalState pageNS, String windowId, ContainerURL containerURL) {
        String type;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("windowid", windowId);
        if (containerURL instanceof ActionURL) {
            type = "action";
        } else if (containerURL instanceof RenderURL) {
            type = "render";
        } else if (containerURL instanceof ResourceURL) {
            type = "resource";
        } else {
            throw new Error();
        }
        parameters.put("phase", type);
        String pageNavigationalState = null;
        if (pageNS != null) {
            byte[] bytes = IOTools.serialize(this.serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (Object)pageNS);
            pageNavigationalState = Base64.encodeBytes((byte[])bytes, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
        }
        if (containerURL instanceof PortletURL) {
            PortletURL portletURL = (PortletURL)containerURL;
            if (portletURL.getMode() != null) {
                parameters.put("mode", portletURL.getMode().toString());
            }
            if (portletURL.getWindowState() != null) {
                parameters.put("windowstate", portletURL.getWindowState().toString());
            }
            if (pageNavigationalState != null) {
                parameters.put("pagenavigationalstate", pageNavigationalState);
            }
            if (containerURL instanceof ActionURL) {
                ActionURL actionURL = (ActionURL)containerURL;
                if (actionURL.getNavigationalState() != null) {
                    parameters.put("navigationalstate", actionURL.getNavigationalState().getStringValue());
                }
                StateString interactionState = actionURL.getInteractionState();
                parameters.put("interactionstate", interactionState.getStringValue());
            } else {
                RenderURL renderURL = (RenderURL)containerURL;
                Map changes = renderURL.getPublicNavigationalStateChanges();
                byte[] bytes = IOTools.serialize((Serialization)Serialization.PARAMETER_MAP, (SerializationFilter)SerializationFilter.COMPRESSOR, (Object)changes);
                String ns = Base64.encodeBytes((byte[])bytes, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
                parameters.put("publicnavigationalstatechanges", ns);
                StateString navigationalState = renderURL.getNavigationalState();
                if (navigationalState != null) {
                    parameters.put("navigationalstate", navigationalState.getStringValue());
                }
            }
        } else {
            ResourceURL resourceURL = (ResourceURL)containerURL;
            StateString resourceState = resourceURL.getResourceState();
            parameters.put("resourcestate", resourceState.getStringValue());
            String resourceId = resourceURL.getResourceId();
            if (resourceId != null) {
                parameters.put("resourceid", resourceId);
            }
            CacheLevel cacheability = resourceURL.getCacheability();
            parameters.put("resourcecacheability", cacheability.name());
            if (cacheability != CacheLevel.FULL) {
                if (resourceURL.getNavigationalState() != null) {
                    parameters.put("navigationalstate", resourceURL.getNavigationalState().getStringValue());
                }
                if (resourceURL.getMode() != null) {
                    parameters.put("mode", resourceURL.getMode().toString());
                }
                if (resourceURL.getWindowState() != null) {
                    parameters.put("windowstate", resourceURL.getWindowState().toString());
                }
                if (cacheability == CacheLevel.PAGE && pageNavigationalState != null) {
                    parameters.put("pagenavigationalstate", pageNavigationalState);
                }
            }
        }
        return parameters;
    }
}

