/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractSessionValueData;
import org.exoplatform.services.jcr.impl.dataflow.EditableValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TransientValueData
implements ValueData {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.TransientValueData");
    protected ValueData delegate;

    public TransientValueData(int orderNumber, byte[] bytes, InputStream stream, SpoolFile spoolFile, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory, boolean deleteSpoolFile, boolean closeTmpStream) throws IOException {
        this.delegate = new NewValueData(orderNumber, bytes, stream, spoolFile, fileCleaner, maxBufferSize, tempDirectory, deleteSpoolFile, closeTmpStream);
    }

    public TransientValueData(int orderNumber, byte[] bytes, InputStream stream, SpoolFile spoolFile, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory, boolean deleteSpoolFile) throws IOException {
        this.delegate = new NewValueData(orderNumber, bytes, stream, spoolFile, fileCleaner, maxBufferSize, tempDirectory, deleteSpoolFile, true);
    }

    public TransientValueData(int orderNumber, InputStream stream, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory, boolean deleteSpoolFile) throws IOException {
        this.delegate = new NewValueData(orderNumber, null, stream, null, fileCleaner, maxBufferSize, tempDirectory, deleteSpoolFile, true);
    }

    public TransientValueData(int orderNumber, SpoolFile spoolFile, FileCleaner fileCleaner, boolean deleteSpoolFile) throws IOException {
        this.delegate = new NewValueData(orderNumber, null, null, spoolFile, fileCleaner, -1, null, deleteSpoolFile, true);
    }

    public TransientValueData(byte[] value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, byte[] value) {
        this.delegate = new NewValueData(orderNumber, value);
    }

    public TransientValueData(InputStream stream) {
        this(0, stream);
    }

    public TransientValueData(int orderNumber, InputStream stream) {
        this.delegate = new NewValueData(orderNumber, stream);
    }

    public TransientValueData(String value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, String value) {
        this(orderNumber, TransientValueData.stringToBytes(value));
    }

    public TransientValueData(boolean value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, boolean value) {
        this(orderNumber, Boolean.valueOf(value).toString().getBytes());
    }

    public TransientValueData(Calendar value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, Calendar value) {
        this(orderNumber, new JCRDateFormat().serialize(value));
    }

    public TransientValueData(double value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, double value) {
        this(orderNumber, Double.valueOf(value).toString().getBytes());
    }

    public TransientValueData(long value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, long value) {
        this(orderNumber, Long.valueOf(value).toString().getBytes());
    }

    public TransientValueData(InternalQName value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, InternalQName value) {
        this(orderNumber, TransientValueData.stringToBytes(value.getAsString()));
    }

    public TransientValueData(QPath value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, QPath value) {
        this(orderNumber, TransientValueData.stringToBytes(value.getAsString()));
    }

    public TransientValueData(Identifier value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, Identifier value) {
        this(orderNumber, value.getString().getBytes());
    }

    public TransientValueData(AccessControlEntry value) {
        this(0, value);
    }

    public TransientValueData(int orderNumber, AccessControlEntry value) {
        this(orderNumber, TransientValueData.stringToBytes(value.getAsString()));
    }

    public TransientValueData(AbstractPersistedValueData persistent) {
        this.delegate = persistent;
    }

    protected TransientValueData() {
    }

    protected static byte[] stringToBytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    public byte[] getAsByteArray() throws IllegalStateException, IOException {
        return this.delegate.getAsByteArray();
    }

    public InputStream getAsStream() throws IOException {
        return this.delegate.getAsStream();
    }

    public long getLength() {
        return this.delegate.getLength();
    }

    public boolean isByteArray() {
        return this.delegate.isByteArray();
    }

    public long read(OutputStream stream, long length, long position) throws IOException {
        return this.delegate.read(stream, length, position);
    }

    public int getOrderNumber() {
        return this.delegate.getOrderNumber();
    }

    public void delegate(ValueData newValue) {
        this.delegate = newValue;
    }

    public SpoolFile getSpoolFile() {
        if (this.delegate instanceof NewValueData) {
            return ((NewValueData)this.delegate).spoolFile;
        }
        return null;
    }

    public InputStream getOriginalStream() {
        if (this.delegate instanceof NewValueData) {
            return ((NewValueData)this.delegate).tmpStream;
        }
        return null;
    }

    public boolean equals(ValueData another) {
        if (this == another) {
            return true;
        }
        return this.delegate.equals(another);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueData) {
            return this.equals((ValueData)obj);
        }
        return false;
    }

    protected class NewValueData
    extends AbstractSessionValueData {
        protected byte[] data;
        protected InputStream tmpStream;
        protected SpoolFile spoolFile;
        protected final boolean closeTmpStream;
        protected FileChannel spoolChannel;
        protected FileCleaner fileCleaner;
        protected int maxBufferSize;
        protected File tempDirectory;
        protected boolean spooled;
        protected boolean isTransient;
        private boolean deleteSpoolFile;

        private NewValueData(int orderNumber, byte[] value) {
            super(orderNumber);
            this.spooled = false;
            this.isTransient = true;
            this.data = value;
            this.deleteSpoolFile = true;
            this.closeTmpStream = false;
        }

        private NewValueData(int orderNumber, InputStream stream) {
            super(orderNumber);
            this.spooled = false;
            this.isTransient = true;
            this.tmpStream = stream;
            this.deleteSpoolFile = true;
            this.closeTmpStream = false;
        }

        protected NewValueData(int orderNumber, byte[] bytes, InputStream stream, SpoolFile spoolFile, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory, boolean deleteSpoolFile, boolean closeTmpStream) throws IOException {
            super(orderNumber);
            this.spooled = false;
            this.isTransient = true;
            this.data = bytes;
            this.tmpStream = stream;
            this.closeTmpStream = closeTmpStream;
            this.spoolFile = spoolFile;
            this.fileCleaner = fileCleaner;
            this.maxBufferSize = maxBufferSize;
            this.tempDirectory = tempDirectory;
            this.deleteSpoolFile = deleteSpoolFile;
            if (spoolFile != null) {
                spoolFile.acquire(this);
                if (this.tmpStream != null) {
                    this.tmpStream.close();
                    this.tmpStream = null;
                }
                this.spooled = true;
            }
        }

        public byte[] getAsByteArray() throws IOException {
            if (this.isByteArrayAfterSpool()) {
                return this.data;
            }
            return this.fileToByteArray();
        }

        private InputStream getAsStream(boolean needSpool) throws IOException {
            if (needSpool) {
                if (this.isByteArrayAfterSpool()) {
                    return new ByteArrayInputStream(this.data);
                }
                if (this.spoolFile != null) {
                    return PrivilegedFileHelper.fileInputStream((File)this.spoolFile);
                }
                throw new IllegalArgumentException("Stream already consumed");
            }
            if (this.data != null) {
                return new ByteArrayInputStream(this.data);
            }
            if (this.spoolFile != null) {
                return PrivilegedFileHelper.fileInputStream((File)this.spoolFile);
            }
            if (this.tmpStream != null) {
                return this.tmpStream;
            }
            throw new IllegalArgumentException("Null Stream data ");
        }

        public InputStream getAsStream() throws IOException {
            return this.getAsStream(true);
        }

        public long getLength() {
            if (this.isByteArrayAfterSpool()) {
                return this.data.length;
            }
            return PrivilegedFileHelper.length((File)this.spoolFile);
        }

        public boolean isByteArray() {
            return this.data != null;
        }

        public EditableValueData createEditableCopy() throws RepositoryException {
            if (this.isByteArrayAfterSpool()) {
                byte[] newBytes = new byte[this.data.length];
                System.arraycopy(this.data, 0, newBytes, 0, newBytes.length);
                try {
                    return new EditableValueData(newBytes, this.orderNumber, this.fileCleaner, this.maxBufferSize, this.tempDirectory);
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            try {
                EditableValueData copy = new EditableValueData(this.spoolFile, this.orderNumber, this.fileCleaner, this.maxBufferSize, this.tempDirectory);
                return copy;
            }
            catch (FileNotFoundException e) {
                throw new RepositoryException("Create transient copy error. " + e, (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("Create transient copy error. " + e, (Throwable)e);
            }
        }

        public long read(OutputStream stream, long length, long position) throws IOException {
            if (position < 0L) {
                throw new IOException("Position must be higher or equals 0. But given " + position);
            }
            if (length < 0L) {
                throw new IOException("Length must be higher or equals 0. But given " + length);
            }
            if (this.isByteArrayAfterSpool()) {
                if (position >= (long)this.data.length && position > 0L) {
                    throw new IOException("Position " + position + " out of value size " + this.data.length);
                }
                if (position + length >= (long)this.data.length) {
                    length = (long)this.data.length - position;
                }
                stream.write(this.data, (int)position, (int)length);
                return length;
            }
            if (this.spoolChannel == null) {
                this.spoolChannel = PrivilegedFileHelper.fileInputStream((File)this.spoolFile).getChannel();
            }
            if (position >= this.spoolChannel.size() && position > 0L) {
                throw new IOException("Position " + position + " out of value size " + this.spoolChannel.size());
            }
            if (position + length >= this.spoolChannel.size()) {
                length = this.spoolChannel.size() - position;
            }
            MappedByteBuffer bb = this.spoolChannel.map(FileChannel.MapMode.READ_ONLY, position, length);
            WritableByteChannel ch = Channels.newChannel(stream);
            ch.write(bb);
            ch.close();
            return length;
        }

        @Deprecated
        public String getString() throws IOException {
            return new String(this.getAsByteArray(), "UTF-8");
        }

        protected void finalize() throws Throwable {
            this.deleteCurrentSpoolFile();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(ValueData another) {
            if (this == another) {
                return true;
            }
            if (this.isByteArray() != another.isByteArray()) return false;
            try {
                File dataFile;
                if (this.isByteArray()) {
                    return Arrays.equals(this.getAsByteArray(), another.getAsByteArray());
                }
                if (another instanceof TransientValueData) {
                    TransientValueData transnt = (TransientValueData)another;
                    if (transnt.delegate instanceof NewValueData) {
                        NewValueData otherVd = (NewValueData)transnt.delegate;
                        if (this.tmpStream == otherVd.tmpStream) {
                            return true;
                        }
                        dataFile = otherVd.spoolFile;
                    } else {
                        if (!(transnt.delegate instanceof FilePersistedValueData)) return false;
                        dataFile = ((FilePersistedValueData)transnt.delegate).getFile();
                    }
                } else {
                    if (!(another instanceof FilePersistedValueData)) return false;
                    FilePersistedValueData persisted = (FilePersistedValueData)another;
                    dataFile = persisted.getFile();
                }
                if (this.spoolFile == null) return false;
                boolean bl = this.spoolFile.equals(dataFile);
                return bl;
            }
            catch (IOException e) {
                LOG.error((Object)"Read error", (Throwable)e);
                return false;
            }
        }

        /*
         * Loose catch block
         */
        @Deprecated
        protected void spoolInputStreamAlways() {
            block17: {
                if (this.spooled || this.tmpStream == null) {
                    return;
                }
                byte[] tmpBuff = new byte[2048];
                OutputStream sfout = null;
                int read = 0;
                SpoolFile sf = SpoolFile.createTempFile("jcrvd", null, this.tempDirectory);
                sf.acquire(this);
                sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
                while ((read = this.tmpStream.read(tmpBuff)) >= 0) {
                    sfout.write(tmpBuff, 0, read);
                }
                this.spoolChannel = null;
                this.spoolFile = sf;
                this.data = null;
                this.spooled = true;
                Object var6_6 = null;
                try {
                    if (sfout != null) {
                        sfout.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Error of spool output close.", (Throwable)e);
                }
                if (this.closeTmpStream) {
                    try {
                        this.tmpStream.close();
                        break block17;
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error of source input close.", (Throwable)e);
                    }
                    {
                    }
                }
                break block17;
                {
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (sfout != null) {
                            sfout.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error of spool output close.", (Throwable)e);
                    }
                    if (this.closeTmpStream) {
                        try {
                            this.tmpStream.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Error of source input close.", (Throwable)e);
                        }
                    }
                    this.tmpStream = null;
                    throw throwable;
                }
            }
            this.tmpStream = null;
        }

        private boolean isByteArrayAfterSpool() {
            if (this.data != null) {
                return true;
            }
            this.spoolInputStream();
            return this.data != null;
        }

        /*
         * Loose catch block
         */
        protected void spoolInputStream() {
            block21: {
                if (this.spooled || this.tmpStream == null) {
                    return;
                }
                byte[] buffer = new byte[]{};
                byte[] tmpBuff = new byte[2048];
                int read = 0;
                int len = 0;
                SpoolFile sf = null;
                OutputStream sfout = null;
                while ((read = this.tmpStream.read(tmpBuff)) >= 0) {
                    if (sfout != null) {
                        sfout.write(tmpBuff, 0, read);
                        len += read;
                        continue;
                    }
                    if (len + read > this.maxBufferSize && this.fileCleaner != null) {
                        sf = SpoolFile.createTempFile("jcrvd", null, this.tempDirectory);
                        sf.acquire(this);
                        sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
                        sfout.write(buffer, 0, len);
                        sfout.write(tmpBuff, 0, read);
                        buffer = null;
                        len += read;
                        continue;
                    }
                    byte[] newBuffer = new byte[len + read];
                    System.arraycopy(buffer, 0, newBuffer, 0, len);
                    System.arraycopy(tmpBuff, 0, newBuffer, len, read);
                    buffer = newBuffer;
                    len += read;
                }
                if (sf != null) {
                    this.spoolChannel = null;
                    this.spoolFile = sf;
                    this.data = null;
                } else {
                    this.spoolChannel = null;
                    this.spoolFile = null;
                    this.data = buffer;
                }
                this.spooled = true;
                Object var9_9 = null;
                try {
                    if (sfout != null) {
                        sfout.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Error of spool output close.", (Throwable)e);
                }
                if (this.closeTmpStream) {
                    try {
                        this.tmpStream.close();
                        break block21;
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error of source input close.", (Throwable)e);
                    }
                    {
                    }
                }
                break block21;
                {
                    catch (IOException e) {
                        throw new IllegalStateException("Error of spooling to temp file from " + this.tmpStream + ". Check if stream is not consumed or is not closed.", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        if (sfout != null) {
                            sfout.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error of spool output close.", (Throwable)e);
                    }
                    if (this.closeTmpStream) {
                        try {
                            this.tmpStream.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Error of source input close.", (Throwable)e);
                        }
                    }
                    this.tmpStream = null;
                    throw throwable;
                }
            }
            this.tmpStream = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] fileToByteArray() throws IOException {
            ByteBuffer bb;
            FileChannel fch;
            block4: {
                byte[] byArray;
                fch = PrivilegedFileHelper.fileInputStream((File)this.spoolFile).getChannel();
                if (LOG.isDebugEnabled() && fch.size() > (long)this.maxBufferSize) {
                    LOG.debug((Object)("Potential lack of memory due to call getAsByteArray() on stream data exceeded " + fch.size() + " bytes"));
                }
                try {
                    bb = ByteBuffer.allocate((int)fch.size());
                    fch.read(bb);
                    if (!bb.hasArray()) break block4;
                    byArray = bb.array();
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    fch.close();
                    throw throwable;
                }
                fch.close();
                return byArray;
            }
            byte[] tmpb = new byte[bb.capacity()];
            bb.get(tmpb);
            byte[] byArray = tmpb;
            Object var6_6 = null;
            fch.close();
            return byArray;
        }

        private void deleteCurrentSpoolFile() throws IOException {
            if (this.spoolChannel != null) {
                this.spoolChannel.close();
            }
            if (this.spoolFile != null) {
                if (this.spoolFile instanceof SpoolFile) {
                    this.spoolFile.release(this);
                }
                if (this.deleteSpoolFile && PrivilegedFileHelper.exists((File)this.spoolFile) && !PrivilegedFileHelper.delete((File)this.spoolFile)) {
                    if (this.fileCleaner != null) {
                        this.fileCleaner.addFile(this.spoolFile);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Could not remove file. Add to fileCleaner " + PrivilegedFileHelper.getAbsolutePath((File)this.spoolFile)));
                        }
                    } else {
                        LOG.warn((Object)("Could not remove temporary file on finalize " + PrivilegedFileHelper.getAbsolutePath((File)this.spoolFile)));
                    }
                }
            }
        }
    }
}

