/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.opensocial.GadgetParser;
import com.google.caja.opensocial.GadgetSpec;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.TestUtil;
import java.io.StringReader;
import java.net.URI;
import junit.framework.Assert;
import junit.framework.TestCase;

public class GadgetParserTest
extends TestCase {
    public final void testListFriends() throws Exception {
        this.testFile("listfriends.xml", new Tests(){

            public final void test(GadgetSpec spec) {
                Assert.assertEquals((int)1, (int)spec.getRequiredFeatures().size());
                Assert.assertEquals((String)"opensocial-0.5", (String)spec.getRequiredFeatures().get(0));
                Assert.assertEquals((int)1, (int)spec.getModulePrefs().size());
                Assert.assertEquals((String)"My Friends List", (String)spec.getModulePrefs().get("title"));
                Assert.assertEquals((String)"html", (String)spec.getContentType());
            }
        });
    }

    public final void testTestParsing() throws Exception {
        this.testFile("test-parsing.xml", new Tests(){

            public final void test(GadgetSpec spec) {
                Assert.assertEquals((int)2, (int)spec.getRequiredFeatures().size());
                Assert.assertEquals((String)"opensocial-0.5", (String)spec.getRequiredFeatures().get(0));
                Assert.assertEquals((String)"dynamic-height", (String)spec.getRequiredFeatures().get(1));
                Assert.assertEquals((int)10, (int)spec.getModulePrefs().size());
                Assert.assertEquals((String)"A title", (String)spec.getModulePrefs().get("title"));
                Assert.assertEquals((String)"html", (String)spec.getContentType());
            }
        });
    }

    private GadgetSpec parseFile(String gadgetFile, String view) throws Exception {
        return this.parseString(TestUtil.readResource(((Object)((Object)this)).getClass(), gadgetFile), view);
    }

    private GadgetSpec parseString(String gadgetSpec, String view) throws Exception {
        InputSource is = new InputSource(URI.create("test:///" + this.getName()));
        return new GadgetParser().parse(CharProducer.Factory.create(new StringReader(gadgetSpec), is), is, view, TestUtil.createTestMessageQueue(new MessageContext()));
    }

    private String render(GadgetSpec spec) throws Exception {
        StringBuilder output = new StringBuilder();
        new GadgetParser().render(spec, output);
        return output.toString();
    }

    private void testFile(String gadgetFile, Tests tests) throws Exception {
        GadgetSpec spec = this.parseFile(gadgetFile, "canvas");
        tests.test(spec);
        tests.test(this.parseString(this.render(spec), "canvas"));
    }

    private static interface Tests {
        public void test(GadgetSpec var1);
    }
}

