/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.portlet.URLUtils;
import org.exoplatform.social.portlet.profile.UIBasicInfoSection;
import org.exoplatform.social.portlet.profile.UIContactSection;
import org.exoplatform.social.portlet.profile.UIExperienceSection;
import org.exoplatform.social.portlet.profile.UIHeaderSection;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/component/UIProfile.gtmpl")
public class UIProfile
extends UIContainer {
    public UIProfile() throws Exception {
        List sections = this.getSections();
        for (Class sect : sections) {
            this.addChild(sect, null, null);
        }
    }

    private List getSections() {
        ArrayList<Class> sects = new ArrayList<Class>();
        sects.add(UIHeaderSection.class);
        sects.add(UIBasicInfoSection.class);
        sects.add(UIContactSection.class);
        sects.add(UIExperienceSection.class);
        return sects;
    }

    public Profile getProfile() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Identity id = im.getIdentityByRemoteId("organization", this.getCurrentProfileID());
        if (id == null) {
            return null;
        }
        return id.getProfile();
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String rUser = context.getRemoteUser();
        if (rUser == null) {
            return false;
        }
        return this.getCurrentProfileID().equals(rUser);
    }

    private String getCurrentProfileID() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

