/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profilelist;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.RelationshipManager;
import org.exoplatform.social.portlet.profilelist.UIDisplayProfileList;
import org.exoplatform.social.portlet.profilelist.UIProfileList;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIProfileList.gtmpl", events={@EventConfig(listeners={ChangeViewActionListener.class})})
public class UIProfileList
extends UIContainer {
    List tempList = null;
    Identity currIdentity = null;
    List<Relationship> tempRelList = null;
    Type currType = null;
    Type displayType = null;

    public UIProfileList() throws Exception {
        this.addChild(UIDisplayProfileList.class, null, null);
    }

    public List getList() {
        return this.tempList;
    }

    public Type getCurrentType() {
        return this.currType;
    }

    public List load(Type type) throws Exception {
        if (type.equals((Object)Type.ALL)) {
            this.tempList = this.loadAllProfiles();
        } else if (type.equals((Object)Type.PENDING)) {
            this.tempList = this.loadPendingList();
        } else if (type.equals((Object)Type.CONTACTS)) {
            this.tempList = this.loadContactList();
        }
        this.currType = type;
        return this.tempList;
    }

    public void unloadTemporaryVar() {
        this.tempList = null;
        this.currType = null;
        this.tempRelList = null;
    }

    public Status getContactStatus(Identity identity) throws Exception {
        if (this.tempRelList == null) {
            this.tempRelList = this.loadRelationList();
        }
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Status.SELF;
        }
        for (Relationship rel : this.tempRelList) {
            if (!rel.getIdentity1().getId().equals(identity.getId()) && !rel.getIdentity2().getId().equals(identity.getId())) continue;
            if (rel.getStatus().equals((Object)Relationship.Type.CONFIRM)) {
                return Status.CONTACTS;
            }
            if (rel.getStatus().equals((Object)Relationship.Type.PENDING)) {
                if (rel.getIdentity2().getId().equals(identity.getId())) {
                    return Status.PENDING;
                }
                return Status.REQUIRE_VALIDATION;
            }
            if (!rel.getStatus().equals((Object)Relationship.Type.IGNORE)) continue;
            return Status.PENDING;
        }
        return Status.ALIEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRender(WebuiRequestContext context) throws Exception {
        try {
            super.processRender(context);
        }
        finally {
            this.unloadTemporaryVar();
        }
    }

    private List<Identity> loadAllProfiles() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        List ids = im.getIdentities("organization");
        return ids;
    }

    private List<Relationship> loadPendingList() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RelationshipManager rm = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        Identity currId = this.getCurrentIdentity();
        return rm.getPending(currId, true);
    }

    private List<Relationship> loadContactList() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RelationshipManager rm = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        Identity currId = this.getCurrentIdentity();
        return rm.getContacts(currId);
    }

    private List<Relationship> loadRelationList() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RelationshipManager rm = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        Identity currId = this.getCurrentIdentity();
        return rm.get(currId);
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public Identity getCurrentIdentity() throws Exception {
        if (this.currIdentity == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            this.currIdentity = im.getIdentityByRemoteId("organization", this.getCurrentUserName());
        }
        return this.currIdentity;
    }

    private void setDisplayType(Type type) {
        this.displayType = type;
    }

    public Type getDisplayType() {
        return this.displayType;
    }

    static /* synthetic */ void access$000(UIProfileList x0, Type x1) {
        x0.setDisplayType(x1);
    }
}

